/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.http.server.DefaultHttpServiceProcessor;
import org.apache.axis2.transport.http.server.HttpConnectionManager;
import org.apache.axis2.transport.http.server.HttpFactory;
import org.apache.axis2.transport.http.server.HttpServiceProcessor;
import org.apache.axis2.transport.http.server.IOProcessor;
import org.apache.axis2.transport.http.server.IOProcessorCallback;
import org.apache.axis2.transport.http.server.SessionManager;
import org.apache.axis2.transport.http.server.WorkerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpServerConnection;
import org.apache.http.params.HttpParams;

public class DefaultHttpConnectionManager
implements HttpConnectionManager {
    private static Log LOG = LogFactory.getLog((Class)DefaultHttpConnectionManager.class);
    private final ConfigurationContext configurationContext;
    private final Executor executor;
    private final WorkerFactory workerfactory;
    private final HttpParams params;
    private final List processors;
    private final SessionManager sessionManager;
    private HttpFactory httpFactory = null;

    public DefaultHttpConnectionManager(ConfigurationContext configurationContext, Executor executor, WorkerFactory workerfactory, HttpParams params) {
        if (configurationContext == null) {
            throw new IllegalArgumentException("Configuration context may not be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Executor may not be null");
        }
        if (workerfactory == null) {
            throw new IllegalArgumentException("Worker factory may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.configurationContext = configurationContext;
        this.sessionManager = new SessionManager();
        this.executor = executor;
        this.workerfactory = workerfactory;
        this.params = params;
        this.processors = new LinkedList();
    }

    public DefaultHttpConnectionManager(ConfigurationContext configurationContext, Executor executor, WorkerFactory workerfactory, HttpParams params, HttpFactory httpFactory) {
        this(configurationContext, executor, workerfactory, params);
        this.httpFactory = httpFactory;
    }

    private synchronized void cleanup() {
        Iterator i = this.processors.iterator();
        while (i.hasNext()) {
            IOProcessor processor = (IOProcessor)i.next();
            if (!processor.isDestroyed()) continue;
            i.remove();
        }
    }

    private synchronized void addProcessor(IOProcessor processor) {
        if (processor == null) {
            return;
        }
        this.processors.add(processor);
    }

    private synchronized void removeProcessor(IOProcessor processor) {
        if (processor == null) {
            return;
        }
        this.processors.remove(processor);
    }

    public void process(HttpServerConnection conn) {
        if (conn == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        this.cleanup();
        IOProcessorCallback callback = new IOProcessorCallback(){

            public void completed(IOProcessor processor) {
                DefaultHttpConnectionManager.this.removeProcessor(processor);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(processor + " terminated"));
                }
            }
        };
        HttpServiceProcessor processor = this.httpFactory != null ? this.httpFactory.newRequestServiceProcessor(conn, this.sessionManager, this.workerfactory.newWorker(), callback) : new DefaultHttpServiceProcessor(conn, this.configurationContext, this.sessionManager, this.workerfactory.newWorker(), callback);
        processor.setParams(this.params);
        this.addProcessor(processor);
        this.executor.execute((Runnable)processor);
    }

    public synchronized void shutdown() {
        for (int i = 0; i < this.processors.size(); ++i) {
            IOProcessor processor = (IOProcessor)this.processors.get(i);
            processor.destroy();
        }
        this.processors.clear();
    }
}

