/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.util;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.RequestURIBasedDispatcher;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.util.SchemaUtil;
import org.apache.ws.commons.schema.XmlSchemaElement;

public class RESTUtil {
    protected ConfigurationContext configurationContext;

    public RESTUtil(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public boolean processPostRequest(MessageContext msgContext, HttpServletRequest request, HttpServletResponse response) throws AxisFault {
        try {
            SOAPEnvelope soapEnvelope;
            String contentType = request.getContentType();
            if ("".equals(contentType) || contentType == null) {
                throw new AxisFault("ContentType should be given to proceed, according to WSDL 2.0 HTTP binding rules");
            }
            if (contentType.indexOf("text/xml") > -1 || contentType.indexOf("multipart/related") > -1) {
                soapEnvelope = this.handleNonURLEncodedContentTypes(msgContext, request, OMAbstractFactory.getSOAP11Factory());
            } else if (contentType.indexOf("application/x-www-form-urlencoded") > -1) {
                this.dispatchAndVerify(msgContext);
                AxisOperation axisOperation = msgContext.getAxisOperation();
                XmlSchemaElement xmlSchemaElement = axisOperation.getMessage("In").getSchemaElement();
                soapEnvelope = SchemaUtil.handleMediaTypeURLEncoded(msgContext, request, xmlSchemaElement, OMAbstractFactory.getSOAP11Factory());
            } else {
                throw new AxisFault("Content type should be one of /n text/xml/n application/x-www-form-urlencoded/n multipart/related");
            }
            msgContext.setEnvelope(soapEnvelope);
            msgContext.setProperty("HTTP_METHOD", "POST");
            msgContext.setProperty("ContentType", contentType);
            msgContext.setDoingREST(true);
            msgContext.setProperty("TRANSPORT_OUT", response.getOutputStream());
            this.invokeAxisEngine(msgContext);
        }
        catch (AxisFault axisFault) {
            throw axisFault;
        }
        catch (IOException ioException) {
            throw new AxisFault(ioException);
        }
        return true;
    }

    public boolean processGetRequest(MessageContext msgContext, HttpServletRequest request, HttpServletResponse response) throws AxisFault {
        try {
            msgContext.setProperty("HTTP_METHOD", "GET");
            msgContext.setDoingREST(true);
            msgContext.setProperty("TRANSPORT_OUT", response.getOutputStream());
            this.dispatchAndVerify(msgContext);
            AxisOperation axisOperation = msgContext.getAxisOperation();
            XmlSchemaElement xmlSchemaElement = null;
            if (axisOperation != null) {
                AxisMessage axisMessage = axisOperation.getMessage("In");
                xmlSchemaElement = axisMessage.getSchemaElement();
            }
            SOAPEnvelope soapEnvelope = SchemaUtil.handleMediaTypeURLEncoded(msgContext, request, xmlSchemaElement, OMAbstractFactory.getSOAP11Factory());
            msgContext.setEnvelope(soapEnvelope);
            this.invokeAxisEngine(msgContext);
        }
        catch (AxisFault axisFault) {
            throw axisFault;
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
        return true;
    }

    private void invokeAxisEngine(MessageContext messageContext) throws AxisFault {
        AxisEngine axisEngine = new AxisEngine(this.configurationContext);
        axisEngine.receive(messageContext);
    }

    private void dispatchAndVerify(MessageContext msgContext) throws AxisFault {
        RequestURIBasedDispatcher requestDispatcher = new RequestURIBasedDispatcher();
        requestDispatcher.invoke(msgContext);
        if (msgContext.getAxisService() == null || msgContext.getAxisOperation() == null) {
            throw new AxisFault("I can not find a service for this request to be serviced. Check the WSDL and the request URI");
        }
    }

    private SOAPEnvelope handleNonURLEncodedContentTypes(MessageContext msgCtxt, HttpServletRequest request, SOAPFactory soapFactory) throws AxisFault {
        try {
            SOAPEnvelope soapEnvelope = soapFactory.getDefaultEnvelope();
            SOAPBody body = soapEnvelope.getBody();
            ServletInputStream inputStream = request.getInputStream();
            String contentType = request.getContentType();
            if (this.checkContentType("text/xml", contentType)) {
                XMLStreamReader xmlreader;
                if (TransportUtils.getCharSetEncoding(contentType) == null) {
                    xmlreader = StAXUtils.createXMLStreamReader((InputStream)inputStream, (String)"UTF-8");
                    msgCtxt.setProperty("CHARACTER_SET_ENCODING", "UTF-8");
                } else {
                    String charSetEnc = TransportUtils.getCharSetEncoding(contentType);
                    xmlreader = StAXUtils.createXMLStreamReader((InputStream)inputStream, (String)charSetEnc);
                    msgCtxt.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
                }
                OMNodeEx documentElement = (OMNodeEx)new StAXOMBuilder(xmlreader).getDocumentElement();
                documentElement.setParent(null);
                body.addChild((OMNode)documentElement);
            } else if (this.checkContentType("multipart/related", contentType)) {
                body.addChild((OMNode)TransportUtils.selectBuilderForMIME(msgCtxt, (InputStream)inputStream, contentType, false).getDocumentElement());
            }
            return soapEnvelope;
        }
        catch (Exception e) {
            throw new AxisFault("Error in creating a SOAPEnvelope from the REST request");
        }
    }

    private boolean checkContentType(String contentType, String contentTypeStringFromRequest) {
        if (contentTypeStringFromRequest == null) {
            return false;
        }
        return contentTypeStringFromRequest.indexOf(contentType) > -1;
    }
}

