/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.ThreadContextMigrator;

public class ThreadContextMigratorUtil {
    public static void addThreadContextMigrator(ConfigurationContext configurationContext, String threadContextMigratorListID, ThreadContextMigrator migrator) {
        LinkedList<ThreadContextMigrator> migratorList = (LinkedList<ThreadContextMigrator>)configurationContext.getProperty(threadContextMigratorListID);
        if (migratorList == null) {
            migratorList = new LinkedList<ThreadContextMigrator>();
            configurationContext.setProperty(threadContextMigratorListID, migratorList);
        }
        migratorList.add(migrator);
    }

    public static void performMigrationToThread(String threadContextMigratorListID, MessageContext msgContext) throws AxisFault {
        List migratorList = (List)msgContext.getConfigurationContext().getProperty(threadContextMigratorListID);
        if (migratorList != null) {
            ListIterator threadContextMigrators = migratorList.listIterator();
            while (threadContextMigrators.hasNext()) {
                ((ThreadContextMigrator)threadContextMigrators.next()).migrateContextToThread(msgContext);
            }
        }
    }

    public static void performThreadCleanup(String threadContextMigratorListID, MessageContext msgContext) {
        List migratorList = (List)msgContext.getConfigurationContext().getProperty(threadContextMigratorListID);
        if (migratorList != null) {
            ListIterator threadContextMigrators = migratorList.listIterator();
            while (threadContextMigrators.hasNext()) {
                ((ThreadContextMigrator)threadContextMigrators.next()).cleanupThread(msgContext);
            }
        }
    }

    public static void performMigrationToContext(String threadContextMigratorListID, MessageContext msgContext) throws AxisFault {
        List migratorList = (List)msgContext.getConfigurationContext().getProperty(threadContextMigratorListID);
        if (migratorList != null) {
            ListIterator threadContextMigrators = migratorList.listIterator();
            while (threadContextMigrators.hasNext()) {
                ((ThreadContextMigrator)threadContextMigrators.next()).migrateThreadToContext(msgContext);
            }
        }
    }

    public static void performContextCleanup(String threadContextMigratorListID, MessageContext msgContext) {
        List migratorList = (List)msgContext.getConfigurationContext().getProperty(threadContextMigratorListID);
        if (migratorList != null) {
            ListIterator threadContextMigrators = migratorList.listIterator();
            while (threadContextMigrators.hasNext()) {
                ((ThreadContextMigrator)threadContextMigrators.next()).cleanupContext(msgContext);
            }
        }
    }
}

