/*
 * Decompiled with CFR 0.152.
 */
package com.objectfab.tools.junitdoclet;

import com.objectfab.tools.junitdoclet.ConfigurableStrategy;
import com.objectfab.tools.junitdoclet.JUnitDocletProperties;
import com.sun.javadoc.DocErrorReporter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class DefaultConfigurableStrategy
implements ConfigurableStrategy,
JUnitDocletProperties {
    protected static final String DEFAULT_PROPERTY_FILE_NAME = "junitdoclet.properties";
    private static Properties properties;
    private String propertyFileName;
    private static Map templateCache;
    private DocErrorReporter docErrorReporter;

    public DefaultConfigurableStrategy() {
        this.init();
    }

    public void init() {
        templateCache = null;
        this.setProperties(null);
        this.setPropertyFileName(DEFAULT_PROPERTY_FILE_NAME);
        this.setDocErrorReporter(null);
    }

    public String getPropertyFileName() {
        return this.propertyFileName;
    }

    public void setPropertyFileName(String propertyFileName) {
        this.propertyFileName = propertyFileName;
    }

    public Properties getProperties() {
        if (properties == null) {
            properties = this.loadProperties(this.getPropertyFileName());
        }
        return properties;
    }

    public void setProperties(Properties properties) {
        DefaultConfigurableStrategy.properties = properties;
    }

    public Properties loadProperties(String propertyFileName) {
        Properties properties = new Properties(System.getProperties());
        properties.setProperty("license", "/**\n * Generated by JUnitDoclet, a tool provided by\n * ObjectFab GmbH under LGPL.\n * Please see www.junitdoclet.org, www.gnu.org\n * and www.objectfab.de for informations about\n * the tool, the licence and the the authors.\n */\n");
        properties.setProperty("marker.import.begin", "// JUnitDoclet begin import");
        properties.setProperty("marker.import.end", "// JUnitDoclet end import");
        properties.setProperty("marker.extends_implements.begin", "// JUnitDoclet begin extends_implements");
        properties.setProperty("marker.extends_implements.end", "// JUnitDoclet end extends_implements");
        properties.setProperty("marker.class.begin", "// JUnitDoclet begin class");
        properties.setProperty("marker.class.end", "// JUnitDoclet end class");
        properties.setProperty("marker.method.begin", "// JUnitDoclet begin method");
        properties.setProperty("marker.method.end", "// JUnitDoclet end method");
        properties.setProperty("marker.javadoc_class.begin", "// JUnitDoclet begin javadoc_class");
        properties.setProperty("marker.javadoc_class.end", "// JUnitDoclet end javadoc_class");
        properties.setProperty("marker.javadoc_method.begin", "// JUnitDoclet begin javadoc_method");
        properties.setProperty("marker.javadoc_method.end", "// JUnitDoclet end javadoc_method");
        try {
            InputStream inputStream = this.getPropertyInputStream(propertyFileName);
            properties.load(inputStream);
            String licence = this.getTemplate(properties, "licence", null);
            properties.setProperty("license", licence);
        }
        catch (Exception e) {
            this.printError("Could not find property file " + propertyFileName + ".");
        }
        return properties;
    }

    private InputStream getPropertyInputStream(String propertyFileName) {
        InputStream returnValue = null;
        File file = new File(propertyFileName);
        if (file.exists()) {
            try {
                returnValue = new BufferedInputStream(new FileInputStream(file));
                this.printNotice("Loading properties from " + file.getAbsoluteFile() + ".");
            }
            catch (IOException e) {
                this.printError("Could not load properties from " + file.getAbsoluteFile() + ".");
            }
        } else {
            returnValue = this.getClass().getClassLoader().getResourceAsStream(propertyFileName);
            if (returnValue != null) {
                this.printNotice("Loading properties " + propertyFileName + " from class path.");
            }
        }
        return returnValue;
    }

    public String getTemplate(Properties properties, String templateName, String attribute) {
        String returnValue = null;
        String qualifiedTemplate = null;
        if (templateCache == null) {
            templateCache = new HashMap();
        }
        if (templateName != null) {
            qualifiedTemplate = attribute != null ? "template." + templateName + "." + attribute : "template." + templateName;
            if (!templateCache.containsKey(qualifiedTemplate)) {
                templateCache.put(qualifiedTemplate, this.createTemplate(properties, qualifiedTemplate));
            }
            returnValue = (String)templateCache.get(qualifiedTemplate);
        } else {
            this.printError("DefaultConfigurableStrategy.getTemplate() templateName == " + templateName + " attribute == " + attribute);
        }
        return returnValue;
    }

    public String createTemplate(Properties properties, String templateName) {
        TreeMap<Integer, String> lines = new TreeMap<Integer, String>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propLine = (String)enumeration.nextElement();
            if (!propLine.startsWith(templateName + ".")) continue;
            Integer key = new Integer(propLine.substring(templateName.length() + 1));
            lines.put(key, properties.getProperty(propLine));
        }
        StringBuffer sb = new StringBuffer();
        Iterator iterator = lines.values().iterator();
        while (iterator.hasNext()) {
            sb.append((String)iterator.next());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setDocErrorReporter(DocErrorReporter reporter) {
        this.docErrorReporter = reporter;
    }

    public void printNotice(String msg) {
        if (this.docErrorReporter != null) {
            this.docErrorReporter.printNotice(msg);
        } else {
            System.out.println(msg);
        }
    }

    public void printWarning(String msg) {
        if (this.docErrorReporter != null) {
            this.docErrorReporter.printWarning(msg);
        } else {
            System.err.println(msg);
        }
    }

    public void printError(String msg) {
        if (this.docErrorReporter != null) {
            this.docErrorReporter.printError(msg);
        } else {
            System.err.println(msg);
        }
    }

    static {
        DEFAULT_PROPERTY_FILE_NAME = DEFAULT_PROPERTY_FILE_NAME;
    }
}

