/*
 * Decompiled with CFR 0.152.
 */
package com.objectfab.tools.junitdoclet;

import com.objectfab.tools.junitdoclet.DefaultConfigurableStrategy;
import com.objectfab.tools.junitdoclet.JUnitDocletProperties;
import com.objectfab.tools.junitdoclet.NamingStrategy;
import com.objectfab.tools.junitdoclet.StringHelper;

public class DefaultNamingStrategy
extends DefaultConfigurableStrategy
implements NamingStrategy,
JUnitDocletProperties {
    private static final String TEST_CASE_EXT = "Test";
    private static final String TEST_SUITE_EXT = "Suite";
    private static final String TEST_METHOD_PREFIX = "test";
    private String cachedDefaultTestSuiteName = null;
    private String subPackage = null;
    private boolean isTestInTest = false;

    public boolean isTestInTest() {
        return this.isTestInTest;
    }

    public void setTestInTest(boolean testInTest) {
        this.isTestInTest = testInTest;
    }

    public void init() {
        super.init();
        this.cachedDefaultTestSuiteName = null;
        this.setSubPackage(null);
        this.setTestInTest(false);
    }

    public String getSubPackage() {
        return this.subPackage;
    }

    public void setSubPackage(String subPackage) {
        this.subPackage = subPackage;
    }

    public boolean isTestPackageName(String packageName) {
        boolean returnValue = false;
        String subName = this.getSubPackage();
        if (subName != null) {
            returnValue = packageName != null;
            returnValue = returnValue && packageName.endsWith(subName);
        }
        return returnValue;
    }

    public boolean isTestClassName(String fullClassName) {
        boolean returnValue = true;
        String subName = this.getSubPackage();
        if (fullClassName != null) {
            if (subName != null) {
                returnValue &= this.isTestClassNameInSubpackage(fullClassName, subName);
                returnValue &= !this.isTestInTest() || this.endsLikeTestClassName(fullClassName);
            } else {
                returnValue &= this.endsLikeTestClassName(fullClassName);
            }
        } else {
            returnValue = false;
        }
        return returnValue;
    }

    private boolean isTestClassNameInSubpackage(String fullClassName, String subName) {
        return fullClassName.indexOf("." + subName + ".") != -1 || fullClassName.startsWith(subName + ".");
    }

    private boolean endsLikeTestClassName(String fullClassName) {
        return fullClassName.endsWith(TEST_SUITE_EXT) || fullClassName.endsWith(TEST_CASE_EXT);
    }

    public String stripParentPackage(String className) {
        String returnValue = null;
        int index = className.lastIndexOf(".");
        returnValue = index > 0 ? className.substring(index + 1) : className;
        return returnValue;
    }

    public String getTestCaseName(String fullClassName) {
        String returnValue = null;
        returnValue = this.stripParentPackage(fullClassName);
        returnValue = returnValue + TEST_CASE_EXT;
        return returnValue;
    }

    public String getTestSuiteName(String packageName) {
        String returnValue = null;
        if (this.cachedDefaultTestSuiteName == null) {
            this.cachedDefaultTestSuiteName = this.getProperties().getProperty("testsuite.class.name", "");
        }
        if (this.cachedDefaultTestSuiteName.length() > 0) {
            returnValue = this.cachedDefaultTestSuiteName;
        } else {
            returnValue = this.stripParentPackage(packageName);
            returnValue = StringHelper.firstToUpper(returnValue);
            returnValue = returnValue + TEST_SUITE_EXT;
        }
        return returnValue;
    }

    public String getPackageName(String fullClassName) {
        String returnValue = null;
        int index = fullClassName.lastIndexOf(".");
        returnValue = index > 0 ? fullClassName.substring(0, index) : "";
        return returnValue;
    }

    public String getTestPackageName(String packageName) {
        String returnValue = null;
        returnValue = this.getSubPackage() != null ? packageName + "." + this.getSubPackage() : packageName;
        return returnValue;
    }

    public String getFullTestCaseName(String fullClassName) {
        String testPackageName = this.getTestPackageName(this.getPackageName(fullClassName));
        String testCaseName = this.getTestCaseName(this.stripParentPackage(fullClassName));
        return this.combinePackageClass(testPackageName, testCaseName);
    }

    public String getFullTestSuiteName(String packageName) {
        String testPackageName = this.getTestPackageName(packageName);
        String testSuiteName = this.getTestSuiteName(packageName);
        return this.combinePackageClass(testPackageName, testSuiteName);
    }

    public String combinePackageClass(String packageName, String className) {
        String returnValue = packageName != null && packageName.length() > 0 ? packageName + "." + className : className;
        return returnValue;
    }

    public String getTestMethodName(String methodName) {
        StringBuffer sb = new StringBuffer(methodName);
        String first = sb.substring(0, 1);
        sb.replace(0, 1, first.toUpperCase());
        sb.insert(0, TEST_METHOD_PREFIX);
        return sb.toString();
    }

    public String getTestAccessorName(String prefixSet, String prefixGet, String accessorName) {
        StringBuffer sb = new StringBuffer(accessorName);
        String first = sb.substring(0, 1);
        sb.replace(0, 1, first.toUpperCase());
        sb.insert(0, prefixGet);
        first = sb.substring(0, 1);
        sb.replace(0, 1, first.toUpperCase());
        sb.insert(0, prefixSet);
        first = sb.substring(0, 1);
        sb.replace(0, 1, first.toUpperCase());
        sb.insert(0, TEST_METHOD_PREFIX);
        return sb.toString();
    }

    static {
        TEST_CASE_EXT = TEST_CASE_EXT;
        TEST_SUITE_EXT = TEST_SUITE_EXT;
        TEST_METHOD_PREFIX = TEST_METHOD_PREFIX;
    }
}

