/*
 * Decompiled with CFR 0.152.
 */
package com.objectfab.tools.junitdoclet;

import com.objectfab.tools.junitdoclet.JUnitDocletProperties;
import com.objectfab.tools.junitdoclet.NamingStrategy;
import com.objectfab.tools.junitdoclet.TestingStrategy;
import com.objectfab.tools.junitdoclet.ValidationHelper;
import com.objectfab.tools.junitdoclet.WritingStrategy;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class JUnitDoclet
extends Doclet
implements JUnitDocletProperties {
    protected static final String OPTION_INPUT_DIR = "-sourcepath";
    protected static final String OPTION_OUTPUT_DIR = "-d";
    protected static final String OPTION_PROPERTIES = "-properties";
    protected static final String OPTION_TESTING = "-testing";
    protected static final String OPTION_WRITING = "-writing";
    protected static final String OPTION_NAMING = "-naming";
    protected static final String OPTION_BUILDALL = "-buildall";
    protected static final String OPTION_HELP = "-help";
    protected static final String OPTION_SUBPACKAGE = "-subpackage";
    protected static final String OPTION_TEST_IN_TEST = "-testintest";
    protected static final String DEFAULT_SOURCE_PATH = "";
    protected static final String USAGE_STRING = "Parameters of JUnitDoclet       (c) 2002 ObjectFab GmbH\n-d <out_dir>                                      (required)\n            Where to write the JUnitTests\n\n-subpackage <sub_package_name>                    (optional)\n            Use a sub package to have the tests close to the\n            application but separate. Usualy the sub-package is named \"test\".\n\n-buildall                                         (optional)\n            All tests are rebuild, even if application is unchanged.\n\n-properties <property_file_name>                  (optional)\n            Holding all templates and definitions\n            (default is junitdoclet.properties)\n\n-naming <naming_strategy_class_name>              (optional)\n            Strategy class to define names\n            (default is com.objectfab.tools.junitdoclet.DefaultNamingStrategy)\n\n-writing <writing_strategy_class_name>            (optional)\n            Strategy class handle file access\n            default is com.objectfab.tools.junitdoclet.DefaultWritingStrategy)\n\n-testing <testing_strategy_class_name>            (optional)\n            Strategy class build the tests\n            default is com.objectfab.tools.junitdoclet.DefaultTestingStrategy)\n\n-testintest                                       (optional)\n            Generate TestCase for all classes that can be found in source path.\n            If set, tests will be generated for all classes that are not \n            TestCases or TestSuites themselves, even if they are in a \n            test subpackage. This option is NOT recommended.\n";
    private String sourcePath;
    private String outputRoot;
    private NamingStrategy namingStrategy;
    private WritingStrategy writingStrategy;
    private TestingStrategy testingStrategy;
    private String namingStrategyName;
    private String writingStrategyName;
    private String testingStrategyName;
    private String propertyFileName;
    private String subPackage;
    private boolean buildAll;
    private boolean isTestInTest;
    private DocErrorReporter docErrorReporter;

    public JUnitDoclet() {
        this.init();
    }

    public void init() {
        this.setBuildAll(false);
        this.setTestInTest(false);
        this.setSourcePath(null);
        this.setOutputRoot(null);
        this.setNamingStrategy(null);
        this.setWritingStrategy(null);
        this.setTestingStrategy(null);
        this.setNamingStrategyName("com.objectfab.tools.junitdoclet.DefaultNamingStrategy");
        this.setWritingStrategyName("com.objectfab.tools.junitdoclet.DefaultWritingStrategy");
        this.setTestingStrategyName("com.objectfab.tools.junitdoclet.DefaultTestingStrategy");
        this.setPropertyFileName("junitdoclet.properties");
        this.setSubPackage(null);
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String theSourcePath) {
        this.sourcePath = theSourcePath;
    }

    public String getOutputRoot() {
        return this.outputRoot;
    }

    public void setOutputRoot(String outputRoot) {
        this.outputRoot = outputRoot;
    }

    public String getPropertyFileName() {
        return this.propertyFileName;
    }

    public void setPropertyFileName(String propertyFileName) {
        this.propertyFileName = propertyFileName;
        this.getNamingStrategy().setPropertyFileName(propertyFileName);
        this.getWritingStrategy().setPropertyFileName(propertyFileName);
        this.getTestingStrategy().setPropertyFileName(propertyFileName);
    }

    public NamingStrategy getNamingStrategy() {
        if (this.namingStrategy == null) {
            this.setNamingStrategy((NamingStrategy)this.createByClassName(this.getNamingStrategyName()));
        }
        return this.namingStrategy;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
        if (namingStrategy != null) {
            namingStrategy.setPropertyFileName(this.getPropertyFileName());
            namingStrategy.setSubPackage(this.getSubPackage());
            namingStrategy.setTestInTest(this.isTestInTest());
        }
    }

    public WritingStrategy getWritingStrategy() {
        if (this.writingStrategy == null) {
            this.setWritingStrategy((WritingStrategy)this.createByClassName(this.getWritingStrategyName()));
        }
        return this.writingStrategy;
    }

    public void setWritingStrategy(WritingStrategy writingStrategy) {
        this.writingStrategy = writingStrategy;
        if (writingStrategy != null) {
            writingStrategy.setPropertyFileName(this.getPropertyFileName());
        }
    }

    public TestingStrategy getTestingStrategy() {
        if (this.testingStrategy == null) {
            this.setTestingStrategy((TestingStrategy)this.createByClassName(this.getTestingStrategyName()));
        }
        return this.testingStrategy;
    }

    public void setTestingStrategy(TestingStrategy testingStrategy) {
        this.testingStrategy = testingStrategy;
        if (testingStrategy != null) {
            testingStrategy.setPropertyFileName(this.getPropertyFileName());
        }
    }

    public String getNamingStrategyName() {
        return this.namingStrategyName;
    }

    public void setNamingStrategyName(String namingStrategyName) {
        this.namingStrategyName = namingStrategyName;
        this.setNamingStrategy(null);
    }

    public String getWritingStrategyName() {
        return this.writingStrategyName;
    }

    public void setWritingStrategyName(String writingStrategyName) {
        this.writingStrategyName = writingStrategyName;
        this.setWritingStrategy(null);
    }

    public String getTestingStrategyName() {
        return this.testingStrategyName;
    }

    public void setTestingStrategyName(String testingStrategyName) {
        this.testingStrategyName = testingStrategyName;
        this.setTestingStrategy(null);
    }

    public boolean isBuildAll() {
        return this.buildAll;
    }

    public void setBuildAll(boolean buildAll) {
        this.buildAll = buildAll;
    }

    public boolean isTestInTest() {
        return this.isTestInTest;
    }

    public void setTestInTest(boolean testInTest) {
        this.isTestInTest = testInTest;
    }

    public String getSubPackage() {
        return this.subPackage;
    }

    public void setSubPackage(String subPackage) {
        this.subPackage = subPackage;
        this.getNamingStrategy().setSubPackage(subPackage);
    }

    private Object createByClassName(String className) {
        Object returnValue = null;
        try {
            Class<?> clazz = Class.forName(className);
            returnValue = clazz.newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        return returnValue;
    }

    public boolean processPackage(PackageDoc[] docs, int index) {
        boolean returnValue = true;
        TestingStrategy testing = this.getTestingStrategy();
        WritingStrategy writing = this.getWritingStrategy();
        NamingStrategy naming = this.getNamingStrategy();
        if (testing.isTestablePackage(docs[index], naming)) {
            String fullTestSuiteName = naming.getFullTestSuiteName(docs[index].name());
            StringBuffer oldCode = writing.loadClassSource(this.getOutputRoot(), fullTestSuiteName);
            if (oldCode == null || testing.isValid(oldCode.toString())) {
                StringBuffer newCode = new StringBuffer();
                returnValue = testing.codeTestSuite(docs, index, naming, newCode, testing.getProperties());
                if (testing.isValid(newCode.toString())) {
                    writing.indent(newCode);
                    if (testing.merge(newCode, oldCode, fullTestSuiteName) && this.isWritingNeeded(newCode, oldCode)) {
                        this.printNotice("Writing TestSuite " + fullTestSuiteName + ".");
                        writing.writeClassSource(this.getOutputRoot(), fullTestSuiteName, newCode);
                    }
                } else {
                    this.printError("Could not generate TestSuite " + fullTestSuiteName + " (possible reason: missing or wrong properties).");
                }
            } else if (oldCode != null) {
                this.printWarning("TestSuite " + fullTestSuiteName + " is invalid. It's not overwritten.");
            }
        }
        return returnValue;
    }

    public boolean processClass(ClassDoc doc, PackageDoc packageDoc) {
        boolean returnValue = true;
        TestingStrategy testing = this.getTestingStrategy();
        WritingStrategy writing = this.getWritingStrategy();
        NamingStrategy naming = this.getNamingStrategy();
        if (packageDoc == null) {
            packageDoc = doc.containingPackage();
        }
        String fullClassName = doc.qualifiedTypeName();
        String fullTestCaseName = naming.getFullTestCaseName(fullClassName);
        if (testing.isTestableClass(doc, naming)) {
            if (this.isGenerationNeeded(fullClassName, fullTestCaseName)) {
                StringBuffer oldCode = writing.loadClassSource(this.getOutputRoot(), fullTestCaseName);
                if (oldCode == null || testing.isValid(oldCode.toString())) {
                    StringBuffer newCode = new StringBuffer();
                    returnValue = testing.codeTestCase(doc, packageDoc, this.getNamingStrategy(), newCode, testing.getProperties());
                    if (testing.isValid(newCode.toString())) {
                        writing.indent(newCode);
                        if (testing.merge(newCode, oldCode, fullTestCaseName)) {
                            if (this.isWritingNeeded(newCode, oldCode)) {
                                this.printNotice("Writing TestCase " + fullTestCaseName + ".");
                                writing.writeClassSource(this.getOutputRoot(), fullTestCaseName, newCode);
                            } else {
                                this.printNotice("TestCase " + fullTestCaseName + " did not change but " + fullClassName + " did.");
                            }
                        }
                    } else {
                        this.printError("Could not generate TestCase " + fullTestCaseName + " (possible reason: missing or wrong properties).");
                    }
                } else if (oldCode != null) {
                    this.printWarning("TestCase " + fullTestCaseName + " is invalid. It's not overwritten.");
                }
            } else {
                returnValue = true;
            }
        } else {
            returnValue = true;
        }
        return returnValue;
    }

    public boolean isGenerationNeeded(String fullClassName, String fullTestCaseName) {
        boolean returnValue = this.isBuildAll();
        returnValue = returnValue || !this.getWritingStrategy().isExistingAndNewer(this.getOutputRoot(), fullTestCaseName, this.getSourcePath(), fullClassName);
        return returnValue;
    }

    public boolean isWritingNeeded(StringBuffer newCode, StringBuffer oldCode) {
        boolean returnValue = this.isBuildAll();
        returnValue = returnValue || oldCode == null;
        returnValue = returnValue || newCode != null && oldCode != null && !newCode.toString().equals(oldCode.toString());
        return returnValue;
    }

    public static boolean start(RootDoc doc) {
        JUnitDoclet instance = new JUnitDoclet();
        instance.setOptions(doc.options());
        instance.setDocErrorReporter((DocErrorReporter)doc);
        return instance.execute(doc);
    }

    public void setDocErrorReporter(DocErrorReporter doc) {
        this.docErrorReporter = doc;
        this.getNamingStrategy().setDocErrorReporter(doc);
        this.getWritingStrategy().setDocErrorReporter(doc);
        this.getTestingStrategy().setDocErrorReporter(doc);
    }

    public boolean execute(RootDoc doc) {
        boolean returnValue = true;
        this.printNotice("Generating TestSuites and TestCases.");
        ClassDoc[] classDocs = doc.specifiedClasses();
        int i = 0;
        while (i < classDocs.length) {
            returnValue = returnValue && this.processClass(classDocs[i], null);
            ++i;
        }
        PackageDoc[] packageDocs = doc.specifiedPackages();
        int i2 = 0;
        while (i2 < packageDocs.length) {
            classDocs = packageDocs[i2].ordinaryClasses();
            int j = 0;
            while (j < classDocs.length) {
                returnValue = returnValue && this.processClass(classDocs[j], packageDocs[i2]);
                ++j;
            }
            returnValue = returnValue && this.processPackage(packageDocs, i2);
            ++i2;
        }
        return returnValue;
    }

    public void setOptions(String[][] options) {
        int i = 0;
        while (i < options.length) {
            if (options[i][0].equals(OPTION_BUILDALL)) {
                this.setBuildAll(true);
            }
            if (options[i][0].equals(OPTION_TEST_IN_TEST)) {
                this.setTestInTest(true);
            }
            if (options[i][0].equals(OPTION_INPUT_DIR)) {
                this.setSourcePath(options[i][1]);
            }
            if (options[i][0].equals(OPTION_OUTPUT_DIR)) {
                this.setOutputRoot(options[i][1]);
            }
            if (options[i][0].equals(OPTION_SUBPACKAGE)) {
                this.setSubPackage(options[i][1]);
            }
            if (options[i][0].equals(OPTION_PROPERTIES)) {
                this.setPropertyFileName(options[i][1]);
            }
            if (options[i][0].equals(OPTION_TESTING)) {
                this.setTestingStrategyName(options[i][1]);
            }
            if (options[i][0].equals(OPTION_WRITING)) {
                this.setWritingStrategyName(options[i][1]);
            }
            if (options[i][0].equals(OPTION_NAMING)) {
                this.setNamingStrategyName(options[i][1]);
            }
            ++i;
        }
    }

    public static int optionLength(String s) {
        int returnValue = 0;
        if (s.equals(OPTION_HELP)) {
            JUnitDoclet.printUsage();
        }
        if (s.equals(OPTION_BUILDALL)) {
            returnValue = 1;
        }
        if (s.equals(OPTION_TEST_IN_TEST)) {
            returnValue = 1;
        }
        if (s.equals(OPTION_OUTPUT_DIR)) {
            returnValue = 2;
        }
        if (s.equals(OPTION_PROPERTIES)) {
            returnValue = 2;
        }
        if (s.equals(OPTION_SUBPACKAGE)) {
            returnValue = 2;
        }
        if (s.equals(OPTION_TESTING)) {
            returnValue = 2;
        }
        if (s.equals(OPTION_WRITING)) {
            returnValue = 2;
        }
        if (s.equals(OPTION_NAMING)) {
            returnValue = 2;
        }
        return returnValue;
    }

    public static boolean validOptions(String[][] strings, DocErrorReporter reporter) {
        boolean returnValue = true;
        boolean foundOutput = false;
        boolean isTestInTest = false;
        String subPackage = null;
        String sourcePath = DEFAULT_SOURCE_PATH;
        String outputPath = null;
        int i = 0;
        while (i < strings.length) {
            if (strings[i][0].equals(OPTION_OUTPUT_DIR)) {
                if (!ValidationHelper.isDirectoryName(strings[i][1])) {
                    returnValue = false;
                    if (reporter != null) {
                        reporter.printError("Error:" + strings[i][1] + " is not a directory.");
                    }
                } else {
                    outputPath = strings[i][1];
                }
                foundOutput = true;
            }
            if (strings[i][0].equals(OPTION_INPUT_DIR)) {
                sourcePath = strings[i][1];
            }
            if (strings[i][0].equals(OPTION_TEST_IN_TEST)) {
                isTestInTest = true;
            }
            if (strings[i][0].equals(OPTION_PROPERTIES) && !ValidationHelper.isPropertyName(strings[i][1])) {
                returnValue = false;
                if (reporter != null) {
                    reporter.printError("Error:" + strings[i][1] + " is not a property file.");
                }
            }
            if (strings[i][0].equals(OPTION_SUBPACKAGE)) {
                if (!ValidationHelper.isPackageName(strings[i][1])) {
                    returnValue = false;
                    if (reporter != null) {
                        reporter.printError("Error:" + strings[i][1] + " is not a valid package name.");
                    }
                } else {
                    subPackage = strings[i][1];
                }
            }
            if (strings[i][0].equals(OPTION_NAMING) && !ValidationHelper.isClassName(strings[i][1])) {
                returnValue = false;
                if (reporter != null) {
                    reporter.printError("Error:" + strings[i][1] + " is not a class.");
                }
            }
            if (strings[i][0].equals(OPTION_TESTING) && !ValidationHelper.isClassName(strings[i][1])) {
                returnValue = false;
                if (reporter != null) {
                    reporter.printError("Error:" + strings[i][1] + " is not a class.");
                }
            }
            if (strings[i][0].equals(OPTION_WRITING) && !ValidationHelper.isClassName(strings[i][1])) {
                returnValue = false;
                if (reporter != null) {
                    reporter.printError("Error:" + strings[i][1] + " is not a class.");
                }
            }
            ++i;
        }
        boolean bl = returnValue = returnValue && foundOutput;
        if (returnValue && subPackage == null && !isTestInTest) {
            returnValue = !JUnitDoclet.isOutputMatchingAnySource(sourcePath, outputPath, reporter);
        }
        return returnValue;
    }

    public static boolean isOutputMatchingAnySource(String sourcePath, String outputPath, DocErrorReporter reporter) {
        boolean returnValue = false;
        String canonicalOutputPath = null;
        StringTokenizer sourcePathTokenizer = new StringTokenizer(sourcePath, File.pathSeparator);
        try {
            canonicalOutputPath = new File(outputPath).getCanonicalPath();
        }
        catch (IOException e) {
            if (reporter != null) {
                reporter.printError("Error: File '" + outputPath + "' not found (" + e.toString() + ").");
            }
            returnValue = true;
        }
        if (!returnValue && canonicalOutputPath != null) {
            while (sourcePathTokenizer.hasMoreTokens()) {
                try {
                    String canonicalSourcePath = new File(sourcePathTokenizer.nextToken()).getCanonicalPath();
                    if (!canonicalOutputPath.equals(canonicalSourcePath)) continue;
                    returnValue = true;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (returnValue && reporter != null) {
                reporter.printError("Error: value of -d must not be in value of -sourcepath.\nYou may override this restriction with -testintest.");
            }
        }
        return returnValue;
    }

    private static void printUsage() {
        System.out.println(USAGE_STRING);
    }

    private void printError(String msg) {
        if (this.docErrorReporter != null) {
            this.docErrorReporter.printError(msg);
        } else {
            System.err.println(msg);
        }
    }

    private void printWarning(String msg) {
        if (this.docErrorReporter != null) {
            this.docErrorReporter.printWarning(msg);
        } else {
            System.err.println(msg);
        }
    }

    private void printNotice(String msg) {
        if (this.docErrorReporter != null) {
            this.docErrorReporter.printNotice(msg);
        } else {
            System.out.println(msg);
        }
    }

    static {
        OPTION_INPUT_DIR = OPTION_INPUT_DIR;
        OPTION_OUTPUT_DIR = OPTION_OUTPUT_DIR;
        OPTION_PROPERTIES = OPTION_PROPERTIES;
        OPTION_TESTING = OPTION_TESTING;
        OPTION_WRITING = OPTION_WRITING;
        OPTION_NAMING = OPTION_NAMING;
        OPTION_BUILDALL = OPTION_BUILDALL;
        OPTION_HELP = OPTION_HELP;
        OPTION_SUBPACKAGE = OPTION_SUBPACKAGE;
        OPTION_TEST_IN_TEST = OPTION_TEST_IN_TEST;
        DEFAULT_SOURCE_PATH = DEFAULT_SOURCE_PATH;
        USAGE_STRING = USAGE_STRING;
    }
}

