/*
 * Decompiled with CFR 0.152.
 */
package com.objectfab.tools.junitdoclet;

import java.util.Enumeration;
import java.util.Properties;

public class StringHelper {
    private static final String VARIABLE_START = "${";
    private static final String VARIABLE_END = "}";
    private static final int MAX_DEPTH = 10;

    public static int indexOfStringInStringBuffer(StringBuffer sb, String str) {
        int returnValue = -1;
        if (sb != null && str != null) {
            returnValue = sb.toString().indexOf(str);
        }
        return returnValue;
    }

    public static int indexOfTwoPartString(String code, String partOne, String partTwo, int startIndex) {
        int returnValue = -1;
        if (code != null && partOne != null && partTwo != null) {
            int possibleIndex = Math.max(startIndex, 0);
            int codeLength = code.length();
            boolean endOfCode = false;
            while (returnValue == -1 && !endOfCode) {
                int possibleOne = code.indexOf(partOne, possibleIndex);
                if (possibleOne > -1) {
                    possibleIndex = possibleOne + partOne.length();
                    int possibleTwo = code.indexOf(partTwo, possibleIndex);
                    while (possibleIndex < codeLength && Character.isWhitespace(code.charAt(possibleIndex))) {
                        ++possibleIndex;
                    }
                    if (possibleIndex != possibleTwo) continue;
                    returnValue = possibleOne;
                    continue;
                }
                endOfCode = true;
            }
        } else {
            StringHelper.err("indexOfTwoPartString() code=" + code + " partOne=" + partOne + " partTwo=" + partTwo);
        }
        return returnValue;
    }

    public static String firstToUpper(String s) {
        StringBuffer sb = new StringBuffer(s);
        if (sb.length() > 0) {
            sb.replace(0, 1, "" + Character.toUpperCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    public static String replaceVariables(String template, Properties properties) {
        String returnValue = null;
        if (template != null && properties != null) {
            boolean foundSomething;
            int depth = 0;
            StringBuffer sb = new StringBuffer(template);
            do {
                foundSomething = false;
                Enumeration<?> e = properties.propertyNames();
                while (e.hasMoreElements()) {
                    boolean foundKey;
                    String key = (String)e.nextElement();
                    String variable = VARIABLE_START + key + VARIABLE_END;
                    int idxOld = -1;
                    do {
                        foundKey = false;
                        int idx = StringHelper.indexOfStringInStringBuffer(sb, variable);
                        if (idx < 0) continue;
                        if (idx <= idxOld) {
                            ++depth;
                        }
                        foundKey = true;
                        foundSomething = true;
                        String replacement = properties.getProperty(key);
                        idxOld = idx + replacement.length();
                        sb.replace(idx, idx + variable.length(), replacement);
                    } while (foundKey && depth < 10);
                }
            } while (foundSomething && ++depth < 10);
            if (depth >= 10) {
                throw new RuntimeException("Error in templates: To many recursions.");
            }
            returnValue = sb.toString();
        } else {
            StringHelper.err("replaceVariables() template=" + template + " properties=" + properties);
        }
        return returnValue;
    }

    public static boolean haveEqualContent(StringBuffer a, StringBuffer b) {
        boolean returnValue = false;
        if (a != null && b != null) {
            returnValue = a.toString().equals(b.toString());
        }
        if (a == null && b == null) {
            returnValue = true;
        }
        return returnValue;
    }

    private static void err(String msg) {
        System.out.println("StringHelper." + msg);
    }

    static {
        VARIABLE_START = VARIABLE_START;
        VARIABLE_END = VARIABLE_END;
        MAX_DEPTH = 10;
    }
}

