/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sourceforge.jtds.jdbc.ColInfo;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.Driver;
import net.sourceforge.jtds.jdbc.DummyResultSet;
import net.sourceforge.jtds.jdbc.JtdsResultSet;
import net.sourceforge.jtds.jdbc.JtdsStatement;
import net.sourceforge.jtds.jdbc.Messages;

public class JtdsDatabaseMetaData
implements DatabaseMetaData {
    static final int sqlStateXOpen = 1;
    int tdsVersion;
    ConnectionJDBC2 connection;
    int sysnameLength = 30;
    Boolean caseSensitive = null;

    public JtdsDatabaseMetaData(ConnectionJDBC2 connection) {
        this.connection = connection;
        this.tdsVersion = connection.getTdsVersion();
        if (this.tdsVersion >= 3) {
            this.sysnameLength = 128;
        }
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        String query = "exec sp_special_columns ?, ?, ?, ?, ?, ?, ?";
        if (catalog != null) {
            query = this.tdsVersion >= 3 ? "exec [" + catalog + "]..sp_special_columns ?, ?, ?, ?, ?, ?, ?" : "exec " + catalog + "..sp_special_columns ?, ?, ?, ?, ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, table);
        s.setString(2, schema);
        s.setString(3, catalog);
        s.setString(4, "R");
        s.setString(5, "T");
        s.setString(6, "U");
        s.setInt(7, 3);
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        rs.setColName(5, "COLUMN_SIZE");
        rs.setColLabel(5, "COLUMN_SIZE");
        rs.setColName(6, "BUFFER_LENGTH");
        rs.setColLabel(6, "BUFFER_LENGTH");
        rs.setColName(7, "DECIMAL_DIGITS");
        rs.setColLabel(7, "DECIMAL_DIGITS");
        return rs;
    }

    public ResultSet getCatalogs() throws SQLException {
        String query = "exec sp_tables '', '', '%', NULL";
        Statement s = this.connection.createStatement();
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery(query);
        rs.setColumnCount(1);
        rs.setColName(1, "TABLE_CAT");
        rs.setColLabel(1, "TABLE_CAT");
        return rs;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        String query = "exec sp_column_privileges ?, ?, ?, ?";
        if (catalog != null) {
            query = this.tdsVersion >= 3 ? "exec [" + catalog + "]..sp_column_privileges ?, ?, ?, ?" : "exec " + catalog + "..sp_column_privileges ?, ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, table);
        s.setString(2, schema);
        s.setString(3, catalog);
        s.setString(4, columnNamePattern);
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        rs.setColName(1, "TABLE_CAT");
        rs.setColLabel(1, "TABLE_CAT");
        rs.setColName(2, "TABLE_SCHEM");
        rs.setColLabel(2, "TABLE_SCHEM");
        return rs;
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String query = "exec sp_columns ?, ?, ?, ?, ?";
        if (catalog != null) {
            query = this.tdsVersion >= 3 ? "exec [" + catalog + "]..sp_columns ?, ?, ?, ?, ?" : "exec " + catalog + "..sp_columns ?, ?, ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, tableNamePattern);
        s.setString(2, schemaPattern);
        s.setString(3, catalog);
        s.setString(4, columnNamePattern);
        s.setInt(5, 3);
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        rs.setColName(1, "TABLE_CAT");
        rs.setColLabel(1, "TABLE_CAT");
        rs.setColName(2, "TABLE_SCHEM");
        rs.setColLabel(2, "TABLE_SCHEM");
        rs.setColName(7, "COLUMN_SIZE");
        rs.setColLabel(7, "COLUMN_SIZE");
        rs.setColName(8, "BUFFER_LENGTH");
        rs.setColLabel(8, "BUFFER_LENGTH");
        rs.setColName(9, "DECIMAL_DIGITS");
        rs.setColLabel(9, "DECIMAL_DIGITS");
        rs.setColName(10, "NUM_PREC_RADIX");
        rs.setColLabel(10, "NUM_PREC_RADIX");
        rs.setColumnCount(18);
        return rs;
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        String query = "exec sp_fkeys ?, ?, ?, ?, ?, ?";
        if (primaryCatalog != null) {
            query = this.tdsVersion >= 3 ? "exec [" + primaryCatalog + "]..sp_fkeys ?, ?, ?, ?, ?, ?" : "exec " + primaryCatalog + "..sp_fkeys ?, ?, ?, ?, ?, ?";
        } else if (foreignCatalog != null) {
            query = this.tdsVersion >= 3 ? "exec [" + foreignCatalog + "]..sp_fkeys ?, ?, ?, ?, ?, ?" : "exec " + foreignCatalog + "..sp_fkeys ?, ?, ?, ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, primaryTable);
        s.setString(2, primarySchema);
        s.setString(3, primaryCatalog);
        s.setString(4, foreignTable);
        s.setString(5, foreignSchema);
        s.setString(6, foreignCatalog);
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        rs.setColName(1, "PKTABLE_CAT");
        rs.setColLabel(1, "PKTABLE_CAT");
        rs.setColName(2, "PKTABLE_SCHEM");
        rs.setColLabel(2, "PKTABLE_SCHEM");
        rs.setColName(5, "FKTABLE_CAT");
        rs.setColLabel(5, "FKTABLE_CAT");
        rs.setColName(6, "FKTABLE_SCHEM");
        rs.setColLabel(6, "FKTABLE_SCHEM");
        return rs;
    }

    public String getDatabaseProductName() throws SQLException {
        return this.connection.getDatabaseProductName();
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.connection.getDatabaseProductVersion();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public int getDriverMajorVersion() {
        return 0;
    }

    public int getDriverMinorVersion() {
        return 9;
    }

    public String getDriverName() throws SQLException {
        return "jTDS Type 4 JDBC Driver for MS SQL Server and Sybase";
    }

    public String getDriverVersion() throws SQLException {
        return Driver.getVersion();
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getCrossReference(catalog, schema, table, null, null, null);
    }

    public String getExtraNameCharacters() throws SQLException {
        return "#$";
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getCrossReference(null, null, null, catalog, schema, table);
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        String query = "exec sp_statistics ?, ?, ?, ?, ?, ?";
        if (catalog != null) {
            query = this.tdsVersion >= 3 ? "exec [" + catalog + "]..sp_statistics ?, ?, ?, ?, ?, ?" : "exec " + catalog + "..sp_statistics ?, ?, ?, ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, table);
        s.setString(2, schema);
        s.setString(3, catalog);
        s.setString(4, "%");
        s.setString(5, unique ? "Y" : "N");
        s.setString(6, approximate ? "Q" : "E");
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        rs.setColName(1, "TABLE_CAT");
        rs.setColLabel(1, "TABLE_CAT");
        rs.setColName(2, "TABLE_SCHEM");
        rs.setColLabel(2, "TABLE_SCHEM");
        rs.setColName(8, "ORDINAL_POSITION");
        rs.setColLabel(8, "ORDINAL_POSITION");
        rs.setColName(10, "ASC_OR_DESC");
        rs.setColLabel(10, "ASC_OR_DESC");
        return rs;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 131072;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 131072;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.tdsVersion >= 3 ? 0 : 16;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.tdsVersion >= 3 ? 0 : 16;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 4000;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return this.tdsVersion >= 3 ? 1024 : 250;
    }

    public int getMaxConnections() throws SQLException {
        return Short.MAX_VALUE;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxIndexLength() throws SQLException {
        return 900;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxRowSize() throws SQLException {
        return this.tdsVersion >= 3 ? 8060 : 1962;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxStatementLength() throws SQLException {
        return 131072;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return this.tdsVersion >= 3 ? 256 : 16;
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.sysnameLength;
    }

    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String query = "exec sp_pkeys ?, ?, ?";
        if (catalog != null) {
            query = this.tdsVersion >= 3 ? "exec [" + catalog + "]..sp_pkeys ?, ?, ?" : "exec " + catalog + "..sp_pkeys ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, table);
        s.setString(2, schema);
        s.setString(3, catalog);
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        rs.setColName(1, "TABLE_CAT");
        rs.setColLabel(1, "TABLE_CAT");
        rs.setColName(2, "TABLE_SCHEM");
        rs.setColLabel(2, "TABLE_SCHEM");
        return rs;
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        String query = "exec sp_sproc_columns ?, ?, ?, ?, ?";
        if (catalog != null) {
            query = this.tdsVersion >= 3 ? "exec [" + catalog + "]..sp_sproc_columns ?, ?, ?, ?, ?" : "exec " + catalog + "..sp_sproc_columns ?, ?, ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, procedureNamePattern);
        s.setString(2, schemaPattern);
        s.setString(3, catalog);
        s.setString(4, columnNamePattern);
        s.setInt(5, 3);
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        rs.setColName(1, "PROCEDURE_CAT");
        rs.setColLabel(1, "PROCEDURE_CAT");
        rs.setColName(2, "PROCEDURE_SCHEM");
        rs.setColLabel(2, "PROCEDURE_SCHEM");
        return rs;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String query = "exec sp_stored_procedures ?, ?, ?";
        if (catalog != null) {
            query = this.tdsVersion >= 3 ? "exec [" + catalog + "]..sp_stored_procedures ?, ?, ?" : "exec " + catalog + "..sp_stored_procedures ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, procedureNamePattern);
        s.setString(2, schemaPattern);
        s.setString(3, catalog);
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        rs.setColName(1, "PROCEDURE_CAT");
        rs.setColLabel(1, "PROCEDURE_CAT");
        rs.setColName(2, "PROCEDURE_SCHEM");
        rs.setColLabel(2, "PROCEDURE_SCHEM");
        return rs;
    }

    public String getProcedureTerm() throws SQLException {
        return "stored procedure";
    }

    public ResultSet getSchemas() throws SQLException {
        Statement statement = this.connection.createStatement();
        String sql = Driver.JDBC3 ? "SELECT name AS TABLE_SCHEM, NULL as TABLE_CATALOG FROM dbo.sysusers" : "SELECT name AS TABLE_SCHEM FROM dbo.sysusers";
        sql = this.tdsVersion >= 3 ? sql + " WHERE islogin=1" : sql + " WHERE uid>0";
        sql = sql + " ORDER BY TABLE_SCHEM";
        return statement.executeQuery(sql);
    }

    public String getSchemaTerm() throws SQLException {
        return "owner";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getSQLKeywords() throws SQLException {
        return "BREAK,BROWSE,BULK,CHECKPOINT,CLUSTERED,COMMITTED,COMPUTE,CONFIRM,CONTROLROW,DATABASE,DBCC,DISK,DISTRIBUTED,DUMMY,DUMP,ERRLVL,ERROREXIT,EXIT,FILE,FILLFACTOR,FLOPPY,HOLDLOCK,IDENTITY_INSERT,IDENTITYCOL,IF,KILL,LINENO,LOAD,MIRROREXIT,NONCLUSTERED,OFF,OFFSETS,ONCE,OVER,PERCENT,PERM,PERMANENT,PLAN,PRINT,PROC,PROCESSEXIT,RAISERROR,READ,READTEXT,RECONFIGURE,REPEATABLE,RETURN,ROWCOUNT,RULE,SAVE,SERIALIZABLE,SETUSER,SHUTDOWN,STATISTICS,TAPE,TEMP,TEXTSIZE,TOP,TRAN,TRIGGER,TRUNCATE,TSEQUEL,UNCOMMITTED,UPDATETEXT,USE,WAITFOR,WHILE,WRITETEXT";
    }

    public String getStringFunctions() throws SQLException {
        return "ASCII,CHAR,CONCAT,DIFFERENCE,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,SUBSTRING,UCASE";
    }

    public String getSystemFunctions() throws SQLException {
        return "DATABASE,IFNULL,USER";
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String query = "exec sp_table_privileges ?, ?, ?";
        if (catalog != null) {
            query = this.tdsVersion >= 3 ? "exec [" + catalog + "]..sp_table_privileges ?, ?, ?" : "exec " + catalog + "..sp_table_privileges ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, tableNamePattern);
        s.setString(2, schemaPattern);
        s.setString(3, catalog);
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        rs.setColName(1, "TABLE_CAT");
        rs.setColLabel(1, "TABLE_CAT");
        rs.setColName(2, "TABLE_SCHEM");
        rs.setColLabel(2, "TABLE_SCHEM");
        return rs;
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String query = "exec sp_tables ?, ?, ?, ?";
        if (catalog != null) {
            query = this.tdsVersion >= 3 ? "exec [" + catalog + "]..sp_tables ?, ?, ?, ?" : "exec " + catalog + "..sp_tables ?, ?, ?, ?";
        }
        CallableStatement cstmt = this.connection.prepareCall(query);
        cstmt.setString(1, tableNamePattern);
        cstmt.setString(2, schemaPattern);
        cstmt.setString(3, catalog);
        if (types == null) {
            cstmt.setString(4, null);
        } else {
            StringBuffer buf = new StringBuffer(64);
            buf.append('\"');
            int i = 0;
            while (i < types.length) {
                buf.append('\'').append(types[i]).append("',");
                ++i;
            }
            if (buf.length() > 1) {
                buf.setLength(buf.length() - 1);
            }
            buf.append('\"');
            cstmt.setString(4, buf.toString());
        }
        JtdsResultSet rs = (JtdsResultSet)cstmt.executeQuery();
        rs.setColName(1, "TABLE_CAT");
        rs.setColLabel(1, "TABLE_CAT");
        rs.setColName(2, "TABLE_SCHEM");
        rs.setColLabel(2, "TABLE_SCHEM");
        return rs;
    }

    public ResultSet getTableTypes() throws SQLException {
        String sql = "select 'SYSTEM TABLE' TABLE_TYPE union select 'TABLE' TABLE_TYPE union select 'VIEW' TABLE_TYPE order by TABLE_TYPE";
        Statement stmt = this.connection.createStatement();
        return stmt.executeQuery(sql);
    }

    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,TIMESTAMPADD,TIMESTAMPDIFF,SECOND,WEEK,YEAR";
    }

    public ResultSet getTypeInfo() throws SQLException {
        Statement s = this.connection.createStatement();
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery("exec sp_datatype_info @ODBCVer=3");
        rs.setColumnCount(18);
        rs.setColName(11, "FIXED_PREC_SCALE");
        rs.setColLabel(11, "FIXED_PREC_SCALE");
        return rs;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String[] colNames = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS"};
        ColInfo[] columns = new ColInfo[6];
        int i = 0;
        while (i < 6) {
            columns[i] = new ColInfo();
            ++i;
        }
        JtdsStatement dummyStmt = (JtdsStatement)this.connection.createStatement();
        DummyResultSet rs = new DummyResultSet(dummyStmt, columns, null);
        int i2 = 0;
        while (i2 < 6) {
            int column = i2 + 1;
            rs.setColType(column, 12);
            rs.setColLabel(column, colNames[i2]);
            rs.setColName(column, colNames[i2]);
            ++i2;
        }
        return rs;
    }

    public String getURL() throws SQLException {
        return this.connection.getUrl();
    }

    public String getUserName() throws SQLException {
        String result;
        Statement s;
        block6: {
            s = null;
            ResultSet rs = null;
            result = "";
            try {
                s = this.connection.createStatement();
                rs = this.connection.getServerType() == 2 ? s.executeQuery("select suser_name()") : s.executeQuery("select system_user");
                if (!rs.next()) {
                    throw new SQLException(Messages.get("error.dbmeta.nouser"), "HY000");
                }
                result = rs.getString(1);
                Object var5_4 = null;
                if (rs == null) break block6;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (rs != null) {
                    rs.close();
                }
                if (s != null) {
                    s.close();
                }
                throw throwable;
            }
            rs.close();
        }
        if (s != null) {
            s.close();
        }
        return result;
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String query = "exec sp_special_columns ?, ?, ?, ?, ?, ?, ?";
        if (catalog != null) {
            query = this.tdsVersion >= 3 ? "exec [" + catalog + "]..sp_special_columns ?, ?, ?, ?, ?, ?, ?" : "exec " + catalog + "..sp_special_columns ?, ?, ?, ?, ?, ?, ?";
        }
        CallableStatement s = this.connection.prepareCall(query);
        s.setString(1, table);
        s.setString(2, schema);
        s.setString(3, catalog);
        s.setString(4, "V");
        s.setString(5, "C");
        s.setString(6, "O");
        s.setInt(7, 3);
        JtdsResultSet rs = (JtdsResultSet)s.executeQuery();
        rs.setColName(5, "COLUMN_SIZE");
        rs.setColLabel(5, "COLUMN_SIZE");
        rs.setColName(6, "BUFFER_LENGTH");
        rs.setColLabel(6, "BUFFER_LENGTH");
        rs.setColName(7, "DECIMAL_DIGITS");
        rs.setColLabel(7, "DECIMAL_DIGITS");
        return rs;
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        this.setCaseSensitiveFlag();
        return this.caseSensitive == false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.setCaseSensitiveFlag();
        return this.caseSensitive == false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return true;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        if (fromType == toType) {
            return true;
        }
        switch (fromType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return toType != -1 && toType != -4;
            }
            case -3: 
            case -2: {
                return toType != 6 && toType != 7 && toType != 8 && toType != -4;
            }
            case -4: {
                return toType == -2 || toType == -3;
            }
            case -1: {
                return toType == 1 || toType == 12;
            }
            case 0: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return this.connection.getServerType() == 1;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.connection.getServerType() != 1;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        this.setCaseSensitiveFlag();
        return this.caseSensitive;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        this.setCaseSensitiveFlag();
        return this.caseSensitive;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return true;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return true;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return true;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return true;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return type == 1005;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return type == 1005;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    private void setCaseSensitiveFlag() throws SQLException {
        if (this.caseSensitive == null) {
            Statement s = this.connection.createStatement();
            ResultSet rs = s.executeQuery("sp_server_info 16");
            rs.next();
            this.caseSensitive = rs.getString(3).equalsIgnoreCase("MIXED") ? Boolean.FALSE : Boolean.TRUE;
            s.close();
        }
    }

    public ResultSet getAttributes(String str, String str1, String str2, String str3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.connection.getDatabaseMajorVersion();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.connection.getDatabaseMinorVersion();
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getSQLStateType() throws SQLException {
        return 1;
    }

    public ResultSet getSuperTables(String str, String str1, String str2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getSuperTypes(String str, String str1, String str2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    public boolean supportsResultSetHoldability(int param) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }
}

