/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import net.sourceforge.jtds.jdbc.ColInfo;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.JtdsCallableStatement;
import net.sourceforge.jtds.jdbc.JtdsResultSetMetaData;
import net.sourceforge.jtds.jdbc.JtdsStatement;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.ParamInfo;
import net.sourceforge.jtds.jdbc.SQLParser;
import net.sourceforge.jtds.jdbc.Support;

public class JtdsPreparedStatement
extends JtdsStatement
implements PreparedStatement {
    protected String sql;
    protected String sqlWord;
    protected String procName;
    protected ParamInfo[] parameters;
    private boolean returnKeys = false;
    protected boolean paramWasNull = false;
    protected ColInfo[] colMetaData = null;
    protected ParamInfo[] paramMetaData = null;
    private static NumberFormat f = NumberFormat.getInstance();
    static /* synthetic */ Class array$Lnet$sourceforge$jtds$jdbc$ParamInfo;

    JtdsPreparedStatement(ConnectionJDBC2 connection, String sql, int resultSetType, int concurrency, boolean returnKeys) throws SQLException {
        super(connection, resultSetType, concurrency);
        ArrayList params;
        String[] parsedSql;
        this.returnKeys = returnKeys;
        if (this instanceof JtdsCallableStatement) {
            sql = this.normalizeCall(sql);
        }
        if ((parsedSql = new SQLParser(sql, params = new ArrayList(), connection.getServerType()).parse(false))[0].length() == 0) {
            throw new SQLException(Messages.get("error.prepare.nosql"), "07000");
        }
        this.sql = parsedSql[0];
        if (parsedSql[1].length() > 1 && this instanceof JtdsCallableStatement) {
            this.procName = parsedSql[1];
        }
        this.sqlWord = parsedSql[2];
        if (returnKeys && this.sqlWord.equals("insert")) {
            this.sql = connection.getServerType() == 1 && connection.getDatabaseMajorVersion() >= 8 ? this.sql + " SELECT SCOPE_IDENTITY() AS ID" : this.sql + " SELECT @@IDENTITY AS ID";
        }
        this.parameters = params.toArray(new ParamInfo[params.size()]);
    }

    protected String normalizeCall(String sql) {
        String original = sql;
        if ((sql = sql.trim()).length() > 0 && sql.charAt(0) == '{') {
            return original;
        }
        if (sql.length() > 4 && sql.substring(0, 5).equalsIgnoreCase("exec ")) {
            sql = sql.substring(4).trim();
        } else if (sql.length() > 7 && sql.substring(0, 8).equalsIgnoreCase("execute ")) {
            sql = sql.substring(7).trim();
        }
        if (sql.length() > 1 && sql.charAt(0) == '?') {
            if ((sql = sql.substring(1).trim()).length() < 1 || sql.charAt(0) != '=') {
                return original;
            }
            sql = sql.substring(1).trim();
            return "{?=call " + sql + "}";
        }
        return "{call " + sql + "}";
    }

    protected void checkOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException(Messages.get("error.generic.closed", "PreparedStatement"), "HY010");
        }
    }

    protected void notSupported(String method) throws SQLException {
        throw new SQLException(Messages.get("error.generic.notsup", method), "HYC00");
    }

    protected int executeBatchOther(Object value) throws SQLException {
        if (value instanceof ParamInfo[]) {
            ParamInfo[] saveParameters = this.parameters;
            try {
                this.parameters = (ParamInfo[])value;
                int n = this.executeUpdate();
                Object var5_4 = null;
                this.parameters = saveParameters;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.parameters = saveParameters;
                throw throwable;
            }
        }
        super.executeBatchOther(value);
        return Integer.MIN_VALUE;
    }

    protected ParamInfo getParameter(int parameterIndex, boolean checkIfSet) throws SQLException {
        this.checkOpen();
        if (parameterIndex < 1 || parameterIndex > this.parameters.length) {
            throw new SQLException(Messages.get("error.prepare.paramindex", Integer.toString(parameterIndex)), "07009");
        }
        ParamInfo pi = this.parameters[parameterIndex - 1];
        if (checkIfSet && !pi.isSet) {
            throw new SQLException(Messages.get("error.callable.outparamnotset"), "HY010");
        }
        this.paramWasNull = pi.value == null;
        return pi;
    }

    public void setObjectBase(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        int length = 0;
        if (targetSqlType == 2005) {
            targetSqlType = -1;
        } else if (targetSqlType == 2004) {
            targetSqlType = -4;
        }
        if (x != null) {
            x = Support.convert(this, x, targetSqlType, this.connection.getCharSet());
            if (scale >= 0) {
                if (x instanceof BigDecimal) {
                    x = ((BigDecimal)x).setScale(scale, 4);
                } else if (x instanceof Number) {
                    f.setMaximumFractionDigits(scale);
                    x = Support.convert(this, f.format(x), targetSqlType, this.connection.getCharSet());
                }
            }
            if (x instanceof Blob) {
                Blob blob = (Blob)x;
                length = (int)blob.length();
                x = blob.getBinaryStream();
            } else if (x instanceof Clob) {
                Clob clob = (Clob)x;
                length = (int)clob.length();
                x = clob.getCharacterStream();
            }
        }
        this.setParameter(parameterIndex, x, targetSqlType, scale, length);
    }

    protected void setParameter(int parameterIndex, Object x, int targetSqlType, int scale, int length) throws SQLException {
        ParamInfo pi = this.getParameter(parameterIndex, false);
        if (Support.getJdbcTypeName(targetSqlType).equals("ERROR")) {
            throw new SQLException(Messages.get("error.generic.badtype", Integer.toString(targetSqlType)), "HY092");
        }
        int n = pi.scale = scale < 0 ? 0 : scale;
        if (targetSqlType == 3 || targetSqlType == 2) {
            pi.precision = this.connection.getMaxPrecision();
            if (x instanceof BigDecimal) {
                x = Support.normalizeBigDecimal((BigDecimal)x, pi.precision);
                pi.scale = ((BigDecimal)x).scale();
            }
        }
        pi.length = x instanceof String ? ((String)x).length() : (x instanceof byte[] ? ((byte[])x).length : length);
        pi.value = x;
        pi.jdbcType = targetSqlType;
        pi.isSet = true;
        pi.isUnicode = this.connection.isUseUnicode();
    }

    void setColMetaData(ColInfo[] value) {
        this.colMetaData = value;
    }

    void setParamMetaData(ParamInfo[] value) {
        int i = 0;
        while (i < value.length && i < this.parameters.length) {
            if (!this.parameters[i].isSet) {
                this.parameters[i].jdbcType = value[i].jdbcType;
                this.parameters[i].isOutput = value[i].isOutput;
                this.parameters[i].precision = value[i].precision;
                this.parameters[i].scale = value[i].scale;
                this.parameters[i].sqlType = value[i].sqlType;
            }
            ++i;
        }
    }

    public int executeUpdate() throws SQLException {
        this.checkOpen();
        String spName = this.procName;
        if (spName == null) {
            spName = this.connection.prepareSQL(this, this.sql, this.parameters, this.returnKeys);
        }
        this.executeSQL(this.sql, spName, this.sqlWord, this.parameters, this.returnKeys, true);
        return this.getUpdateCount(0);
    }

    public synchronized void addBatch() throws SQLException {
        this.checkOpen();
        if (this.batchValues == null) {
            this.batchValues = new ArrayList();
        }
        this.batchValues.add(this.parameters);
        ParamInfo[] tmp = new ParamInfo[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            tmp[i] = new ParamInfo(this.parameters[i]);
            ++i;
        }
        this.parameters = tmp;
    }

    public void clearParameters() throws SQLException {
        this.checkOpen();
        int i = 0;
        while (i < this.parameters.length) {
            this.parameters[i].isSet = false;
            this.parameters[i].value = null;
            ++i;
        }
    }

    public boolean execute() throws SQLException {
        this.checkOpen();
        this.resultQueue.clear();
        this.genKeyResultSet = null;
        String spName = this.procName;
        if (spName == null) {
            spName = this.connection.prepareSQL(this, this.sql, this.parameters, this.returnKeys);
        }
        return this.executeSQL(this.sql, spName, this.sqlWord, this.parameters, this.returnKeys, false);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParameter(parameterIndex, new Integer(x & 0xFF), -6, 0, 0);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParameter(parameterIndex, new Double(x), 8, 0, 0);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParameter(parameterIndex, new Double(x), 6, 0, 0);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setParameter(parameterIndex, new Integer(x), 4, 0, 0);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (sqlType == 2005) {
            sqlType = -1;
        } else if (sqlType == 2004) {
            sqlType = -4;
        }
        this.setParameter(parameterIndex, null, sqlType, -1, 0);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParameter(parameterIndex, new Long(x), -5, 0, 0);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setParameter(parameterIndex, new Integer(x), 5, 0, 0);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setParameter(parameterIndex, new Boolean(x), 16, 0, 0);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setParameter(parameterIndex, x, -2, 0, 0);
    }

    public void setAsciiStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        if (inputStream == null || length < 1) {
            this.setParameter(parameterIndex, null, -1, 0, 0);
        } else {
            try {
                this.setCharacterStream(parameterIndex, (Reader)new InputStreamReader(inputStream, "US-ASCII"), length);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkOpen();
        if (x == null || length < 1) {
            this.setBytes(parameterIndex, null);
        } else {
            this.setParameter(parameterIndex, x, -4, 0, length);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        if (inputStream == null || length < 1) {
            this.setString(parameterIndex, null);
        } else {
            try {
                char[] tmp = new char[length];
                int pos = 0;
                int b1 = inputStream.read();
                int b2 = inputStream.read();
                while (b1 >= 0 && b2 >= 0) {
                    tmp[pos++] = (char)(b1 << 8 & 0xFF00 | b2 & 0xFF);
                    b1 = inputStream.read();
                    b2 = inputStream.read();
                }
                this.setString(parameterIndex, new String(tmp, 0, pos));
            }
            catch (IOException e) {
                throw new SQLException(Messages.get("error.generic.ioerror", e.getMessage()), "HY000");
            }
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (reader == null || length < 1) {
            this.setParameter(parameterIndex, null, -1, 0, 0);
        } else {
            this.setParameter(parameterIndex, reader, -1, 0, length);
        }
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setObjectBase(parameterIndex, x, Support.getJdbcType(x), -1);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObjectBase(parameterIndex, x, targetSqlType, -1);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (scale < 0 || scale > 28) {
            throw new SQLException(Messages.get("error.generic.badscale"), "HY092");
        }
        this.setObjectBase(parameterIndex, x, targetSqlType, scale);
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.notImplemented("PreparedStatement.setNull(int, int, String)");
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.setParameter(parameterIndex, x, 12, 0, 0);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParameter(parameterIndex, x, 3, -1, 0);
    }

    public void setURL(int parameterIndex, URL url) throws SQLException {
        this.setString(parameterIndex, url == null ? null : url.toString());
    }

    public void setArray(int arg0, Array arg1) throws SQLException {
        this.notImplemented("PreparedStatement.setArray");
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        if (x == null) {
            this.setBytes(parameterIndex, null);
        } else {
            long length = x.length();
            if (length > Integer.MAX_VALUE) {
                throw new SQLException(Messages.get("error.resultset.longblob"), "24000");
            }
            this.setBinaryStream(parameterIndex, x.getBinaryStream(), (int)x.length());
        }
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        if (x == null) {
            this.setString(parameterIndex, null);
        } else {
            long length = x.length();
            if (length > Integer.MAX_VALUE) {
                throw new SQLException(Messages.get("error.resultset.longclob"), "24000");
            }
            this.setCharacterStream(parameterIndex, x.getCharacterStream(), (int)x.length());
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setParameter(parameterIndex, x, 91, 0, 0);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.connection.getServerType() == 2) {
            this.connection.prepareSQL(this, this.sql, new ParamInfo[0], false);
        }
        try {
            Class<?> pmdClass = Class.forName("net.sourceforge.jtds.jdbc.ParameterMetaDataImpl");
            Class[] parameterTypes = new Class[]{array$Lnet$sourceforge$jtds$jdbc$ParamInfo == null ? (array$Lnet$sourceforge$jtds$jdbc$ParamInfo = JtdsPreparedStatement.class$("[Lnet.sourceforge.jtds.jdbc.ParamInfo;")) : array$Lnet$sourceforge$jtds$jdbc$ParamInfo};
            Object[] arguments = new Object[]{this.parameters};
            Constructor<?> pmdConstructor = pmdClass.getConstructor(parameterTypes);
            return (ParameterMetaData)pmdConstructor.newInstance(arguments);
        }
        catch (Exception e) {
            this.notImplemented("PreparedStatement.getParameterMetaData");
            return null;
        }
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.notImplemented("PreparedStatement.setRef");
    }

    public ResultSet executeQuery() throws SQLException {
        this.checkOpen();
        this.resultQueue.clear();
        this.genKeyResultSet = null;
        String spName = this.procName;
        if (spName == null) {
            spName = this.connection.prepareSQL(this, this.sql, this.parameters, false);
        }
        return this.executeSQLQuery(this.sql, spName, this.parameters, this instanceof JtdsCallableStatement);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.colMetaData == null) {
            if (this.connection.getServerType() == 2) {
                this.connection.prepareSQL(this, this.sql, new ParamInfo[0], false);
                if (this.colMetaData == null) {
                    return null;
                }
            } else {
                ArrayList params = new ArrayList();
                String[] parsedSql = new SQLParser(this.sql, params, this.connection.getServerType()).parse(true);
                if (!parsedSql[2].equals("select")) {
                    return null;
                }
                String query = "SET FMTONLY ON\r\n" + parsedSql[0] + "\r\nSET FMTONLY OFF";
                try {
                    this.tds.submitSQL(query);
                    this.colMetaData = this.tds.getColumns();
                }
                catch (SQLException e) {
                    this.tds.submitSQL("SET FMTONLY OFF");
                    return null;
                }
            }
        }
        return new JtdsResultSetMetaData(this.colMetaData, this.colMetaData.length);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setParameter(parameterIndex, x, 92, 0, 0);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setParameter(parameterIndex, x, 93, 0, 0);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (x != null && cal != null) {
            TimeZone timeZone = TimeZone.getDefault();
            long newTime = x.getTime();
            newTime -= (long)timeZone.getRawOffset();
            x = new Date(newTime += (long)cal.getTimeZone().getRawOffset());
        }
        this.setDate(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (x != null && cal != null) {
            TimeZone timeZone = TimeZone.getDefault();
            long newTime = x.getTime();
            newTime -= (long)timeZone.getRawOffset();
            x = new Time(newTime += (long)cal.getTimeZone().getRawOffset());
        }
        this.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (x != null && cal != null) {
            TimeZone timeZone = TimeZone.getDefault();
            long newTime = ((java.util.Date)x).getTime();
            newTime -= (long)timeZone.getRawOffset();
            x = new Timestamp(newTime += (long)cal.getTimeZone().getRawOffset());
        }
        this.setTimestamp(parameterIndex, x);
    }

    public int executeUpdate(String sql) throws SQLException {
        this.notSupported("executeUpdate(String)");
        return 0;
    }

    public void addBatch(String sql) throws SQLException {
        this.notSupported("executeBatch(String)");
    }

    public boolean execute(String sql) throws SQLException {
        this.notSupported("execute(String)");
        return false;
    }

    public int executeUpdate(String sql, int getKeys) throws SQLException {
        this.notSupported("executeUpdate(String, int)");
        return 0;
    }

    public boolean execute(String arg0, int arg1) throws SQLException {
        this.notSupported("execute(String, int)");
        return false;
    }

    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        this.notSupported("executeUpdate(String, int[])");
        return 0;
    }

    public boolean execute(String arg0, int[] arg1) throws SQLException {
        this.notSupported("execute(String, int[])");
        return false;
    }

    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        this.notSupported("executeUpdate(String, String[])");
        return 0;
    }

    public boolean execute(String arg0, String[] arg1) throws SQLException {
        this.notSupported("execute(String, String[])");
        return false;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.notSupported("executeQuery(String)");
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

