/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbcx;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbcx.proxy.ConnectionProxy;

public class PooledConnection
implements javax.sql.PooledConnection {
    private final ArrayList _listeners = new ArrayList();
    private Connection _connection;
    private ConnectionProxy _connectionProxy = null;

    public PooledConnection(Connection connection) {
        this._connection = connection;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        this._listeners.add(listener);
    }

    public synchronized void close() throws SQLException {
        this._connection.close();
        this._connection = null;
        this.fireConnectionEvent(false, null);
    }

    public synchronized void fireConnectionEvent(boolean closed, SQLException sqlException) {
        if (this._listeners.size() > 0) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this, sqlException);
            Iterator iterator = ((AbstractList)this._listeners).iterator();
            while (iterator.hasNext()) {
                ConnectionEventListener listener = (ConnectionEventListener)iterator.next();
                if (closed) {
                    listener.connectionClosed(connectionEvent);
                    continue;
                }
                listener.connectionErrorOccurred(connectionEvent);
            }
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this._connection == null) {
            this.fireConnectionEvent(false, new SQLException(Messages.get("error.jdbcx.conclosed"), "08003"));
            return null;
        }
        if (this._connectionProxy != null) {
            this._connectionProxy.close();
        }
        this._connectionProxy = new ConnectionProxy(this, this._connection);
        return this._connectionProxy;
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        ((AbstractCollection)this._listeners).remove(listener);
    }
}

