/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.neuro.database;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.mitre.neuro.containers.Interview;
import org.mitre.neuro.containers.Study;
import org.mitre.neuro.containers.Subject;
import org.mitre.neuro.database.StoreInterview;

public class StoreSubject {
    Connection connection;

    public StoreSubject(Connection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean get_subject_id(Subject subject, int study_id) throws Exception {
        String sql = "SELECT SUBJECT_OID from SUBJECT where PROJECT_ID=? and SUBJECT_ID=?;";
        PreparedStatement statement = this.connection.prepareStatement(sql);
        try {
            ResultSet result;
            statement.setInt(1, study_id);
            statement.setString(2, subject.getSubject_id());
            if (statement.execute() && (result = statement.getResultSet()).next()) {
                subject.setObject_id(result.getInt(1));
                boolean bl = true;
                return bl;
            }
        }
        finally {
            statement.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert_subject(Subject subject, int study_id) throws Exception {
        String sql = "INSERT INTO SUBJECT ( subject_id ,project_id ,  initial_exam, birthdate, nation_of_residence, gender, race, primary_language, second_language, marital_status, education, handedness, height, weight)VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
        PreparedStatement statement = this.connection.prepareStatement(sql);
        try {
            statement.setString(1, subject.getSubject_id());
            statement.setInt(2, study_id);
            if (subject.getInitial_exam() == null) {
                statement.setNull(3, 91);
            } else {
                statement.setDate(3, new Date(subject.getInitial_exam().getTime()));
            }
            if (subject.getBirth() == null) {
                statement.setNull(4, 91);
            } else {
                statement.setDate(4, new Date(subject.getBirth().getTime()));
            }
            statement.setString(5, subject.getNationality());
            statement.setString(6, subject.getGender());
            statement.setString(7, subject.getRace());
            statement.setString(8, subject.getPrimary_language());
            statement.setString(9, subject.getSecondary_language());
            statement.setString(10, subject.getMarital_status());
            if (subject.getEducation() == Integer.MIN_VALUE) {
                statement.setNull(11, 4);
            } else {
                statement.setInt(11, subject.getEducation());
            }
            statement.setString(12, subject.getHandedness());
            if (subject.getHeight() == Integer.MIN_VALUE) {
                statement.setNull(13, 4);
            } else {
                statement.setInt(13, subject.getHeight());
            }
            if (subject.getWeight() == Integer.MIN_VALUE) {
                statement.setNull(14, 4);
            } else {
                statement.setInt(14, subject.getWeight());
            }
            statement.execute();
        }
        finally {
            statement.close();
        }
        sql = "SELECT currval(pg_get_serial_sequence('subject', 'subject_oid'));";
        statement = this.connection.prepareStatement(sql);
        try {
            ResultSet generated_keys = statement.executeQuery();
            if (generated_keys.next()) {
                subject.setObject_id(generated_keys.getInt(1));
            }
        }
        finally {
            statement.close();
        }
    }

    public void store_subject(Subject subject, Study study) throws Exception {
        if (!this.get_subject_id(subject, study.getStudy_id())) {
            this.insert_subject(subject, study.getStudy_id());
        }
        StoreInterview store = new StoreInterview(this.connection, subject);
        for (Interview interview : subject.getInterviews()) {
            store.store_interview(interview);
        }
    }
}

