/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.composer.mimepartrenderers;

import java.io.IOException;
import java.io.InputStream;
import org.columba.ristretto.coder.Base64EncoderInputStream;
import org.columba.ristretto.coder.CanonizeFilterInputStream;
import org.columba.ristretto.coder.QuotedPrintableEncoderInputStream;
import org.columba.ristretto.composer.MimePartRenderer;
import org.columba.ristretto.io.SequenceInputStream;
import org.columba.ristretto.message.MimeHeader;
import org.columba.ristretto.message.MimePart;
import org.columba.ristretto.message.StreamableMimePart;

public class DefaultMimePartRenderer
extends MimePartRenderer {
    public String getRegisterString() {
        return null;
    }

    public InputStream render(MimePart part) throws IOException {
        MimeHeader header = part.getHeader();
        int encoding = header.getContentTransferEncoding();
        InputStream body = ((StreamableMimePart)part).getInputStream();
        switch (encoding) {
            case 2: {
                body = new Base64EncoderInputStream(body);
                break;
            }
            case 1: {
                body = new QuotedPrintableEncoderInputStream(body);
                break;
            }
            default: {
                body = new CanonizeFilterInputStream(body);
            }
        }
        return new SequenceInputStream(header.getInputStream(), body);
    }
}

