/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.composer.mimepartrenderers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.columba.ristretto.coder.Base64EncoderInputStream;
import org.columba.ristretto.coder.CanonizeFilterInputStream;
import org.columba.ristretto.coder.CharsetEncoderInputStream;
import org.columba.ristretto.coder.QuotedPrintableEncoderInputStream;
import org.columba.ristretto.composer.MimePartRenderer;
import org.columba.ristretto.io.SequenceInputStream;
import org.columba.ristretto.message.MimeHeader;
import org.columba.ristretto.message.MimePart;
import org.columba.ristretto.message.StreamableMimePart;

public class TextpartRenderer
extends MimePartRenderer {
    public String getRegisterString() {
        return "text";
    }

    public InputStream render(MimePart part) throws IOException {
        MimeHeader header = part.getHeader();
        int encoding = header.getContentTransferEncoding();
        Charset charset = header.getCharset();
        CharsetEncoderInputStream body = new CharsetEncoderInputStream((InputStream)new CanonizeFilterInputStream(((StreamableMimePart)part).getInputStream()), charset);
        switch (encoding) {
            case 2: {
                body = new Base64EncoderInputStream((InputStream)body);
                break;
            }
            case 1: {
                body = new QuotedPrintableEncoderInputStream((InputStream)body);
                break;
            }
            default: {
                body = new CanonizeFilterInputStream((InputStream)body);
            }
        }
        return new SequenceInputStream(header.getInputStream(), (InputStream)body);
    }
}

