/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.smtp;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.columba.ristretto.io.ConnectionDroppedException;
import org.columba.ristretto.parser.ParserException;
import org.columba.ristretto.smtp.SMTPException;
import org.columba.ristretto.smtp.SMTPResponse;
import org.columba.ristretto.smtp.parser.SMTPResponseParser;

public class SMTPInputStream
extends FilterInputStream {
    private StringBuffer lineBuffer = new StringBuffer();

    public SMTPInputStream(InputStream arg0) {
        super(arg0);
    }

    public SMTPResponse readSingleLineResponse() throws IOException, SMTPException {
        this.readLineInBuffer();
        try {
            return SMTPResponseParser.parse(this.lineBuffer);
        }
        catch (ParserException e) {
            throw new SMTPException("Malformed answer from server", e);
        }
    }

    private void readLineInBuffer() throws IOException {
        this.lineBuffer.delete(0, this.lineBuffer.length());
        int read = this.in.read();
        while (read != 13 && read != -1) {
            this.lineBuffer.append((char)read);
            read = this.in.read();
        }
        this.lineBuffer.append((char)read);
        read = this.in.read();
        if (read != 10) {
            throw new ConnectionDroppedException();
        }
        this.lineBuffer.append((char)read);
    }
}

