/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.smtp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import org.columba.ristretto.auth.AuthenticationException;
import org.columba.ristretto.auth.AuthenticationFactory;
import org.columba.ristretto.auth.AuthenticationMechanism;
import org.columba.ristretto.auth.AuthenticationServer;
import org.columba.ristretto.auth.NoSuchAuthenticationException;
import org.columba.ristretto.coder.Base64;
import org.columba.ristretto.config.RistrettoConfig;
import org.columba.ristretto.log.LogInputStream;
import org.columba.ristretto.log.LogOutputStream;
import org.columba.ristretto.log.RistrettoLogger;
import org.columba.ristretto.message.Address;
import org.columba.ristretto.parser.AddressParser;
import org.columba.ristretto.parser.ParserException;
import org.columba.ristretto.smtp.SMTPException;
import org.columba.ristretto.smtp.SMTPInputStream;
import org.columba.ristretto.smtp.SMTPResponse;
import org.columba.ristretto.smtp.StopWordSafeInputStream;
import org.columba.ristretto.ssl.RistrettoSSLSocketFactory;

public class SMTPProtocol
implements AuthenticationServer {
    private static final Logger LOG = Logger.getLogger("org.columba.ristretto.smtp");
    private static final byte[] STOPWORD = new byte[]{13, 10, 46, 13, 10};
    private static final int DEFAULTPORT = 25;
    public static final int NO_CONNECTION = 0;
    public static final int NOT_CONNECTED = 0;
    public static final int PLAIN = 1;
    public static final int AUTHORIZED = 2;
    public static final int TO = 0;
    public static final int CC = 1;
    private String host;
    private int port;
    private Socket socket;
    protected SMTPInputStream in;
    protected OutputStream out;
    private int state;

    public SMTPProtocol(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public SMTPProtocol(String host) {
        this(host, 25);
    }

    public String openPort() throws IOException, SMTPException {
        try {
            this.socket = new Socket(this.host, this.port);
            this.socket.setSoTimeout(RistrettoConfig.getInstance().getTimeout());
            this.createStreams();
            SMTPResponse response = this.readSingleLineResponse();
            if (response.isERR()) {
                throw new SMTPException(response.getMessage());
            }
            String domain = response.getDomain();
            if (response.isHasSuccessor()) {
                response = this.readSingleLineResponse();
                while (response.isHasSuccessor() && response.isOK()) {
                    response = this.readSingleLineResponse();
                }
            }
            this.state = 1;
            return domain;
        }
        catch (SocketException e) {
            e.printStackTrace();
            if (this.state != 0) {
                throw e;
            }
            return "";
        }
    }

    private void createStreams() throws IOException {
        if (RistrettoLogger.logStream != null) {
            this.in = new SMTPInputStream((InputStream)new LogInputStream(this.socket.getInputStream(), RistrettoLogger.logStream));
            this.out = new LogOutputStream(this.socket.getOutputStream(), RistrettoLogger.logStream);
        } else {
            this.in = new SMTPInputStream(this.socket.getInputStream());
            this.out = this.socket.getOutputStream();
        }
    }

    public void startTLS() throws IOException, SSLException, SMTPException {
        block3: {
            try {
                this.sendCommand("STARTTLS", null);
                SMTPResponse response = this.readSingleLineResponse();
                if (response.isERR()) {
                    throw new SMTPException(response.getMessage());
                }
                this.socket = RistrettoSSLSocketFactory.getInstance().createSocket(this.socket, this.host, this.port, true);
                ((SSLSocket)this.socket).startHandshake();
                this.createStreams();
            }
            catch (SocketException e) {
                if (this.state == 0) break block3;
                throw e;
            }
        }
    }

    protected void sendCommand(String command, String[] parameters) throws IOException {
        try {
            this.out.write(command.getBytes());
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    this.out.write(32);
                    this.out.write(parameters[i].getBytes());
                }
            }
            this.out.write(13);
            this.out.write(10);
            this.out.flush();
        }
        catch (IOException e) {
            this.state = 0;
            throw e;
        }
    }

    public String[] ehlo(InetAddress domain) throws IOException, SMTPException {
        this.ensureState(1);
        try {
            LinkedList<String> capas = new LinkedList<String>();
            String ipaddress = domain.getHostAddress();
            this.sendCommand("EHLO", new String[]{"[" + ipaddress + "]"});
            SMTPResponse response = this.readSingleLineResponse();
            if (response.isERR()) {
                throw new SMTPException(response.getMessage());
            }
            if (response.isHasSuccessor()) {
                response = this.readSingleLineResponse();
                while (response.isHasSuccessor() && response.isOK()) {
                    capas.add(response.getMessage());
                    response = this.readSingleLineResponse();
                }
                capas.add(response.getMessage());
            }
            return capas.toArray(new String[0]);
        }
        catch (SocketException e) {
            if (this.state != 0) {
                throw e;
            }
            return new String[0];
        }
    }

    public void helo(InetAddress domain) throws IOException, SMTPException {
        block3: {
            this.ensureState(1);
            try {
                String ipaddress = domain.getHostAddress();
                this.sendCommand("HELO", new String[]{"[" + ipaddress + "]"});
                SMTPResponse response = this.readSingleLineResponse();
                if (response.isERR()) {
                    throw new SMTPException(response);
                }
            }
            catch (SocketException e) {
                if (this.state == 0) break block3;
                throw e;
            }
        }
    }

    public void auth(String algorithm, String user, char[] password) throws IOException, SMTPException, AuthenticationException {
        block5: {
            this.ensureState(1);
            try {
                try {
                    AuthenticationMechanism auth = AuthenticationFactory.getInstance().getAuthentication(algorithm);
                    this.sendCommand("AUTH", new String[]{algorithm});
                    auth.authenticate((AuthenticationServer)this, user, password);
                }
                catch (NoSuchAuthenticationException e) {
                    throw new SMTPException(e);
                }
                SMTPResponse response = this.readSingleLineResponse();
                if (response.isERR()) {
                    throw new SMTPException(response);
                }
                this.state = 2;
            }
            catch (SocketException e) {
                if (this.state == 0) break block5;
                throw e;
            }
        }
    }

    public void mail(Address from) throws IOException, SMTPException {
        block3: {
            this.ensureState(1);
            try {
                this.sendCommand("MAIL", new String[]{"FROM:" + from.getCanonicalMailAddress()});
                SMTPResponse response = this.readSingleLineResponse();
                if (response.isERR()) {
                    throw new SMTPException(response);
                }
            }
            catch (SocketException e) {
                if (this.state == 0) break block3;
                throw e;
            }
        }
    }

    public void rcpt(Address address) throws IOException, SMTPException {
        block3: {
            try {
                this.sendCommand("RCPT", new String[]{"TO:" + address.getCanonicalMailAddress()});
                SMTPResponse response = this.readSingleLineResponse();
                if (response.isERR()) {
                    throw new SMTPException(response);
                }
            }
            catch (SocketException e) {
                if (this.state == 0) break block3;
                throw e;
            }
        }
    }

    public void rcpt(int type, Address address) throws IOException, SMTPException {
        block7: {
            try {
                switch (type) {
                    case 0: {
                        this.sendCommand("RCPT", new String[]{"TO:" + address.getCanonicalMailAddress()});
                        break;
                    }
                    case 1: {
                        this.sendCommand("RCPT", new String[]{"CC:" + address.getCanonicalMailAddress()});
                    }
                }
                SMTPResponse response = this.readSingleLineResponse();
                if (response.isERR()) {
                    throw new SMTPException(response);
                }
            }
            catch (SocketException e) {
                if (this.state == 0) break block7;
                throw e;
            }
        }
    }

    public void data(InputStream data) throws IOException, SMTPException {
        block7: {
            this.ensureState(1);
            try {
                this.sendCommand("DATA", null);
                SMTPResponse response = this.readSingleLineResponse();
                if (response.getCode() == 354) {
                    try {
                        this.copyStream(new StopWordSafeInputStream(data), this.out);
                        this.out.write(STOPWORD);
                        this.out.flush();
                    }
                    catch (IOException e) {
                        this.state = 0;
                        throw e;
                    }
                } else {
                    throw new SMTPException(response);
                }
                response = this.readSingleLineResponse();
                if (response.isERR()) {
                    throw new SMTPException(response);
                }
            }
            catch (SocketException e) {
                if (this.state == 0) break block7;
                throw e;
            }
        }
    }

    public void quit() throws IOException, SMTPException {
        block2: {
            try {
                this.sendCommand("QUIT", null);
                this.socket.close();
                this.in = null;
                this.out = null;
                this.socket = null;
                this.state = 0;
            }
            catch (SocketException e) {
                if (this.state == 0) break block2;
                throw e;
            }
        }
    }

    public void reset() throws IOException, SMTPException {
        block3: {
            try {
                this.sendCommand("RSET", null);
                SMTPResponse response = this.readSingleLineResponse();
                if (response.isERR()) {
                    throw new SMTPException(response);
                }
            }
            catch (SocketException e) {
                if (this.state == 0) break block3;
                throw e;
            }
        }
    }

    public void verify(String address) throws IOException, SMTPException {
        block3: {
            try {
                this.sendCommand("VRFY", new String[]{address});
                SMTPResponse response = this.readSingleLineResponse();
                if (response.isERR()) {
                    throw new SMTPException(response);
                }
            }
            catch (SocketException e) {
                if (this.state == 0) break block3;
                throw e;
            }
        }
    }

    public Address[] expand(Address mailinglist) throws IOException, SMTPException {
        this.ensureState(1);
        try {
            LinkedList<Address> addresses = new LinkedList<Address>();
            this.sendCommand("VRFY", new String[]{mailinglist.getCanonicalMailAddress()});
            SMTPResponse response = this.readSingleLineResponse();
            if (response.isERR()) {
                throw new SMTPException(response);
            }
            if (response.isHasSuccessor()) {
                response = this.readSingleLineResponse();
                while (response.isHasSuccessor() && response.isOK()) {
                    try {
                        addresses.add(AddressParser.parseAddress((CharSequence)response.getMessage()));
                    }
                    catch (ParserException e) {
                        LOG.severe(e.getLocalizedMessage());
                    }
                    response = this.readSingleLineResponse();
                }
                try {
                    addresses.add(AddressParser.parseAddress((CharSequence)response.getMessage()));
                }
                catch (ParserException e) {
                    LOG.severe(e.getMessage());
                }
            }
            return addresses.toArray(new Address[0]);
        }
        catch (SocketException e) {
            if (this.state != 0) {
                throw e;
            }
            return new Address[0];
        }
    }

    public void noop() throws IOException, SMTPException {
        block3: {
            this.ensureState(1);
            try {
                this.sendCommand("NOOP", null);
                SMTPResponse response = this.readSingleLineResponse();
                if (response.isERR()) {
                    throw new SMTPException(response.getMessage());
                }
            }
            catch (SocketException e) {
                if (this.state == 0) break block3;
                throw e;
            }
        }
    }

    private void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[10240];
        int copied = 0;
        int read = in.read(buffer);
        while (read != -1) {
            out.write(buffer, 0, read);
            copied += read;
            read = in.read(buffer);
        }
    }

    public byte[] authReceive() throws AuthenticationException, IOException {
        try {
            SMTPResponse response = this.in.readSingleLineResponse();
            if (response.isOK()) {
                if (response.getMessage() != null) {
                    return Base64.decodeToArray((CharSequence)response.getMessage());
                }
                return new byte[0];
            }
            throw new AuthenticationException((Throwable)new SMTPException(response));
        }
        catch (SMTPException e) {
            throw new AuthenticationException((Throwable)e);
        }
    }

    public void authSend(byte[] call) throws IOException {
        this.sendCommand(Base64.encode((ByteBuffer)ByteBuffer.wrap(call), (boolean)false).toString(), null);
    }

    public int getState() {
        return this.state;
    }

    public String getHostName() {
        return this.host;
    }

    public String getService() {
        return "smtp";
    }

    public void dropConnection() throws IOException {
        if (this.state != 0) {
            this.state = 0;
            this.socket.close();
            this.in = null;
            this.out = null;
            this.socket = null;
        }
    }

    private void ensureState(int s) throws SMTPException {
        if (this.state < s) {
            throw new SMTPException("Wrong state!");
        }
    }

    protected SMTPResponse readSingleLineResponse() throws IOException, SMTPException {
        try {
            return this.in.readSingleLineResponse();
        }
        catch (IOException e) {
            this.state = 0;
            throw e;
        }
    }
}

