/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.smtp.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.columba.ristretto.parser.ParserException;
import org.columba.ristretto.smtp.SMTPResponse;

public class SMTPResponseParser {
    private static final Pattern responsePattern = Pattern.compile("(\\d+)(-| )?([^\r\n]+)?\r\n");
    private static final Pattern greetingPattern = Pattern.compile("^([^\\s]*) ?(.*)$");

    public static SMTPResponse parse(CharSequence in) throws ParserException {
        Matcher matcher = responsePattern.matcher(in);
        if (matcher.matches()) {
            int code = Integer.parseInt(matcher.group(1));
            if (code != 220) {
                return new SMTPResponse(code, matcher.group(2) != null ? matcher.group(2).equals("-") : false, matcher.group(3));
            }
            Matcher greetingMatcher = greetingPattern.matcher(matcher.group(3));
            if (greetingMatcher.matches()) {
                return new SMTPResponse(code, matcher.group(2) != null ? matcher.group(2).equals("-") : false, greetingMatcher.group(2), greetingMatcher.group(1));
            }
            throw new ParserException(((Object)in).toString());
        }
        throw new ParserException(((Object)in).toString());
    }
}

