/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import net.sourceforge.jtds.jdbc.ColData;
import net.sourceforge.jtds.jdbc.ColInfo;
import net.sourceforge.jtds.jdbc.JtdsResultSet;
import net.sourceforge.jtds.jdbc.JtdsStatement;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.ParamInfo;
import net.sourceforge.jtds.jdbc.Support;
import net.sourceforge.jtds.jdbc.TdsCore;
import net.sourceforge.jtds.jdbc.TdsData;

public class MSCursorResultSet
extends JtdsResultSet {
    private static final int FETCH_FIRST = 1;
    private static final int FETCH_NEXT = 2;
    private static final int FETCH_PREVIOUS = 4;
    private static final int FETCH_LAST = 8;
    private static final int FETCH_ABSOLUTE = 16;
    private static final int FETCH_RELATIVE = 32;
    private static final int FETCH_REPEAT = 128;
    private static final int FETCH_INFO = 256;
    private static final int CURSOR_TYPE_KEYSET = 1;
    private static final int CURSOR_TYPE_DYNAMIC = 2;
    private static final int CURSOR_TYPE_FORWARD = 4;
    private static final int CURSOR_TYPE_STATIC = 8;
    private static final int CURSOR_TYPE_PARAMETERIZED = 4096;
    private static final int CURSOR_CONCUR_READ_ONLY = 1;
    private static final int CURSOR_CONCUR_SCROLL_LOCKS = 2;
    private static final int CURSOR_CONCUR_OPTIMISTIC = 4;
    private static final int CURSOR_OP_INSERT = 4;
    private static final int CURSOR_OP_UPDATE = 33;
    private static final int CURSOR_OP_DELETE = 34;
    private static final int SQL_ROW_SUCCESS = 1;
    private static final int SQL_ROW_DELETED = 2;
    private static final int SQL_ROW_UPDATED = 3;
    private static final int SQL_ROW_NOROW = 4;
    private static final int SQL_ROW_ADDED = 5;
    private static final int SQL_ROW_ERROR = 6;
    private static final int POS_BEFORE_FIRST = 0;
    private static final int POS_AFTER_LAST = -1;
    private Integer cursorHandle;
    private Integer prepStmtHandle;
    private Integer retVal;
    private boolean onInsertRow = false;
    private ColData[] insertRow = null;

    MSCursorResultSet(JtdsStatement statement, String sql, String procName, ParamInfo[] procedureParams, int resultSetType, int concurrency) throws SQLException {
        super(statement, resultSetType, concurrency, null, false);
        this.cursorCreate(sql, procName, procedureParams);
    }

    protected void setColValue(int colIndex, Object value, int length) throws SQLException {
        if (this.onInsertRow && this.insertRow == null || !this.onInsertRow && this.currentRow == null) {
            throw new SQLException(Messages.get("error.resultset.norow"), "24000");
        }
        ColData col = this.onInsertRow ? this.insertRow[colIndex - 1] : this.currentRow[colIndex - 1];
        col.setValue(value);
        col.setLength(length);
    }

    protected ColData getColumn(int index) throws SQLException {
        if (index < 1 || index > this.columnCount) {
            throw new SQLException(Messages.get("error.resultset.colindex", Integer.toString(index)), "07009");
        }
        if (this.onInsertRow && this.insertRow == null || !this.onInsertRow && this.currentRow == null) {
            throw new SQLException(Messages.get("error.resultset.norow"), "24000");
        }
        ColData data = this.onInsertRow ? this.insertRow[index - 1] : this.currentRow[index - 1];
        this.wasNull = data.isNull();
        return data;
    }

    static int getCursorScrollOpt(int resultSetType, boolean parameterized) {
        int scrollOpt;
        switch (resultSetType) {
            case 1004: {
                scrollOpt = 8;
                break;
            }
            case 1005: {
                scrollOpt = 1;
                break;
            }
            default: {
                scrollOpt = 4;
            }
        }
        if (parameterized) {
            scrollOpt |= 0x1000;
        }
        return scrollOpt;
    }

    static int getCursorConcurrencyOpt(int resultSetConcurrency) {
        switch (resultSetConcurrency) {
            default: {
                return 1;
            }
            case 1008: 
        }
        return 2;
    }

    private void cursorCreate(String sql, String procName, ParamInfo[] parameters) throws SQLException {
        ParamInfo[] params;
        TdsCore tds = this.statement.getTds();
        int prepareSql = this.statement.connection.getPrepareSql();
        if (parameters != null && parameters.length == 0) {
            parameters = null;
        }
        if (parameters == null) {
            prepareSql = 0;
        }
        if (tds.getTdsVersion() == 1) {
            prepareSql = 0;
            if (parameters != null) {
                procName = null;
            }
        }
        if (parameters != null && prepareSql == 0) {
            sql = Support.substituteParameters(sql, parameters, tds.getTdsVersion());
            parameters = null;
        }
        if (!(parameters == null || procName != null && procName.startsWith("#jtds"))) {
            sql = Support.substituteParamMarkers(sql, parameters);
        }
        if (procName != null) {
            if (procName.startsWith("#jtds")) {
                StringBuffer buf = new StringBuffer(64);
                buf.append("EXEC ").append(procName).append(' ');
                int i = 0;
                while (parameters != null && i < parameters.length) {
                    if (i != 0) {
                        buf.append(',');
                    }
                    if (parameters[i].name != null) {
                        buf.append(parameters[i].name);
                    } else {
                        buf.append("@P").append(i);
                    }
                    ++i;
                }
                sql = buf.toString();
            } else if (TdsCore.isPreparedProcedureName(procName)) {
                try {
                    this.prepStmtHandle = new Integer(procName);
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("Invalid prepared statement handle: " + procName);
                }
            }
        }
        int scrollOpt = MSCursorResultSet.getCursorScrollOpt(this.resultSetType, parameters != null);
        int ccOpt = MSCursorResultSet.getCursorConcurrencyOpt(this.concurrency);
        if (parameters != null) {
            scrollOpt |= 0x1000;
        }
        ParamInfo pScrollOpt = new ParamInfo();
        pScrollOpt.isSet = true;
        pScrollOpt.jdbcType = 4;
        pScrollOpt.value = new Integer(scrollOpt);
        pScrollOpt.isOutput = true;
        ParamInfo pConCurOpt = new ParamInfo();
        pConCurOpt.isSet = true;
        pConCurOpt.jdbcType = 4;
        pConCurOpt.value = new Integer(ccOpt);
        pConCurOpt.isOutput = true;
        ParamInfo pRowCount = new ParamInfo();
        pRowCount.isSet = true;
        pRowCount.jdbcType = 4;
        pRowCount.isOutput = true;
        ParamInfo pCursor = new ParamInfo();
        pCursor.isSet = true;
        pCursor.jdbcType = 4;
        pCursor.isOutput = true;
        ParamInfo pStmtHand = null;
        if (prepareSql == 4 || prepareSql == 3) {
            pStmtHand = new ParamInfo();
            pStmtHand.isSet = true;
            pStmtHand.jdbcType = 4;
            pStmtHand.value = this.prepStmtHandle;
            pStmtHand.isOutput = true;
        }
        ParamInfo pParamDef = null;
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                TdsData.getNativeType(this.statement.connection, parameters[i]);
                ++i;
            }
            pParamDef = new ParamInfo();
            pParamDef.isSet = true;
            pParamDef.jdbcType = -1;
            pParamDef.value = Support.getParameterDefinitions(parameters);
            pParamDef.length = ((String)pParamDef.value).length();
            pParamDef.isUnicode = true;
        }
        ParamInfo pSQL = new ParamInfo();
        pSQL.isSet = true;
        pSQL.jdbcType = -1;
        pSQL.value = sql;
        pSQL.length = sql.length();
        pSQL.isUnicode = true;
        if (prepareSql == 3 && this.prepStmtHandle == null) {
            params = new ParamInfo[6];
            params[0] = pStmtHand;
            params[1] = pParamDef;
            params[2] = pSQL;
            params[3] = new ParamInfo();
            params[3].isSet = true;
            params[3].jdbcType = 4;
            params[3].value = new Integer(1);
            params[4] = pScrollOpt;
            params[5] = pConCurOpt;
            this.columns = null;
            tds.executeSQL(null, "sp_cursorprepare", params, false, this.statement.getQueryTimeout(), -1);
            tds.clearResponseQueue();
            this.prepStmtHandle = (Integer)pStmtHand.value;
            if (this.prepStmtHandle == null) {
                prepareSql = 0;
                if (parameters != null) {
                    pScrollOpt.value = new Integer((int)((Integer)pScrollOpt.value | 0x1000));
                }
            }
        }
        if (prepareSql == 3 && this.prepStmtHandle != null) {
            params = new ParamInfo[5 + parameters.length];
            System.arraycopy(parameters, 0, params, 5, parameters.length);
            pStmtHand.isOutput = false;
            params[0] = pStmtHand;
            params[1] = pCursor;
            pScrollOpt.value = new Integer((int)((Integer)pScrollOpt.value & 0xFF));
            params[2] = pScrollOpt;
            params[3] = pConCurOpt;
            params[4] = pRowCount;
            parameters = params;
            procName = "sp_cursorexecute";
        } else if (prepareSql == 4) {
            params = new ParamInfo[7 + parameters.length];
            System.arraycopy(parameters, 0, params, 7, parameters.length);
            params[0] = pStmtHand;
            params[1] = pCursor;
            params[2] = pParamDef;
            params[3] = pSQL;
            params[4] = pScrollOpt;
            params[5] = pConCurOpt;
            params[6] = pRowCount;
            parameters = params;
            procName = "sp_cursorprepexec";
        } else {
            if (parameters == null) {
                params = new ParamInfo[5];
            } else {
                params = new ParamInfo[6 + parameters.length];
                System.arraycopy(parameters, 0, params, 6, parameters.length);
                params[5] = pParamDef;
            }
            params[0] = pCursor;
            params[1] = pSQL;
            params[2] = pScrollOpt;
            params[3] = pConCurOpt;
            params[4] = pRowCount;
            parameters = params;
            procName = "sp_cursoropen";
        }
        this.retVal = null;
        tds.executeSQL(null, procName, parameters, false, this.statement.getQueryTimeout(), 0);
        while (!tds.getMoreResults() && !tds.isEndOfResponse()) {
        }
        if (tds.isResultSet()) {
            this.columns = this.copyInfo(tds.getColumns());
            this.columnCount = this.getColumnCount(this.columns);
        } else {
            this.statement.getMessages().addException(new SQLException(Messages.get("error.statement.noresult"), "24000"));
        }
        tds.clearResponseQueue();
        this.statement.messages.checkErrors();
        this.retVal = tds.getReturnStatus();
        this.cursorHandle = (Integer)pCursor.value;
        int actualScroll = (Integer)pScrollOpt.value;
        int actualCc = (Integer)pConCurOpt.value;
        this.rowsInResult = (Integer)pRowCount.value;
        if (prepareSql == 4) {
            this.prepStmtHandle = (Integer)pStmtHand.value;
        }
        if (actualScroll != (scrollOpt & 0xFFF) || actualCc != ccOpt) {
            if (actualScroll != scrollOpt) {
                switch (actualScroll) {
                    case 4: {
                        this.resultSetType = 1003;
                        break;
                    }
                    case 8: {
                        this.resultSetType = 1004;
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.resultSetType = 1005;
                        break;
                    }
                    default: {
                        this.statement.getMessages().addWarning(new SQLWarning(Messages.get("warning.cursortype", Integer.toString(actualScroll)), "01000"));
                    }
                }
            }
            if (actualCc != ccOpt) {
                switch (actualCc) {
                    case 1: {
                        this.concurrency = 1007;
                        break;
                    }
                    case 2: 
                    case 4: {
                        this.concurrency = 1008;
                        break;
                    }
                    default: {
                        this.statement.getMessages().addWarning(new SQLWarning(Messages.get("warning.concurrtype", Integer.toString(actualCc)), "01000"));
                    }
                }
            }
            this.statement.addWarning(new SQLWarning(Messages.get("warning.cursordowngraded", this.resultSetType + "/" + this.concurrency), "01000"));
        }
        if (this.retVal == null || this.retVal != 0) {
            throw new SQLException(Messages.get("error.resultset.openfail"), "24000");
        }
    }

    private boolean cursorFetch(int fetchType, int rowNum) throws SQLException {
        boolean isInfo;
        TdsCore tds = this.statement.getTds();
        this.statement.clearWarnings();
        boolean bl = isInfo = fetchType == 256;
        if (fetchType != 16 && fetchType != 32) {
            rowNum = 1;
        }
        ParamInfo[] param = new ParamInfo[4];
        param[0] = new ParamInfo();
        param[0].isSet = true;
        param[0].jdbcType = 4;
        param[0].value = this.cursorHandle;
        param[0].isOutput = false;
        param[1] = new ParamInfo();
        param[1].isSet = true;
        param[1].jdbcType = 4;
        param[1].value = new Integer(fetchType);
        param[1].isOutput = false;
        param[2] = new ParamInfo();
        param[2].isSet = true;
        param[2].jdbcType = 4;
        param[2].value = isInfo ? null : new Integer(rowNum);
        param[2].isOutput = isInfo;
        param[3] = new ParamInfo();
        param[3].isSet = true;
        param[3].jdbcType = 4;
        param[3].value = isInfo ? null : new Integer(1);
        param[3].isOutput = isInfo;
        this.retVal = null;
        tds.executeSQL(null, "sp_cursorfetch", param, true, this.statement.getQueryTimeout(), 0);
        while (!tds.getMoreResults() && !tds.isEndOfResponse()) {
        }
        this.currentRow = tds.isResultSet() ? (tds.isRowData() ? this.copyRow(tds.getRowData()) : (tds.getNextRow() ? this.copyRow(tds.getRowData()) : null)) : null;
        tds.clearResponseQueue();
        this.statement.getMessages().checkErrors();
        this.retVal = tds.getReturnStatus();
        if (isInfo) {
            this.pos = (Integer)param[2].value;
            this.rowsInResult = (Integer)param[3].value;
        }
        return this.currentRow != null;
    }

    private void cursor(int opType, ColData[] row) throws SQLException {
        ParamInfo[] param;
        TdsCore tds = this.statement.getTds();
        this.statement.clearWarnings();
        if (opType == 34) {
            if (row != null) {
                // empty if block
            }
            param = new ParamInfo[3];
        } else {
            if (row == null) {
                throw new SQLException(Messages.get("error.resultset.update"), "24000");
            }
            param = new ParamInfo[4 + this.columnCount];
        }
        param[0] = new ParamInfo();
        param[0].isSet = true;
        param[0].jdbcType = 4;
        param[0].value = this.cursorHandle;
        param[1] = new ParamInfo();
        param[1].isSet = true;
        param[1].jdbcType = 4;
        param[1].value = new Integer(opType);
        param[2] = new ParamInfo();
        param[2].isSet = true;
        param[2].jdbcType = 4;
        param[2].value = new Integer(1);
        if (row != null) {
            param[3] = new ParamInfo();
            param[3].isSet = true;
            param[3].jdbcType = 12;
            param[3].value = "";
            int colCnt = this.columnCount;
            int crtCol = 4;
            int i = 0;
            while (i < colCnt) {
                if (this.columns[i].isWriteable && row[i].isUpdated()) {
                    ParamInfo pi;
                    ColInfo col = this.columns[i];
                    param[crtCol] = pi = new ParamInfo();
                    pi.isSet = true;
                    pi.jdbcType = col.jdbcType;
                    pi.value = row[i].getValue();
                    pi.length = row[i].getLength();
                    pi.name = '@' + col.realName;
                    pi.bufferSize = col.bufferSize;
                    pi.scale = col.scale;
                    pi.tdsType = col.tdsType;
                    pi.collation = col.collation;
                    ++crtCol;
                } else if (opType == 4 && row[i].getValue() != null) {
                    throw new SQLException(Messages.get("error.resultset.insert", Integer.toString(i + 1), this.columns[i].realName), "24000");
                }
                ++i;
            }
            if (crtCol == 4) {
                return;
            }
            if (crtCol != colCnt + 4) {
                ParamInfo[] newParam = new ParamInfo[crtCol];
                System.arraycopy(param, 0, newParam, 0, crtCol);
                param = newParam;
            }
        }
        this.retVal = null;
        tds.executeSQL(null, "sp_cursor", param, false, this.statement.getQueryTimeout(), -1);
        tds.clearResponseQueue();
        this.statement.getMessages().checkErrors();
        this.retVal = tds.getReturnStatus();
    }

    private void cursorClose() throws SQLException {
        TdsCore tds = this.statement.getTds();
        this.statement.clearWarnings();
        ParamInfo[] param = new ParamInfo[]{new ParamInfo()};
        param[0].isSet = true;
        param[0].jdbcType = 4;
        param[0].value = this.cursorHandle;
        param[0].isOutput = false;
        tds.executeSQL(null, "sp_cursorclose", param, false, this.statement.getQueryTimeout(), -1);
        tds.clearResponseQueue();
        this.statement.getMessages().checkErrors();
        this.retVal = tds.getReturnStatus();
        if (this.prepStmtHandle != null) {
            param[0].value = this.prepStmtHandle;
            tds.executeSQL(null, "sp_cursorunprepare", param, false, this.statement.getQueryTimeout(), -1);
            tds.clearResponseQueue();
            this.statement.getMessages().checkErrors();
        }
    }

    public void afterLast() throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        if (this.pos != -1) {
            this.cursorFetch(16, this.rowsInResult + 1);
            this.pos = -1;
        }
    }

    public void beforeFirst() throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        if (this.pos != 0) {
            this.cursorFetch(16, 0);
            this.pos = 0;
        }
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkOpen();
        this.checkUpdateable();
        if (this.onInsertRow) {
            throw new SQLException(Messages.get("error.resultset.insrow"), "24000");
        }
        this.refreshRow();
    }

    public void close() throws SQLException {
        if (!this.closed) {
            try {
                if (!this.statement.getConnection().isClosed()) {
                    this.cursorClose();
                }
                Object var2_1 = null;
                this.closed = true;
                this.statement = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.closed = true;
                this.statement = null;
                throw throwable;
            }
        }
    }

    public void deleteRow() throws SQLException {
        this.checkOpen();
        this.checkUpdateable();
        if (this.currentRow == null) {
            throw new SQLException(Messages.get("error.resultset.norow"), "24000");
        }
        if (this.onInsertRow) {
            throw new SQLException(Messages.get("error.resultset.insrow"), "24000");
        }
        this.cursor(34, null);
        this.cursorFetch(128, 1);
    }

    public void insertRow() throws SQLException {
        this.checkOpen();
        this.checkUpdateable();
        if (!this.onInsertRow) {
            throw new SQLException(Messages.get("error.resultset.notinsrow"), "24000");
        }
        this.cursor(4, this.insertRow);
        this.cursorFetch(256, 1);
        this.insertRow = this.newRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.checkOpen();
        this.checkUpdateable();
        this.onInsertRow = false;
    }

    public void moveToInsertRow() throws SQLException {
        this.checkOpen();
        this.checkUpdateable();
        this.onInsertRow = true;
        this.insertRow = this.newRow();
    }

    public void refreshRow() throws SQLException {
        this.checkOpen();
        if (this.onInsertRow) {
            throw new SQLException(Messages.get("error.resultset.insrow"), "24000");
        }
        this.cursorFetch(128, 1);
    }

    public void updateRow() throws SQLException {
        this.checkOpen();
        this.checkUpdateable();
        if (this.currentRow == null) {
            throw new SQLException(Messages.get("error.resultset.norow"), "24000");
        }
        if (this.onInsertRow) {
            throw new SQLException(Messages.get("error.resultset.insrow"), "24000");
        }
        this.cursor(33, this.currentRow);
        this.cursorFetch(256, 1);
        this.refreshRow();
    }

    public boolean first() throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        boolean res = this.cursorFetch(1, 0);
        this.pos = 1;
        return res;
    }

    public boolean isLast() throws SQLException {
        this.checkOpen();
        return this.pos == this.rowsInResult && this.rowsInResult != 0;
    }

    public boolean last() throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        boolean res = this.cursorFetch(8, 0);
        this.pos = this.rowsInResult;
        return res;
    }

    public boolean next() throws SQLException {
        this.checkOpen();
        if (this.cursorFetch(2, 0)) {
            ++this.pos;
            return true;
        }
        this.pos = -1;
        return false;
    }

    public boolean previous() throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        if (this.cursorFetch(4, 0)) {
            this.pos -= this.pos < 0 ? this.pos - this.rowsInResult : 1;
            return true;
        }
        this.pos = 0;
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.checkOpen();
        return this.getRowStat() == 2;
    }

    public boolean rowInserted() throws SQLException {
        this.checkOpen();
        return this.getRowStat() == 5;
    }

    public boolean rowUpdated() throws SQLException {
        this.checkOpen();
        return this.getRowStat() == 3;
    }

    private int getRowStat() throws SQLException {
        ColData data = this.currentRow[this.columns.length - 1];
        return (Integer)Support.convert(this, data.getValue(), 4, null);
    }

    public boolean absolute(int row) throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        if (!this.cursorFetch(16, row)) {
            this.pos = row > 0 ? -1 : 0;
            return false;
        }
        this.pos = row;
        return true;
    }

    public boolean relative(int row) throws SQLException {
        this.checkOpen();
        this.checkScrollable();
        if (!this.cursorFetch(32, row)) {
            this.pos = row > 0 ? -1 : 0;
            return false;
        }
        if (this.pos < 0) {
            this.pos = this.rowsInResult + 1;
        }
        this.pos += row;
        return true;
    }
}

