/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class WriterOutputStream
extends OutputStream {
    protected Writer _writer;
    protected String _encoding;
    private byte[] _singleByte = new byte[1];

    public WriterOutputStream(Writer writer) {
        if (writer == null) {
            throw new NullPointerException();
        }
        this._writer = writer;
    }

    public WriterOutputStream(Writer writer, String encoding) {
        if (writer == null) {
            throw new NullPointerException();
        }
        if (encoding == null) {
            throw new NullPointerException();
        }
        this._writer = writer;
        this._encoding = encoding;
    }

    public synchronized void write(int b) throws IOException {
        this._singleByte[0] = (byte)b;
        this.write(this._singleByte, 0, 1);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this._writer == null) {
            throw new IOException("stream closed");
        }
        String data = this._encoding == null ? new String(b, off, len) : new String(b, off, len, this._encoding);
        this._writer.write(data.toCharArray());
    }

    public synchronized void flush() throws IOException {
        if (this._writer == null) {
            throw new IOException("stream closed");
        }
        this._writer.flush();
    }

    public synchronized void close() throws IOException {
        if (this._writer != null) {
            this._writer.close();
            this._writer = null;
        }
        this._encoding = null;
    }
}

