/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.util.om;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.woden.ErrorLocator;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.ErrorReporterImpl;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.xml.sax.InputSource;

public class OMUtils {
    private static final String emptyString = "";

    public static StAXOMBuilder getOMBuilder(String string) {
        StAXOMBuilder stAXOMBuilder = null;
        try {
            URI uRI = new URI(string);
            URL uRL = uRI.toURL();
            InputStream inputStream = uRL.openStream();
            stAXOMBuilder = new StAXOMBuilder(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        return stAXOMBuilder;
    }

    public static OMElement getElement(String string) {
        StAXOMBuilder stAXOMBuilder = OMUtils.getOMBuilder(string);
        OMElement oMElement = stAXOMBuilder.getDocumentElement();
        return oMElement;
    }

    public static String getAttribute(OMElement oMElement, String string) {
        String string2 = null;
        Iterator iterator = oMElement.getAllAttributes();
        while (iterator.hasNext()) {
            OMAttribute oMAttribute = (OMAttribute)iterator.next();
            if (!oMAttribute.getLocalName().equals(string)) continue;
            string2 = oMAttribute.getAttributeValue();
        }
        return string2;
    }

    public static InputSource getInputSource(OMElement oMElement) {
        String string = null;
        try {
            string = oMElement.toStringWithConsume();
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
        byte[] byArray = string.getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputSource inputSource = new InputSource(byteArrayInputStream);
        return inputSource;
    }

    public static QName getQName(String string, OMElement oMElement) throws WSDLException {
        int n = string.indexOf(58);
        String string2 = n != -1 ? string.substring(0, n) : null;
        String string3 = string.substring(n + 1);
        String string4 = null;
        if (string2 != null) {
            string4 = oMElement.findNamespaceURI(string2).getNamespaceURI();
            return new QName(string4, string3, string2 != null ? string2 : emptyString);
        }
        String string5 = string2 == null ? "NO_PREFIX_SPECIFIED" : "UNBOUND_PREFIX";
        WSDLException wSDLException = new WSDLException(string5, "Unable to determine namespace of '" + string + "'.");
        throw wSDLException;
    }

    public static String getAttributeNS(OMElement oMElement, String string, String string2) {
        String string3 = null;
        OMAttribute oMAttribute = oMElement.getAttribute(new QName(string, string2));
        if (oMAttribute != null) {
            string3 = oMAttribute.getAttributeValue();
        }
        return string3;
    }

    public static void registerUniquePrefix(String string, String string2, DescriptionElement descriptionElement) throws WSDLException {
        String string3;
        URI uRI = descriptionElement.getNamespace(string);
        String string4 = string3 = uRI != null ? uRI.toString() : null;
        if (string3 != null && string3.equals(string2)) {
            return;
        }
        while (string3 != null && !string3.equals(string2)) {
            uRI = descriptionElement.getNamespace(string = string + "_");
            string3 = uRI != null ? uRI.toString() : null;
        }
        URI uRI2 = null;
        try {
            uRI2 = new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            new ErrorReporterImpl().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL506", new Object[]{string2}, (short)2, (Exception)uRISyntaxException);
        }
        descriptionElement.addNamespace(string, uRI2);
    }
}

