/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.woden.internal.schema.SchemaImpl;
import org.apache.woden.internal.wsdl20.DocumentableImpl;
import org.apache.woden.schema.ImportedSchema;
import org.apache.woden.schema.InlinedSchema;
import org.apache.woden.schema.Schema;
import org.apache.woden.wsdl20.xml.TypesElement;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaType;

public class TypesImpl
extends DocumentableImpl
implements TypesElement {
    private WSDLElement fParentElem = null;
    private String fTypeSystem = null;
    private List fSchemas = new Vector();

    public void setTypeSystem(String string) {
        this.fTypeSystem = string;
    }

    public String getTypeSystem() {
        return this.fTypeSystem;
    }

    public void addSchema(Schema schema) {
        if (schema != null) {
            this.fSchemas.add(schema);
        }
    }

    public void removeSchema(Schema schema) {
        this.fSchemas.remove(schema);
    }

    public Schema[] getSchemas() {
        Schema[] schemaArray = new Schema[this.fSchemas.size()];
        this.fSchemas.toArray(schemaArray);
        return schemaArray;
    }

    public Schema[] getSchemas(URI uRI) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Iterator iterator = this.fSchemas.iterator();
        if (uRI != null) {
            while (iterator.hasNext()) {
                object = (Schema[])iterator.next();
                if (!uRI.equals(object.getNamespace())) continue;
                vector.add(object);
            }
        } else {
            while (iterator.hasNext()) {
                object = (Schema)iterator.next();
                if (object.getNamespace() != null) continue;
                vector.add(object);
            }
        }
        object = new Schema[vector.size()];
        vector.toArray((T[])object);
        return object;
    }

    public InlinedSchema[] getInlinedSchemas() {
        InlinedSchema[] inlinedSchemaArray;
        Vector<InlinedSchema[]> vector = new Vector<InlinedSchema[]>();
        Iterator iterator = this.fSchemas.iterator();
        while (iterator.hasNext()) {
            inlinedSchemaArray = (InlinedSchema[])iterator.next();
            if (!(inlinedSchemaArray instanceof InlinedSchema)) continue;
            vector.add(inlinedSchemaArray);
        }
        inlinedSchemaArray = new InlinedSchema[vector.size()];
        vector.toArray(inlinedSchemaArray);
        return inlinedSchemaArray;
    }

    public ImportedSchema[] getImportedSchemas() {
        ImportedSchema[] importedSchemaArray;
        Vector<ImportedSchema[]> vector = new Vector<ImportedSchema[]>();
        Iterator iterator = this.fSchemas.iterator();
        while (iterator.hasNext()) {
            importedSchemaArray = (ImportedSchema[])iterator.next();
            if (!(importedSchemaArray instanceof ImportedSchema)) continue;
            vector.add(importedSchemaArray);
        }
        importedSchemaArray = new ImportedSchema[vector.size()];
        vector.toArray(importedSchemaArray);
        return importedSchemaArray;
    }

    public void setParentElement(WSDLElement wSDLElement) {
        this.fParentElem = wSDLElement;
    }

    public WSDLElement getParentElement() {
        return this.fParentElem;
    }

    public XmlSchemaElement getElementDeclaration(QName qName) {
        XmlSchemaElement xmlSchemaElement;
        block2: {
            XmlSchema xmlSchema;
            if (qName == null) {
                return null;
            }
            xmlSchemaElement = null;
            List list = this.getReferenceableSchemaDefs(qName.getNamespaceURI());
            if (list == null) break block2;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && (xmlSchemaElement = (xmlSchema = (XmlSchema)iterator.next()).getElementByName(qName)) == null) {
            }
        }
        return xmlSchemaElement;
    }

    public XmlSchemaType getTypeDefinition(QName qName) {
        XmlSchemaType xmlSchemaType;
        block1: {
            XmlSchema xmlSchema;
            List list;
            xmlSchemaType = null;
            if (qName == null || (list = this.getReferenceableSchemaDefs(qName.getNamespaceURI())) == null) break block1;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && (xmlSchemaType = (xmlSchema = (XmlSchema)iterator.next()).getTypeByName(qName)) == null) {
            }
        }
        return xmlSchemaType;
    }

    public List getReferenceableSchemaDefs() {
        Vector<XmlSchema> vector = new Vector<XmlSchema>();
        Iterator iterator = this.fSchemas.iterator();
        while (iterator.hasNext()) {
            SchemaImpl schemaImpl = (SchemaImpl)iterator.next();
            if (!schemaImpl.isReferenceable() || schemaImpl.getSchemaDefinition() == null) continue;
            vector.add(schemaImpl.getSchemaDefinition());
        }
        return vector;
    }

    private List getReferenceableSchemaDefs(String string) {
        Vector<XmlSchema> vector = new Vector<XmlSchema>();
        if (string != null) {
            Iterator iterator = this.fSchemas.iterator();
            while (iterator.hasNext()) {
                SchemaImpl schemaImpl = (SchemaImpl)iterator.next();
                if (!schemaImpl.isReferenceable() || !string.equals(schemaImpl.getNamespaceAsString()) || schemaImpl.getSchemaDefinition() == null) continue;
                vector.add(schemaImpl.getSchemaDefinition());
            }
        }
        return vector;
    }

    public boolean isNamespaceInScope(URI uRI) {
        return this.isNamespaceInScope(uRI.toString());
    }

    public boolean isNamespaceInScope(QName qName) {
        return this.isNamespaceInScope(qName.getNamespaceURI());
    }

    public boolean isNamespaceInScope(String string) {
        boolean bl = false;
        if (string != null) {
            Iterator iterator = this.fSchemas.iterator();
            while (iterator.hasNext()) {
                SchemaImpl schemaImpl = (SchemaImpl)iterator.next();
                if (!schemaImpl.isReferenceable() || !string.equals(schemaImpl.getNamespaceAsString())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

