/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.extensions.soap;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import org.apache.woden.ErrorLocator;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.util.dom.DOMUtils;
import org.apache.woden.internal.util.dom.QNameUtils;
import org.apache.woden.internal.wsdl20.Constants;
import org.apache.woden.wsdl20.extensions.ExtensionDeserializer;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.ExtensionRegistry;
import org.apache.woden.wsdl20.extensions.soap.SOAPModuleElement;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.DocumentableElement;
import org.apache.woden.wsdl20.xml.DocumentationElement;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.w3c.dom.Element;

public class SOAPModuleDeserializer
implements ExtensionDeserializer {
    public ExtensionElement unmarshall(Class clazz, Object object, QName qName, Element element, DescriptionElement descriptionElement, ExtensionRegistry extensionRegistry) throws WSDLException {
        Object object2;
        SOAPModuleElement sOAPModuleElement = (SOAPModuleElement)extensionRegistry.createExtElement(clazz, qName);
        sOAPModuleElement.setExtensionType(qName);
        sOAPModuleElement.setParentElement((WSDLElement)object);
        String string = DOMUtils.getAttribute(element, "ref");
        if (string != null) {
            object2 = null;
            try {
                object2 = new URI(string);
                sOAPModuleElement.setRef((URI)object2);
            }
            catch (URISyntaxException uRISyntaxException) {
                extensionRegistry.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL506", new Object[]{string}, (short)2, (Exception)uRISyntaxException);
            }
        }
        object2 = DOMUtils.getAttribute(element, "required");
        sOAPModuleElement.setRequired(new Boolean((String)object2));
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, element2)) {
                sOAPModuleElement.addDocumentationElement(this.parseDocumentation(element2, descriptionElement));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return sOAPModuleElement;
    }

    private DocumentationElement parseDocumentation(Element element, DocumentableElement documentableElement) throws WSDLException {
        DocumentationElement documentationElement = documentableElement.addDocumentationElement();
        documentationElement.setContent(element);
        return documentationElement;
    }
}

