/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jgap.BulkFitnessFunction;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.GeneticOperator;
import org.jgap.InvalidConfigurationException;
import org.jgap.event.GeneticEvent;

public class Genotype
implements Serializable {
    protected transient Configuration m_activeConfiguration;
    protected Chromosome[] m_chromosomes;
    protected transient List m_workingPool;

    public Genotype(Configuration configuration, Chromosome[] chromosomeArray) throws InvalidConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException("The Configuration instance may not be null.");
        }
        if (chromosomeArray == null) {
            throw new IllegalArgumentException("The array of Chromosomes may not be null.");
        }
        int n = 0;
        while (n < chromosomeArray.length) {
            if (chromosomeArray[n] == null) {
                throw new IllegalArgumentException("The Gene instance at index " + n + " of the array of " + "Chromosomes is null. No Gene instance in this array " + "may be null.");
            }
            ++n;
        }
        configuration.lockSettings();
        this.m_chromosomes = chromosomeArray;
        this.m_activeConfiguration = configuration;
        this.m_workingPool = new ArrayList();
    }

    public void setActiveConfiguration(Configuration configuration) throws InvalidConfigurationException {
        if (this.m_activeConfiguration == null) {
            if (configuration == null) {
                throw new InvalidConfigurationException("The given Configuration object may not be null.");
            }
            configuration.lockSettings();
            this.m_activeConfiguration = configuration;
            this.m_workingPool = new ArrayList();
            int n = 0;
            while (n < this.m_chromosomes.length) {
                this.m_chromosomes[n].setActiveConfiguration(this.m_activeConfiguration);
                ++n;
            }
        }
    }

    public synchronized Chromosome[] getChromosomes() {
        return this.m_chromosomes;
    }

    public synchronized Chromosome getFittestChromosome() {
        if (this.m_chromosomes.length == 0) {
            return null;
        }
        Chromosome chromosome = this.m_chromosomes[0];
        int n = chromosome.getFitnessValue();
        int n2 = 1;
        while (n2 < this.m_chromosomes.length) {
            if (this.m_chromosomes[n2].getFitnessValue() > n) {
                chromosome = this.m_chromosomes[n2];
                n = chromosome.getFitnessValue();
            }
            ++n2;
        }
        return chromosome;
    }

    public synchronized void evolve() {
        Object object;
        Chromosome[] chromosomeArray;
        this.verifyConfigurationAvailable();
        List list = this.m_activeConfiguration.getGeneticOperators();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((GeneticOperator)iterator.next()).operate(this.m_activeConfiguration, this.m_chromosomes, this.m_workingPool);
        }
        BulkFitnessFunction bulkFitnessFunction = this.m_activeConfiguration.getBulkFitnessFunction();
        if (bulkFitnessFunction != null) {
            chromosomeArray = this.m_workingPool.toArray(new Chromosome[this.m_workingPool.size()]);
            bulkFitnessFunction.evaluate(chromosomeArray);
        }
        chromosomeArray = this.m_workingPool.iterator();
        while (chromosomeArray.hasNext()) {
            object = (Chromosome)chromosomeArray.next();
            this.m_activeConfiguration.getNaturalSelector().add(this.m_activeConfiguration, (Chromosome)object);
        }
        this.m_chromosomes = this.m_activeConfiguration.getNaturalSelector().select(this.m_activeConfiguration, this.m_chromosomes.length);
        this.m_activeConfiguration.getEventManager().fireGeneticEvent(new GeneticEvent("genotype_evolved_event", this));
        object = this.m_workingPool.iterator();
        while (object.hasNext()) {
            Chromosome chromosome = (Chromosome)object.next();
            if (chromosome.isSelectedForNextGeneration()) continue;
            chromosome.cleanup();
        }
        this.m_workingPool.clear();
        this.m_activeConfiguration.getNaturalSelector().empty();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.m_chromosomes.length) {
            stringBuffer.append(this.m_chromosomes[n].toString());
            stringBuffer.append(" [");
            stringBuffer.append(this.m_chromosomes[n].getFitnessValue());
            stringBuffer.append(']');
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Genotype randomInitialGenotype(Configuration configuration) throws InvalidConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException("The Configuration instance may not be null.");
        }
        configuration.lockSettings();
        int n = configuration.getPopulationSize();
        Chromosome[] chromosomeArray = new Chromosome[n];
        int n2 = 0;
        while (n2 < n) {
            chromosomeArray[n2] = Chromosome.randomInitialChromosome(configuration);
            ++n2;
        }
        return new Genotype(configuration, chromosomeArray);
    }

    public boolean equals(Object object) {
        try {
            if (object == null) {
                return false;
            }
            Genotype genotype = (Genotype)object;
            if (this.m_chromosomes.length != genotype.m_chromosomes.length) {
                return false;
            }
            Arrays.sort(this.m_chromosomes);
            Arrays.sort(genotype.m_chromosomes);
            int n = 0;
            while (n < this.m_chromosomes.length) {
                if (!this.m_chromosomes[n].equals(genotype.m_chromosomes[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    private void verifyConfigurationAvailable() {
        if (this.m_activeConfiguration == null) {
            throw new IllegalStateException("The active Configuration object must be set on this Genotype prior to invocation of other operations.");
        }
    }
}

