/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.NewImage;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Frame;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Hashtable;

public class Executer
implements Runnable {
    private static String previousCommand;
    private String command;
    private ImagePlus iplus;
    private ImageJ ij;
    private Thread thread;

    public Executer(String cmd) {
        this.command = cmd;
        this.iplus = WindowManager.getCurrentImage();
        this.ij = IJ.getInstance();
    }

    public Executer(String cmd, ImagePlus imp) {
        this.iplus = imp;
        if (cmd.startsWith("Repeat")) {
            this.command = previousCommand;
        } else {
            this.command = cmd;
            if (!cmd.equals("Undo") && !cmd.equals("Close")) {
                previousCommand = cmd;
            }
        }
        this.ij = IJ.getInstance();
        this.thread = new Thread((Runnable)this, cmd);
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public void run() {
        block9: {
            if (this.command == null) {
                return;
            }
            ImagePlus imp = this.iplus;
            this.iplus = null;
            try {
                if (Recorder.record) {
                    Recorder.setCommand(this.command);
                    this.runCommand(this.command, imp);
                    Recorder.saveCommand();
                } else {
                    this.runCommand(this.command, imp);
                }
            }
            catch (Throwable e) {
                IJ.showStatus("");
                IJ.showProgress(1.0);
                if (imp != null) {
                    imp.unlock();
                }
                String msg = e.getMessage();
                if (e instanceof OutOfMemoryError) {
                    IJ.outOfMemory(this.command);
                }
                if (e instanceof RuntimeException && msg != null && msg.equals("Macro canceled")) break block9;
                CharArrayWriter caw = new CharArrayWriter();
                PrintWriter pw = new PrintWriter(caw);
                e.printStackTrace(pw);
                String s = caw.toString();
                if (IJ.isMacintosh()) {
                    if (s.indexOf("ThreadDeath") > 0) {
                        return;
                    }
                    s = Tools.fixNewLines(s);
                }
                new TextWindow("Exception", s, 350, 250);
            }
        }
    }

    public void runCommand(String cmd, ImagePlus imp) {
        if (cmd.equals("New...")) {
            new NewImage();
        } else if (cmd.equals("Open...")) {
            new Opener().open();
        } else if (cmd.equals("Close")) {
            this.close(imp);
        } else if (cmd.equals("Cut")) {
            this.copy(imp, true);
        } else if (cmd.equals("Copy")) {
            this.copy(imp, false);
        } else if (cmd.equals("ImageJ [enter]")) {
            this.ij.toFront();
        } else if (cmd.equals("Put Behind [tab]")) {
            WindowManager.putBehind();
        } else if (cmd.equals("Quit")) {
            IJ.getInstance().quit();
        } else {
            Hashtable table = Menus.getCommands();
            String plugIn = (String)table.get(cmd);
            if (plugIn != null) {
                this.runPlugIn(cmd, plugIn);
            } else {
                this.runImageCommand(cmd, imp);
            }
        }
    }

    public void runImageCommand(String cmd, ImagePlus imp) {
        ImageWindow win = null;
        if (imp != null) {
            if (!imp.lock()) {
                return;
            }
            win = imp.getWindow();
        }
        if (cmd.equals("Revert")) {
            if (win != null) {
                imp.revert();
            } else {
                IJ.noImage();
            }
        } else if (cmd.equals("Save")) {
            if (win != null) {
                new FileSaver(imp).save();
            } else {
                IJ.noImage();
            }
        } else if (cmd.equals("Paste")) {
            if (win != null) {
                win.paste();
            } else {
                IJ.noImage();
            }
        } else if (cmd.equals("Undo")) {
            if (win != null) {
                Undo.undo();
            } else {
                IJ.noImage();
            }
        } else {
            IJ.error("Unrecognized command: " + cmd);
        }
        if (imp != null) {
            imp.unlock();
        }
    }

    void runPlugIn(String cmd, String className) {
        int argStart;
        String arg = "";
        if (className.endsWith("\")") && (argStart = className.lastIndexOf("(\"")) > 0) {
            arg = className.substring(argStart + 2, className.length() - 2);
            className = className.substring(0, argStart);
        }
        IJ.runPlugIn(cmd, className, arg);
    }

    void roiRequired() {
        IJ.error("Selection required");
    }

    void copy(ImagePlus imp, boolean cut) {
        if (imp == null) {
            IJ.noImage();
            return;
        }
        imp.getWindow().copy(cut);
    }

    void close(ImagePlus imp) {
        Frame frame = WindowManager.getFrontWindow();
        if (frame != null && frame instanceof PlugInFrame) {
            ((PlugInFrame)frame).close();
        } else if (frame != null && frame instanceof TextWindow) {
            ((TextWindow)frame).close();
        } else if (imp == null) {
            IJ.noImage();
        } else {
            ImageWindow win = imp.getWindow();
            if (win != null) {
                win.close();
            } else if (IJ.macroRunning()) {
                WindowManager.setTempCurrentImage(null);
            }
        }
    }

    public static String getCommand() {
        return previousCommand;
    }
}

