/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Plot;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class ProfilePlot {
    static final int MIN_WIDTH = 350;
    static final double ASPECT_RATIO = 0.5;
    private double min;
    private double max;
    private boolean minAndMaxCalculated;
    private static double fixedMin = Prefs.getDouble("pp.min", 0.0);
    private static double fixedMax = Prefs.getDouble("pp.max", 0.0);
    protected ImagePlus imp;
    protected double[] profile;
    protected double magnification;
    protected double pixelSize;
    protected String units;
    protected String yLabel;
    static /* synthetic */ Class class$ij$gui$ProfilePlot;

    public ProfilePlot() {
    }

    public ProfilePlot(ImagePlus imp) {
        this(imp, false);
    }

    public ProfilePlot(ImagePlus imp, boolean averageHorizontally) {
        this.imp = imp;
        Roi roi = imp.getRoi();
        if (roi == null) {
            IJ.error("Selection required.");
            return;
        }
        int roiType = roi.getType();
        if (roiType != 5 && roiType != 6 && roiType != 7 && roiType != 0) {
            IJ.error("Line or rectangular selection required.");
            return;
        }
        Calibration cal = imp.getCalibration();
        this.pixelSize = cal.pixelWidth;
        this.units = cal.getUnits();
        this.yLabel = cal.getValueUnit();
        ImageProcessor ip = imp.getProcessor();
        ip.setCalibrationTable(cal.getCTable());
        if (roiType == 5) {
            ip.setInterpolate(true);
            this.profile = ((Line)roi).getPixels();
        } else {
            this.profile = roiType == 6 || roiType == 7 ? this.getIrregularProfile(roi, ip) : (averageHorizontally ? this.getRowAverageProfile(roi.getBoundingRect(), cal, ip) : this.getColumnAverageProfile(roi.getBoundingRect(), ip));
        }
        ip.setCalibrationTable(null);
        ImageWindow win = imp.getWindow();
        this.magnification = win != null ? win.getCanvas().getMagnification() : 1.0;
    }

    public Dimension getPlotSize() {
        if (this.profile == null) {
            return null;
        }
        int width = (int)((double)this.profile.length * this.magnification);
        int height = (int)((double)width * 0.5);
        if (width < 350) {
            width = 350;
            height = (int)((double)width * 0.5);
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int maxWidth = Math.min(screen.width - 200, 1000);
        if (width > maxWidth) {
            width = maxWidth;
            height = (int)((double)width * 0.5);
        }
        return new Dimension(width, height);
    }

    public void createWindow() {
        if (this.profile == null) {
            return;
        }
        Dimension d = this.getPlotSize();
        String xLabel = "Distance (" + this.units + ")";
        int n = this.profile.length;
        float[] xValues = new float[n];
        int i = 0;
        while (i < n) {
            xValues[i] = (float)((double)i * this.pixelSize);
            ++i;
        }
        float[] yValues = new float[n];
        int i2 = 0;
        while (i2 < n) {
            yValues[i2] = (float)this.profile[i2];
            ++i2;
        }
        boolean fixedYScale = fixedMin != 0.0 || fixedMax != 0.0;
        Plot plot = new Plot("Plot of " + this.imp.getShortTitle(), xLabel, this.yLabel, xValues, yValues);
        if (fixedYScale) {
            double[] a = Tools.getMinMax(xValues);
            plot.setLimits(a[0], a[1], fixedMin, fixedMax);
        }
        plot.show();
    }

    public double[] getProfile() {
        return this.profile;
    }

    public double getMin() {
        if (!this.minAndMaxCalculated) {
            this.findMinAndMax();
        }
        return this.min;
    }

    public double getMax() {
        if (!this.minAndMaxCalculated) {
            this.findMinAndMax();
        }
        return this.max;
    }

    public static void setMinAndMax(double min, double max) {
        fixedMin = min;
        fixedMax = max;
        IJ.register(class$ij$gui$ProfilePlot == null ? (class$ij$gui$ProfilePlot = ProfilePlot.class$("ij.gui.ProfilePlot")) : class$ij$gui$ProfilePlot);
    }

    public static double getFixedMin() {
        return fixedMin;
    }

    public static double getFixedMax() {
        return fixedMax;
    }

    double[] getRowAverageProfile(Rectangle rect, Calibration cal, ImageProcessor ip) {
        int i;
        double[] profile = new double[rect.height];
        ip.setInterpolate(false);
        int x = rect.x;
        while (x < rect.x + rect.width) {
            double[] aLine = ip.getLine(x, rect.y, x, rect.y + rect.height - 1);
            i = 0;
            while (i < rect.height) {
                int n = i;
                profile[n] = profile[n] + aLine[i];
                ++i;
            }
            ++x;
        }
        i = 0;
        while (i < rect.height) {
            int n = i++;
            profile[n] = profile[n] / (double)rect.width;
        }
        if (cal != null) {
            this.pixelSize = cal.pixelHeight;
        }
        return profile;
    }

    double[] getColumnAverageProfile(Rectangle rect, ImageProcessor ip) {
        int i;
        double[] profile = new double[rect.width];
        ip.setInterpolate(false);
        int y = rect.y;
        while (y < rect.y + rect.height) {
            double[] aLine = ip.getLine(rect.x, y, rect.x + rect.width - 1, y);
            i = 0;
            while (i < rect.width) {
                int n = i;
                profile[n] = profile[n] + aLine[i];
                ++i;
            }
            ++y;
        }
        i = 0;
        while (i < rect.width) {
            int n = i++;
            profile[n] = profile[n] / (double)rect.height;
        }
        return profile;
    }

    double[] getIrregularProfile(Roi roi, ImageProcessor ip) {
        int n = ((PolygonRoi)roi).getNCoordinates();
        int[] x = ((PolygonRoi)roi).getXCoordinates();
        int[] y = ((PolygonRoi)roi).getYCoordinates();
        Rectangle r = roi.getBoundingRect();
        int xbase = r.x;
        int ybase = r.y;
        double length = 0.0;
        double[] segmentLengths = new double[n];
        int[] dx = new int[n];
        int[] dy = new int[n];
        int i = 0;
        while (i < n - 1) {
            int xdelta = x[i + 1] - x[i];
            int ydelta = y[i + 1] - y[i];
            double segmentLength = Math.sqrt(xdelta * xdelta + ydelta * ydelta);
            length += segmentLength;
            segmentLengths[i] = segmentLength;
            dx[i] = xdelta;
            dy[i] = ydelta;
            ++i;
        }
        double[] values = new double[(int)length];
        double leftOver = 1.0;
        double distance = 0.0;
        int i2 = 0;
        while (i2 < n) {
            double len = segmentLengths[i2];
            if (len != 0.0) {
                double xinc = (double)dx[i2] / len;
                double yinc = (double)dy[i2] / len;
                double start = 1.0 - leftOver;
                double rx = (double)(xbase + x[i2]) + start * xinc;
                double ry = (double)(ybase + y[i2]) + start * yinc;
                double len2 = len - start;
                int n2 = (int)len2;
                int j = 0;
                while (j <= n2) {
                    int index = (int)distance + j;
                    if (index < values.length) {
                        values[index] = ip.getInterpolatedValue(rx, ry);
                    }
                    rx += xinc;
                    ry += yinc;
                    ++j;
                }
                distance += len;
                leftOver = len2 - (double)n2;
            }
            ++i2;
        }
        return values;
    }

    private double[] getLineSegment(ImageProcessor ip, double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        int n = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
        double xinc = dx / (double)n;
        double yinc = dy / (double)n;
        double[] data = new double[++n];
        double rx = x1;
        double ry = y1;
        int i = 0;
        while (i < n) {
            data[i] = ip.getInterpolatedValue(rx, ry);
            rx += xinc;
            ry += yinc;
            ++i;
        }
        return data;
    }

    void findMinAndMax() {
        if (this.profile == null) {
            return;
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < this.profile.length) {
            double value = this.profile[i];
            if (value < min) {
                min = value;
            }
            if (value > max) {
                max = value;
            }
            ++i;
        }
        this.min = min;
        this.max = max;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

