/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

import ij.IJ;
import ij.WindowManager;
import ij.plugin.filter.Analyzer;
import ij.text.TextPanel;
import ij.text.TextWindow;
import java.awt.Frame;

public class ResultsTable {
    public static final int MAX_COLUMNS = 50;
    public static final int COLUMN_NOT_FOUND = -1;
    public static final int COLUMN_IN_USE = -2;
    public static final int TABLE_FULL = -3;
    public static final int AREA = 0;
    public static final int MEAN = 1;
    public static final int STD_DEV = 2;
    public static final int MODE = 3;
    public static final int MIN = 4;
    public static final int MAX = 5;
    public static final int X_CENTROID = 6;
    public static final int Y_CENTROID = 7;
    public static final int X_CENTER_OF_MASS = 8;
    public static final int Y_CENTER_OF_MASS = 9;
    public static final int PERIMETER = 10;
    public static final int ROI_X = 11;
    public static final int ROI_Y = 12;
    public static final int ROI_WIDTH = 13;
    public static final int ROI_HEIGHT = 14;
    public static final int MAJOR = 15;
    public static final int MINOR = 16;
    public static final int ANGLE = 17;
    public static final int CIRCULARITY = 18;
    public static final int FERET = 19;
    private String[] headings = new String[50];
    private String[] defaultHeadings = new String[]{"Area", "Mean", "StdDev", "Mode", "Min", "Max", "X", "Y", "XM", "YM", "Perim.", "BX", "BY", "Width", "Height", "Major", "Minor", "Angle", "Circ.", "Feret"};
    private int counter;
    private float[][] columns = new float[50][];
    private String[] rowLabels;
    private int maxRows = 100;
    private int lastColumn = -1;
    private StringBuffer sb;
    private int precision = 3;
    private String rowLabelHeading = "";

    public ResultsTable() {
        int i = 0;
        while (i < this.defaultHeadings.length) {
            this.headings[i] = this.defaultHeadings[i];
            ++i;
        }
    }

    public static ResultsTable getResultsTable() {
        return Analyzer.getResultsTable();
    }

    public synchronized void incrementCounter() {
        ++this.counter;
        if (this.counter == this.maxRows) {
            if (this.rowLabels != null) {
                String[] s = new String[this.maxRows * 2];
                System.arraycopy(this.rowLabels, 0, s, 0, this.maxRows);
                this.rowLabels = s;
            }
            int i = 0;
            while (i < 50) {
                if (this.columns[i] != null) {
                    float[] tmp = new float[this.maxRows * 2];
                    System.arraycopy(this.columns[i], 0, tmp, 0, this.maxRows);
                    this.columns[i] = tmp;
                }
                ++i;
            }
            this.maxRows *= 2;
        }
    }

    public int getCounter() {
        return this.counter;
    }

    public void addValue(int column, double value) {
        if (column < 0 || column >= 50) {
            throw new IllegalArgumentException("Index out of range: " + column);
        }
        if (this.counter == 0) {
            throw new IllegalArgumentException("Counter==0");
        }
        if (this.columns[column] == null) {
            this.columns[column] = new float[this.maxRows];
            if (this.headings[column] == null) {
                this.headings[column] = "---";
            }
            if (column > this.lastColumn) {
                this.lastColumn = column;
            }
        }
        this.columns[column][this.counter - 1] = (float)value;
    }

    public void addValue(String column, double value) {
        int index = this.getColumnIndex(column);
        if (index == -1 && (index = this.getFreeColumn(column)) == -3) {
            throw new IllegalArgumentException("table is full");
        }
        this.addValue(index, value);
    }

    public void addLabel(String heading, String label) {
        if (this.counter == 0) {
            throw new IllegalArgumentException("Counter==0");
        }
        if (this.rowLabels == null) {
            this.rowLabels = new String[this.maxRows];
        }
        this.rowLabels[this.counter - 1] = label;
        if (heading != null) {
            this.rowLabelHeading = heading;
        }
    }

    public void disableRowLabels() {
        this.rowLabels = null;
    }

    public float[] getColumn(int column) {
        if (column < 0 || column >= 50) {
            throw new IllegalArgumentException("Index out of range: " + column);
        }
        if (this.columns[column] == null) {
            return null;
        }
        float[] data = new float[this.counter];
        int i = 0;
        while (i < this.counter) {
            data[i] = this.columns[column][i];
            ++i;
        }
        return data;
    }

    public boolean columnExists(int column) {
        if (column < 0 || column >= 50) {
            return false;
        }
        return this.columns[column] != null;
    }

    public int getColumnIndex(String heading) {
        int i = 0;
        while (i < this.headings.length) {
            if (this.headings[i] == null) {
                return -1;
            }
            if (this.headings[i].equals(heading)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getFreeColumn(String heading) {
        int i = 0;
        while (i < this.headings.length) {
            if (this.headings[i] == null) {
                this.columns[i] = new float[this.maxRows];
                this.headings[i] = heading;
                if (i > this.lastColumn) {
                    this.lastColumn = i;
                }
                return i;
            }
            if (this.headings[i].equals(heading)) {
                return -2;
            }
            ++i;
        }
        return -3;
    }

    public float getValue(int column, int row) {
        if (this.columns[column] == null) {
            throw new IllegalArgumentException("Column not defined: " + column);
        }
        if (column >= 50 || row >= this.counter) {
            throw new IllegalArgumentException("Index out of range: " + column + "," + row);
        }
        return this.columns[column][row];
    }

    public double getValue(String column, int row) {
        if (row < 0 || row >= this.getCounter()) {
            throw new IllegalArgumentException("Row out of range");
        }
        int col = this.getColumnIndex(column);
        return col == -1 ? Double.NaN : (double)this.getValue(col, row);
    }

    public void setValue(String column, int row, double value) {
        int col = this.getColumnIndex(column);
        if (col == -1 && (col = this.getFreeColumn(column)) == -3) {
            throw new IllegalArgumentException("Too many columns (>" + (50 - this.defaultHeadings.length) + ")");
        }
        this.setValue(col, row, value);
    }

    public void setValue(int column, int row, double value) {
        if (column < 0 || column >= 50) {
            throw new IllegalArgumentException("Column out of range: " + column);
        }
        if (row >= this.counter) {
            throw new IllegalArgumentException("row>=counter");
        }
        if (this.columns[column] == null) {
            this.columns[column] = new float[this.maxRows];
            if (column > this.lastColumn) {
                this.lastColumn = column;
            }
        }
        this.columns[column][row] = (float)value;
    }

    public String getColumnHeadings() {
        StringBuffer sb = new StringBuffer(200);
        sb.append(" \t");
        if (this.rowLabels != null) {
            sb.append(this.rowLabelHeading + "\t");
        }
        int i = 0;
        while (i <= this.lastColumn) {
            if (this.columns[i] != null) {
                String heading = this.headings[i];
                if (heading == null) {
                    heading = "---";
                }
                sb.append(heading + "\t");
            }
            ++i;
        }
        return new String(sb);
    }

    public String getColumnHeading(int column) {
        if (column < 0 || column >= 50) {
            throw new IllegalArgumentException("Index out of range: " + column);
        }
        return this.headings[column];
    }

    public String getRowAsString(int row) {
        if (row < 0 || row >= this.counter) {
            throw new IllegalArgumentException("Row out of range: " + row);
        }
        if (this.sb == null) {
            this.sb = new StringBuffer(200);
        } else {
            this.sb.setLength(0);
        }
        this.sb.append(Integer.toString(row + 1));
        this.sb.append("\t");
        if (this.rowLabels != null) {
            if (this.rowLabels[row] != null) {
                this.sb.append(this.rowLabels[row]);
            }
            this.sb.append("\t");
        }
        int i = 0;
        while (i <= this.lastColumn) {
            if (this.columns[i] != null) {
                this.sb.append(this.n(this.columns[i][row]));
            }
            ++i;
        }
        return new String(this.sb);
    }

    public void setHeading(int column, String heading) {
        if (column < 0 || column >= this.headings.length) {
            throw new IllegalArgumentException("Column out of range: " + column);
        }
        this.headings[column] = heading;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    String n(double n) {
        String s = (double)Math.round(n) == n ? IJ.d2s(n, 0) : IJ.d2s(n, this.precision);
        return s + "\t";
    }

    public synchronized void reset() {
        this.counter = 0;
        this.maxRows = 100;
        int i = 0;
        while (i <= this.lastColumn) {
            this.columns[i] = null;
            this.headings[i] = i < this.defaultHeadings.length ? this.defaultHeadings[i] : null;
            ++i;
        }
        this.lastColumn = -1;
    }

    public void show(String windowTitle) {
        TextPanel tp;
        String tableHeadings = this.getColumnHeadings();
        if (windowTitle.equals("Results")) {
            tp = IJ.getTextPanel();
            if (tp == null) {
                return;
            }
            IJ.setColumnHeadings(tableHeadings);
        } else {
            Frame frame = WindowManager.getFrame(windowTitle);
            TextWindow win = frame != null && frame instanceof TextWindow ? (TextWindow)frame : new TextWindow(windowTitle, "", 300, 200);
            tp = win.getTextPanel();
            tp.setColumnHeadings(tableHeadings);
        }
        int n = this.getCounter();
        if (n > 0) {
            StringBuffer sb = new StringBuffer(n * tableHeadings.length());
            int i = 0;
            while (i < n) {
                sb.append(this.getRowAsString(i) + "\n");
                ++i;
            }
            tp.append(new String(sb));
        }
    }

    public String toString() {
        return "ctr=" + this.counter + ", hdr=" + this.getColumnHeadings();
    }
}

