/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;

public class BoxFilter
implements PlugInFilter {
    static final int BYTE = 0;
    static final int SHORT = 1;
    static final int FLOAT = 2;
    static final int RGB = 3;
    ImagePlus imp;
    int slice;
    boolean canceled;
    ImageWindow win;
    boolean isLineRoi;
    static double radius = 2.0;
    static int boxWidth = 5;
    static int boxHeight = 5;
    static /* synthetic */ Class class$ij$plugin$filter$BoxFilter;

    public int setup(String arg, ImagePlus imp) {
        IJ.register(class$ij$plugin$filter$BoxFilter == null ? (class$ij$plugin$filter$BoxFilter = BoxFilter.class$("ij.plugin.filter.BoxFilter")) : class$ij$plugin$filter$BoxFilter);
        this.imp = imp;
        this.slice = 0;
        this.canceled = false;
        if (imp != null) {
            this.win = imp.getWindow();
            this.win.running = true;
            Roi roi = imp.getRoi();
            boolean bl = this.isLineRoi = roi != null && roi.getType() >= 5;
        }
        if (imp != null && !this.showDialog()) {
            return 4096;
        }
        return IJ.setupDialog(imp, 31);
    }

    public void run(ImageProcessor ip) {
        int type;
        if (this.canceled) {
            return;
        }
        ++this.slice;
        if (this.win != null && !this.win.running) {
            this.canceled = true;
            IJ.beep();
            return;
        }
        if (this.isLineRoi) {
            ip.resetRoi();
        }
        if ((type = this.getType(ip)) == 3) {
            this.blurRGB(ip, boxWidth, boxHeight);
        } else {
            ImageProcessor ip2 = this.blur(ip, boxWidth, boxHeight);
            this.convertBack(ip2, ip, type);
        }
        if (this.slice > 1) {
            IJ.showStatus("Mean: : " + this.slice + "/" + this.imp.getStackSize());
        }
        if (this.imp != null && this.slice == this.imp.getStackSize()) {
            ip.resetMinAndMax();
        }
    }

    int getType(ImageProcessor ip) {
        int type = ip instanceof ByteProcessor ? 0 : (ip instanceof ShortProcessor ? 1 : (ip instanceof FloatProcessor ? 2 : 3));
        return type;
    }

    public void convertBack(ImageProcessor ip2, ImageProcessor ip, int type) {
        switch (type) {
            case 0: {
                ip2 = ip2.convertToByte(false);
                byte[] pixels = (byte[])ip.getPixels();
                byte[] pixels2 = (byte[])ip2.getPixels();
                System.arraycopy(pixels2, 0, pixels, 0, pixels.length);
                break;
            }
            case 1: {
                ip2 = ip2.convertToShort(false);
                short[] pixels16 = (short[])ip.getPixels();
                short[] pixels16b = (short[])ip2.getPixels();
                System.arraycopy(pixels16b, 0, pixels16, 0, pixels16.length);
                break;
            }
        }
    }

    boolean showDialog() {
        GenericDialog gd = new GenericDialog("Blur...");
        gd.addNumericField("Kernel Size:", boxWidth, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.canceled = true;
            return false;
        }
        boxWidth = (int)gd.getNextNumber();
        if (boxWidth < 1) {
            boxWidth = 1;
        }
        boxHeight = boxWidth;
        this.imp.startTiming();
        return true;
    }

    ImageProcessor blur(ImageProcessor ip1, int boxw, int boxh) {
        ip1 = this.preCalculateSums(ip1);
        int width = ip1.getWidth();
        int height = ip1.getHeight();
        float[] pixels1 = (float[])ip1.getPixels();
        float[] pixels2 = new float[width * height];
        double scale = 1.0 / ((double)boxw * 2.0 * ((double)boxh * 2.0));
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                double sum = this.getPixel(pixels1, width, height, x + boxw, y + boxh) + this.getPixel(pixels1, width, height, x - boxw, y - boxh) - this.getPixel(pixels1, width, height, x - boxw, y + boxh) - this.getPixel(pixels1, width, height, x + boxw, y - boxh);
                pixels2[x + y * width] = (float)(sum * scale);
                ++x;
            }
            ++y;
        }
        return new FloatProcessor(width, height, pixels2, null);
    }

    ImageProcessor preCalculateSums(ImageProcessor ip1) {
        int width = ip1.getWidth();
        int height = ip1.getHeight();
        ip1 = ip1.convertToFloat();
        ImageProcessor ip2 = ip1.duplicate();
        float[] pixels1 = (float[])ip1.getPixels();
        float[] pixels2 = (float[])ip2.getPixels();
        int y = 0;
        while (y < height) {
            int offset = y * width;
            int x = 0;
            while (x < width) {
                float sum = pixels1[offset];
                if (x > 0) {
                    sum += pixels2[offset - 1];
                }
                if (y > 0) {
                    sum += pixels2[offset - width];
                }
                if (x > 0 && y > 0) {
                    sum -= pixels2[offset - width - 1];
                }
                pixels2[offset] = sum;
                ++offset;
                ++x;
            }
            ++y;
        }
        return ip2;
    }

    double getPixel(float[] pixels, int w, int h, int x, int y) {
        if (x < 0) {
            x = 0;
        } else if (x >= w) {
            x = w - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= h) {
            y = h - 1;
        }
        return pixels[x + y * w];
    }

    public void blurRGB(ImageProcessor ip, int boxw, int boxh) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle roi = ip.getRoi();
        int size = width * height;
        if (this.slice == 1) {
            IJ.showStatus("Blur... (red)");
        }
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        ((ColorProcessor)ip).getRGB(r, g, b);
        ByteProcessor rip = new ByteProcessor(width, height, r, null);
        ByteProcessor gip = new ByteProcessor(width, height, g, null);
        ByteProcessor bip = new ByteProcessor(width, height, b, null);
        ImageProcessor ip2 = this.blur(rip, boxWidth, boxHeight);
        if (this.canceled) {
            return;
        }
        ImageProcessor r2 = ip2.convertToByte(false);
        if (this.slice == 1) {
            IJ.showStatus("Blur... (green)");
        }
        ip2 = this.blur(gip, boxWidth, boxHeight);
        if (this.canceled) {
            return;
        }
        ImageProcessor g2 = ip2.convertToByte(false);
        if (this.slice == 1) {
            IJ.showStatus("Blur... (blue)");
        }
        ip2 = this.blur(bip, boxWidth, boxHeight);
        if (this.canceled) {
            return;
        }
        ImageProcessor b2 = ip2.convertToByte(false);
        ((ColorProcessor)ip).setRGB((byte[])r2.getPixels(), (byte[])g2.getPixels(), (byte[])b2.getPixels());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

