/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.ImageWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class EDM
implements PlugInFilter {
    ImagePlus imp;
    String arg;
    int maxEDM;
    short[] xCoordinate;
    short[] yCoordinate;
    int[] levelStart;
    int[] levelOffset;
    int[] histogram;
    int slice;
    int count;
    boolean watershed;
    ImageWindow win;
    boolean canceled;
    ImageStack movie;
    boolean debug = IJ.debugMode;
    boolean invertImage;
    static boolean whiteBackground = true;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        this.arg = arg;
        this.watershed = arg.equals("watershed");
        boolean invertedLut = imp.isInvertedLut();
        this.invertImage = invertedLut && Prefs.blackBackground || !invertedLut && !Prefs.blackBackground;
        return IJ.setupDialog(imp, 1);
    }

    public void run(ImageProcessor ip) {
        ++this.slice;
        this.win = this.imp.getWindow();
        if (this.win != null) {
            this.win.running = true;
        }
        ImageStatistics stats = this.imp.getStatistics();
        if (this.slice == 1 && stats.histogram[0] + stats.histogram[255] != stats.pixelCount) {
            IJ.error("8-bit binary image (0 and 255) required.");
            return;
        }
        if (this.invertImage) {
            ip.invert();
        }
        ImageProcessor ip2 = this.makeEDM(ip);
        if (this.arg.equals("points")) {
            this.findUltimatePoints(ip2);
        } else if (this.watershed) {
            this.findUltimatePoints(ip2);
            this.doWatershed(ip2);
        }
        IJ.showProgress(1.0);
        if (!this.canceled) {
            ip.copyBits(ip2, 0, 0, 0);
            if (this.invertImage) {
                ip.invert();
            }
        }
    }

    public ImageProcessor makeEDM(ImageProcessor ip) {
        int offset;
        int one = 41;
        int sqrt2 = 58;
        int sqrt5 = 92;
        IJ.showStatus("Generating EDM");
        this.imp.killRoi();
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        int rowsize = width;
        int xmax = width - 3;
        int ymax = height - 3;
        ImageProcessor ip16 = ip.convertToShort(false);
        ip16.multiply(one);
        short[] image16 = (short[])ip16.getPixels();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                offset = x + y * rowsize;
                if (image16[offset] > 0) {
                    if (x < 2 || x > xmax || y < 2 || y > ymax) {
                        this.setEdgeValue(offset, rowsize, image16, x, y, xmax, ymax);
                    } else {
                        this.setValue(offset, rowsize, image16);
                    }
                }
                ++x;
            }
            ++y;
        }
        int y2 = height - 1;
        while (y2 >= 0) {
            int x = width - 1;
            while (x >= 0) {
                offset = x + y2 * rowsize;
                if (image16[offset] > 0) {
                    if (x < 2 || x > xmax || y2 < 2 || y2 > ymax) {
                        this.setEdgeValue(offset, rowsize, image16, x, y2, xmax, ymax);
                    } else {
                        this.setValue(offset, rowsize, image16);
                    }
                }
                --x;
            }
            --y2;
        }
        ImageProcessor ip2 = ip.createProcessor(width, height);
        byte[] image8 = (byte[])ip2.getPixels();
        this.convertToBytes(width, height, image16, image8);
        return ip2;
    }

    void setValue(int offset, int rowsize, short[] image16) {
        int one = 41;
        int sqrt2 = 58;
        int sqrt5 = 92;
        int r1 = offset - rowsize - rowsize - 2;
        int r2 = r1 + rowsize;
        int r3 = r2 + rowsize;
        int r4 = r3 + rowsize;
        int r5 = r4 + rowsize;
        int v = image16[r2 + 2] + one;
        int min = Short.MAX_VALUE;
        if (v < min) {
            min = v;
        }
        if ((v = image16[r3 + 1] + one) < min) {
            min = v;
        }
        if ((v = image16[r3 + 3] + one) < min) {
            min = v;
        }
        if ((v = image16[r4 + 2] + one) < min) {
            min = v;
        }
        if ((v = image16[r2 + 1] + sqrt2) < min) {
            min = v;
        }
        if ((v = image16[r2 + 3] + sqrt2) < min) {
            min = v;
        }
        if ((v = image16[r4 + 1] + sqrt2) < min) {
            min = v;
        }
        if ((v = image16[r4 + 3] + sqrt2) < min) {
            min = v;
        }
        if ((v = image16[r1 + 1] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r1 + 3] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r2 + 4] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r4 + 4] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r5 + 3] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r5 + 1] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r4] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r2] + sqrt5) < min) {
            min = v;
        }
        image16[offset] = (short)min;
    }

    void setEdgeValue(int offset, int rowsize, short[] image16, int x, int y, int xmax, int ymax) {
        int one = 41;
        int sqrt2 = 58;
        int sqrt5 = 92;
        int r1 = offset - rowsize - rowsize - 2;
        int r2 = r1 + rowsize;
        int r3 = r2 + rowsize;
        int r4 = r3 + rowsize;
        int r5 = r4 + rowsize;
        int min = Short.MAX_VALUE;
        short offimage = image16[r3 + 2];
        int v = y < 2 ? offimage + one : image16[r2 + 2] + one;
        if (v < min) {
            min = v;
        }
        if ((v = x < 2 ? offimage + one : image16[r3 + 1] + one) < min) {
            min = v;
        }
        if ((v = x > xmax ? offimage + one : image16[r3 + 3] + one) < min) {
            min = v;
        }
        if ((v = y > ymax ? offimage + one : image16[r4 + 2] + one) < min) {
            min = v;
        }
        if ((v = x < 2 || y < 2 ? offimage + sqrt2 : image16[r2 + 1] + sqrt2) < min) {
            min = v;
        }
        if ((v = x > xmax || y < 2 ? offimage + sqrt2 : image16[r2 + 3] + sqrt2) < min) {
            min = v;
        }
        if ((v = x < 2 || y > ymax ? offimage + sqrt2 : image16[r4 + 1] + sqrt2) < min) {
            min = v;
        }
        if ((v = x > xmax || y > ymax ? offimage + sqrt2 : image16[r4 + 3] + sqrt2) < min) {
            min = v;
        }
        if ((v = x < 2 || y < 2 ? offimage + sqrt5 : image16[r1 + 1] + sqrt5) < min) {
            min = v;
        }
        if ((v = x > xmax || y < 2 ? offimage + sqrt5 : image16[r1 + 3] + sqrt5) < min) {
            min = v;
        }
        if ((v = x > xmax || y < 2 ? offimage + sqrt5 : image16[r2 + 4] + sqrt5) < min) {
            min = v;
        }
        if ((v = x > xmax || y > ymax ? offimage + sqrt5 : image16[r4 + 4] + sqrt5) < min) {
            min = v;
        }
        if ((v = x > xmax || y > ymax ? offimage + sqrt5 : image16[r5 + 3] + sqrt5) < min) {
            min = v;
        }
        if ((v = x < 2 || y > ymax ? offimage + sqrt5 : image16[r5 + 1] + sqrt5) < min) {
            min = v;
        }
        if ((v = x < 2 || y > ymax ? offimage + sqrt5 : image16[r4] + sqrt5) < min) {
            min = v;
        }
        if ((v = x < 2 || y < 2 ? offimage + sqrt5 : image16[r2] + sqrt5) < min) {
            min = v;
        }
        image16[offset] = (short)min;
    }

    void convertToBytes(int width, int height, short[] image16, byte[] image8) {
        int one = 41;
        int round = one / 2;
        this.maxEDM = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int offset = x + y * width;
                int v = (image16[offset] + round) / one;
                if (v > 255) {
                    v = 255;
                }
                if (v > this.maxEDM) {
                    this.maxEDM = v;
                }
                image8[offset] = (byte)v;
                ++x;
            }
            ++y;
        }
    }

    public void findUltimatePoints(ImageProcessor ip) {
        int i;
        IJ.showStatus("Finding ultimate points");
        if (this.debug) {
            this.movie = new ImageStack(ip.getWidth(), ip.getHeight());
            this.movie.addSlice("EDM", ip.duplicate());
        }
        if (this.watershed) {
            this.filterEDM(ip, true);
            this.filterEDM(ip, false);
        }
        if (this.debug) {
            this.movie.addSlice("Filtered EDM", ip.duplicate());
        }
        this.makeCoordinateArrays(ip);
        byte[] image = (byte[])ip.getPixels();
        ImageProcessor ip2 = null;
        if (this.watershed) {
            ip2 = ip.duplicate();
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        int rowsize = width;
        int xmax = width - 1;
        int ymax = height - 1;
        int level = this.maxEDM - 1;
        while (level >= 1) {
            int count;
            do {
                count = 0;
                i = 0;
                while (i < this.histogram[level]) {
                    int CoordOffset = this.levelStart[level] + i;
                    short x = this.xCoordinate[CoordOffset];
                    short y = this.yCoordinate[CoordOffset];
                    int offset = x + y * rowsize;
                    if ((image[offset] & 0xFF) != 255) {
                        boolean setPixel = false;
                        if (x > 0 && y > 0 && (image[offset - rowsize - 1] & 0xFF) > level) {
                            setPixel = true;
                        }
                        if (y > 0 && (image[offset - rowsize] & 0xFF) > level) {
                            setPixel = true;
                        }
                        if (x < xmax && y > 0 && (image[offset - rowsize + 1] & 0xFF) > level) {
                            setPixel = true;
                        }
                        if (x < xmax && (image[offset + 1] & 0xFF) > level) {
                            setPixel = true;
                        }
                        if (x < xmax && y < ymax && (image[offset + rowsize + 1] & 0xFF) > level) {
                            setPixel = true;
                        }
                        if (y < ymax && (image[offset + rowsize] & 0xFF) > level) {
                            setPixel = true;
                        }
                        if (x > 0 && y < ymax && (image[offset + rowsize - 1] & 0xFF) > level) {
                            setPixel = true;
                        }
                        if (x > 0 && (image[offset - 1] & 0xFF) > level) {
                            setPixel = true;
                        }
                        if (setPixel) {
                            image[offset] = -1;
                            ++count;
                        }
                    }
                    ++i;
                }
            } while (count != 0);
            --level;
        }
        if (this.watershed) {
            byte[] image2 = (byte[])ip2.getPixels();
            int i2 = 0;
            while (i2 < width * height) {
                if ((image[i2] & 0xFF) > 0 && (image[i2] & 0xFF) < 255) {
                    image2[i2] = -1;
                }
                ++i2;
            }
            ip.insert(ip2, 0, 0);
        } else {
            i = 0;
            while (i < width * height) {
                if ((image[i] & 0xFF) == 255) {
                    image[i] = 0;
                }
                ++i;
            }
        }
    }

    void filterEDM(ImageProcessor edm, boolean smooth) {
        byte[] image = (byte[])edm.getPixels();
        ImageProcessor ip2 = edm.duplicate();
        byte[] image2 = (byte[])ip2.getPixels();
        int width = edm.getWidth();
        int height = edm.getHeight();
        int rowsize = width;
        int xmax = width - 1;
        int ymax = height - 1;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int offset = x + y * rowsize;
                byte p0 = image2[offset];
                if (p0 > 1) {
                    int sum = image2[offset] * 2;
                    int p1 = x > 0 && y > 0 ? image2[offset - rowsize - 1] : this.get(x - 1, y - 1, image2, width, height);
                    int p2 = y > 0 ? image2[offset - rowsize] : this.get(x, y - 1, image2, width, height);
                    int p3 = x < xmax && y > 0 ? image2[offset - rowsize + 1] : this.get(x + 1, y - 1, image2, width, height);
                    int p4 = x < xmax ? image2[offset + 1] : this.get(x + 1, y, image2, width, height);
                    int p5 = x < xmax && y < ymax ? image2[offset + rowsize + 1] : this.get(x + 1, y + 1, image2, width, height);
                    int p6 = y < ymax ? image2[offset + rowsize] : this.get(x, y + 1, image2, width, height);
                    int p7 = x > 0 && y < ymax ? image2[offset + rowsize - 1] : this.get(x - 1, y + 1, image2, width, height);
                    int p8 = x > 0 ? image2[offset - 1] : this.get(x - 1, y, image2, width, height);
                    int v = p0 - 1;
                    if (smooth) {
                        image[offset] = (byte)((p0 + p1 + p2 + p3 + p4 + p5 + p6 + p7 + p8) / 9);
                    } else if (p2 == v && p4 == v && p6 == v && p8 == v && (p1 == p0 && p3 == v && p5 == v && p7 == v || p3 == p0 && p1 == v && p5 == v && p7 == v || p5 == p0 && p1 == v && p3 == v && p7 == v || p7 == p0 && p1 == v && p3 == v && p5 == v)) {
                        image[offset] = (byte)v;
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    int get(int x, int y, byte[] pixels, int width, int height) {
        if (x <= 0) {
            x = 0;
        }
        if (x >= width) {
            x = width - 1;
        }
        if (y <= 0) {
            y = 0;
        }
        if (y >= height) {
            y = height - 1;
        }
        return pixels[x + y * width];
    }

    void makeCoordinateArrays(ImageProcessor edm) {
        int width = edm.getWidth();
        int height = edm.getHeight();
        this.histogram = edm.getHistogram();
        int ArraySize = 0;
        int i = 0;
        while (i < this.maxEDM - 1) {
            ArraySize += this.histogram[i];
            ++i;
        }
        this.xCoordinate = new short[ArraySize];
        this.yCoordinate = new short[ArraySize];
        byte[] image = (byte[])edm.getPixels();
        int offset = 0;
        this.levelStart = new int[256];
        int i2 = 0;
        while (i2 < 256) {
            this.levelStart[i2] = offset;
            if (i2 > 0 && i2 < this.maxEDM) {
                offset += this.histogram[i2];
            }
            ++i2;
        }
        this.levelOffset = new int[256];
        int rowsize = width;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int v = image[x + y * rowsize] & 0xFF;
                if (v > 0 && v < this.maxEDM) {
                    offset = this.levelStart[v] + this.levelOffset[v];
                    this.xCoordinate[offset] = (short)x;
                    this.yCoordinate[offset] = (short)y;
                    int n = v;
                    this.levelOffset[n] = this.levelOffset[n] + 1;
                }
                ++x;
            }
            ++y;
        }
    }

    void doWatershed(ImageProcessor ip1) {
        int[] table = this.makeFateTable();
        if (this.debug) {
            this.movie.addSlice("EDM+UEPs", ip1.duplicate());
        }
        IJ.showStatus("Watershed (press esc to cancel)");
        ImageProcessor ip2 = ip1.duplicate();
        int level = this.maxEDM - 1;
        while (level >= 1) {
            IJ.showProgress(this.maxEDM - level, this.maxEDM - 1);
            do {
                this.count = 0;
                this.processLevel(level, 1, ip1, ip2, table);
                this.processLevel(level, 3, ip1, ip2, table);
                this.processLevel(level, 2, ip1, ip2, table);
                this.processLevel(level, 4, ip1, ip2, table);
            } while (this.count > 0);
            if (this.debug) {
                this.movie.addSlice("level " + level, ip1.duplicate());
            }
            if (!this.win.running) {
                this.canceled = true;
                IJ.beep();
                break;
            }
            --level;
        }
        if (!this.canceled) {
            this.postProcess(ip1);
        }
        if (this.debug) {
            this.movie.addSlice("Post-processed", ip1.duplicate());
            new ImagePlus("The movie", this.movie).show();
        }
    }

    int[] makeFateTable() {
        int[] table = new int[]{0, 0, 4, 4, 0, 0, 4, 4, 8, 0, 12, 12, 8, 0, 12, 12, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 12, 12, 8, 0, 12, 12, 1, 0, 0, 0, 0, 0, 0, 0, 8, 0, 15, 15, 8, 0, 15, 15, 1, 0, 0, 0, 0, 0, 0, 0, 9, 0, 15, 15, 9, 0, 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 9, 0, 15, 15, 9, 0, 15, 15, 1, 0, 0, 0, 0, 0, 0, 0, 9, 0, 15, 15, 9, 0, 15, 15, 2, 2, 6, 6, 0, 0, 6, 6, 0, 0, 15, 15, 0, 0, 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 15, 0, 0, 15, 15, 1, 3, 15, 15, 0, 0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 3, 3, 15, 15, 0, 0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 2, 2, 6, 6, 0, 0, 6, 6, 0, 0, 15, 15, 0, 0, 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 15, 0, 0, 15, 15, 3, 3, 15, 15, 0, 0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 3, 3, 15, 15, 0, 0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
        return table;
    }

    void processLevel(int level, int pass, ImageProcessor ip1, ImageProcessor ip2, int[] table) {
        int rowSize = ip1.getWidth();
        int height = ip1.getHeight();
        int xmax = rowSize - 1;
        int ymax = ip1.getHeight() - 1;
        byte[] pixels1 = (byte[])ip1.getPixels();
        byte[] pixels2 = (byte[])ip2.getPixels();
        System.arraycopy(pixels1, 0, pixels2, 0, rowSize * height);
        int i = 0;
        while (i < this.histogram[level]) {
            int coordOffset = this.levelStart[level] + i;
            short x = this.xCoordinate[coordOffset];
            short y = this.yCoordinate[coordOffset];
            int offset = x + y * rowSize;
            if ((pixels2[offset] & 0xFF) != 255) {
                int index = 0;
                if (x > 0 && y > 0 && (pixels2[offset - rowSize - 1] & 0xFF) == 255) {
                    index ^= 1;
                }
                if (y > 0 && (pixels2[offset - rowSize] & 0xFF) == 255) {
                    index ^= 2;
                }
                if (x < xmax && y > 0 && (pixels2[offset - rowSize + 1] & 0xFF) == 255) {
                    index ^= 4;
                }
                if (x < xmax && (pixels2[offset + 1] & 0xFF) == 255) {
                    index ^= 8;
                }
                if (x < xmax && y < ymax && (pixels2[offset + rowSize + 1] & 0xFF) == 255) {
                    index ^= 0x10;
                }
                if (y < ymax && (pixels2[offset + rowSize] & 0xFF) == 255) {
                    index ^= 0x20;
                }
                if (x > 0 && y < ymax && (pixels2[offset + rowSize - 1] & 0xFF) == 255) {
                    index ^= 0x40;
                }
                if (x > 0 && (pixels2[offset - 1] & 0xFF) == 255) {
                    index ^= 0x80;
                }
                switch (pass) {
                    case 1: {
                        if ((table[index] & 1) != 1) break;
                        pixels1[offset] = -1;
                        ++this.count;
                        break;
                    }
                    case 2: {
                        if ((table[index] & 2) != 2) break;
                        pixels1[offset] = -1;
                        ++this.count;
                        break;
                    }
                    case 3: {
                        if ((table[index] & 4) != 4) break;
                        pixels1[offset] = -1;
                        ++this.count;
                        break;
                    }
                    case 4: {
                        if ((table[index] & 8) != 8) break;
                        pixels1[offset] = -1;
                        ++this.count;
                    }
                }
            }
            ++i;
        }
    }

    void postProcess(ImageProcessor ip) {
        byte[] pixels = (byte[])ip.getPixels();
        int size = ip.getWidth() * ip.getHeight();
        int i = 0;
        while (i < size) {
            if ((pixels[i] & 0xFF) < 255) {
                pixels[i] = 0;
            }
            ++i;
        }
    }
}

