/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.ImagePlus;
import ij.measure.Calibration;
import ij.plugin.filter.ImagePropertiesDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.util.Locale;

public class ImageProperties
implements PlugInFilter {
    ImagePlus imp;
    static final int NANOMETER = 0;
    static final int MICROMETER = 1;
    static final int MILLIMETER = 2;
    static final int CENTIMETER = 3;
    static final int METER = 4;
    static final int KILOMETER = 5;
    static final int INCH = 6;
    static final int FOOT = 7;
    static final int MILE = 8;
    static final int PIXEL = 9;
    static final int OTHER_UNIT = 10;
    int oldUnitIndex;
    double oldUnitsPerCm;
    double oldScale;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 159;
    }

    public void run(ImageProcessor ip) {
        this.showDialog(this.imp);
    }

    void showDialog(ImagePlus imp) {
        Calibration cal = imp.getCalibration();
        this.oldUnitIndex = this.getUnitIndex(cal.getUnit());
        this.oldUnitsPerCm = this.getUnitsPerCm(this.oldUnitIndex);
        ImagePropertiesDialog gd = new ImagePropertiesDialog(imp.getTitle(), this);
        gd.addStringField("Unit of Length:", cal.getUnit());
        this.oldScale = cal.pixelWidth != 0.0 ? 1.0 / cal.pixelWidth : 0.0;
        gd.addNumericField("Pixels/Unit:", this.oldScale, (double)((int)this.oldScale) == this.oldScale ? 0 : 3);
        int stackSize = imp.getStackSize();
        if (stackSize > 1) {
            gd.addMessage("");
            gd.addNumericField("Slice Spacing:", cal.pixelDepth, (double)((int)cal.pixelDepth) == cal.pixelDepth ? 0 : 3);
            double fps = cal.frameInterval > 0.0 ? 1.0 / cal.frameInterval : 0.0;
            gd.addNumericField("Frames per Second:", fps, (double)((int)fps) == fps ? 0 : 2);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String unit = gd.getNextString();
        if (unit.equals("um")) {
            unit = "\u00b5m";
        } else if (unit.equals("A")) {
            unit = "\u00c5";
        }
        double resolution = gd.getNextNumber();
        if (unit.equals("") || unit.equalsIgnoreCase("pixel") || unit.equalsIgnoreCase("none") || resolution == 0.0) {
            cal.setUnit(null);
            cal.pixelWidth = 1.0;
            cal.pixelHeight = 1.0;
        } else {
            cal.setUnit(unit);
            cal.pixelWidth = 1.0 / resolution;
            cal.pixelHeight = 1.0 / resolution;
        }
        if (stackSize > 1) {
            double spacing = gd.getNextNumber();
            double fps = gd.getNextNumber();
            cal.pixelDepth = spacing;
            cal.frameInterval = fps != 0.0 ? 1.0 / fps : 0.0;
        }
        imp.repaintWindow();
    }

    double getNewScale(String newUnit) {
        if (this.oldUnitsPerCm == 0.0) {
            return 0.0;
        }
        double newScale = 0.0;
        int newUnitIndex = this.getUnitIndex(newUnit);
        if (newUnitIndex != this.oldUnitIndex) {
            double newUnitsPerCm = this.getUnitsPerCm(newUnitIndex);
            if (this.oldUnitsPerCm != 0.0 && newUnitsPerCm != 0.0) {
                newScale = this.oldScale * (this.oldUnitsPerCm / newUnitsPerCm);
            }
        }
        return newScale;
    }

    int getUnitIndex(String unit) {
        if ((unit = unit.toLowerCase(Locale.US)).equals("cm") || unit.startsWith("cent")) {
            return 3;
        }
        if (unit.equals("mm") || unit.startsWith("milli")) {
            return 2;
        }
        if (unit.startsWith("inch")) {
            return 6;
        }
        if (unit.equals("\u00b5m") || unit.equals("um") || unit.startsWith("micro")) {
            return 1;
        }
        if (unit.equals("nm") || unit.startsWith("nano")) {
            return 0;
        }
        if (unit.startsWith("meter")) {
            return 4;
        }
        if (unit.equals("km") || unit.startsWith("kilo")) {
            return 5;
        }
        if (unit.equals("ft") || unit.equals("foot") || unit.equals("feet")) {
            return 7;
        }
        if (unit.equals("mi") || unit.startsWith("mile")) {
            return 2;
        }
        return 10;
    }

    double getUnitsPerCm(int unitIndex) {
        switch (unitIndex) {
            case 0: {
                return 1.0E7;
            }
            case 1: {
                return 10000.0;
            }
            case 2: {
                return 10.0;
            }
            case 3: {
                return 1.0;
            }
            case 4: {
                return 0.01;
            }
            case 5: {
                return 1.0E-5;
            }
            case 6: {
                return 0.3937;
            }
            case 7: {
                return 0.0328083;
            }
            case 8: {
                return 6.213E-6;
            }
        }
        return 0.0;
    }
}

