/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.io.SaveDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.io.FileOutputStream;

public class RoiWriter
implements PlugInFilter {
    static final int HEADER_SIZE = 64;
    static final int VERSION = 217;
    final int polygon = 0;
    final int rect = 1;
    final int oval = 2;
    final int line = 3;
    final int freeline = 4;
    final int polyline = 5;
    final int noRoi = 6;
    final int freehand = 7;
    final int traced = 8;
    final int angle = 9;
    ImagePlus imp;
    byte[] data;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 1183;
    }

    public void run(ImageProcessor ip) {
        try {
            this.saveRoi(this.imp);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.showMessage("ROI Writer", msg);
        }
    }

    public void saveRoi(ImagePlus imp) throws Exception {
        String name;
        int type;
        Roi roi = imp.getRoi();
        if (roi == null) {
            throw new IllegalArgumentException("ROI required");
        }
        int roiType = roi.getType();
        if (roiType == 2) {
            type = 0;
            name = "Polygon.roi";
        } else if (roiType == 3) {
            type = 7;
            name = "Freehand.roi";
        } else if (roiType == 4) {
            type = 8;
            name = "TracedRoi.roi";
        } else if (roiType == 1) {
            type = 2;
            name = "Oval.roi";
        } else if (roiType == 5) {
            type = 3;
            name = "Line.roi";
        } else if (roiType == 6) {
            type = 5;
            name = "PolyLine.roi";
        } else if (roiType == 7) {
            type = 4;
            name = "FreeLine.roi";
        } else if (roiType == 8) {
            type = 9;
            name = "Angle.roi";
        } else {
            type = 1;
            name = "Rectangle.roi";
        }
        SaveDialog sd = new SaveDialog("Save Selection...", name, ".roi");
        name = sd.getFileName();
        if (name == null) {
            return;
        }
        String dir = sd.getDirectory();
        FileOutputStream f = new FileOutputStream(dir + name);
        int n = 0;
        int[] x = null;
        int[] y = null;
        if (roi instanceof PolygonRoi) {
            PolygonRoi p = (PolygonRoi)roi;
            n = p.getNCoordinates();
            x = p.getXCoordinates();
            y = p.getYCoordinates();
        }
        this.data = new byte[64 + n * 4];
        Rectangle r = roi.getBoundingRect();
        this.data[0] = 73;
        this.data[1] = 111;
        this.data[2] = 117;
        this.data[3] = 116;
        this.putShort(4, 217);
        this.data[6] = (byte)type;
        this.putShort(8, r.y);
        this.putShort(10, r.x);
        this.putShort(12, r.y + r.height);
        this.putShort(14, r.x + r.width);
        this.putShort(16, n);
        if (roi instanceof Line) {
            Line l = (Line)roi;
            this.putFloat(18, l.x1);
            this.putFloat(22, l.y1);
            this.putFloat(26, l.x2);
            this.putFloat(30, l.y2);
        }
        if (n > 0) {
            int base1 = 64;
            int base2 = base1 + 2 * n;
            int i = 0;
            while (i < n) {
                this.putShort(base1 + i * 2, x[i]);
                this.putShort(base2 + i * 2, y[i]);
                ++i;
            }
        }
        f.write(this.data);
        f.close();
        if (name.endsWith(".roi")) {
            name = name.substring(0, name.length() - 4);
        }
        roi.setName(name);
    }

    void putShort(int base, int v) {
        this.data[base] = (byte)(v >>> 8);
        this.data[base + 1] = (byte)v;
    }

    void putFloat(int base, float v) {
        int tmp = Float.floatToIntBits(v);
        this.data[base] = (byte)(tmp >> 24);
        this.data[base + 1] = (byte)(tmp >> 16);
        this.data[base + 2] = (byte)(tmp >> 8);
        this.data[base + 3] = (byte)tmp;
    }
}

