/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class FloatStatistics
extends ImageStatistics {
    public FloatStatistics(ImageProcessor ip) {
        this(ip, 27, null);
    }

    public FloatStatistics(ImageProcessor ip, int mOptions, Calibration cal) {
        double maxThreshold;
        double minThreshold;
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.setup(ip, cal);
        double minT = ip.getMinThreshold();
        if ((mOptions & 0x100) == 0 || minT == -808080.0) {
            minThreshold = -3.4028234663852886E38;
            maxThreshold = 3.4028234663852886E38;
        } else {
            minThreshold = minT;
            maxThreshold = ip.getMaxThreshold();
        }
        this.getStatistics(ip, minThreshold, maxThreshold);
        if ((mOptions & 8) != 0) {
            this.getMode();
        }
        if ((mOptions & 0x800) != 0) {
            this.fitEllipse(ip);
        } else if ((mOptions & 0x20) != 0) {
            this.getCentroid(ip, minThreshold, maxThreshold);
        }
        if ((mOptions & 0x40) != 0) {
            this.getCenterOfMass(ip, minThreshold, maxThreshold);
        }
    }

    void getStatistics(ImageProcessor ip, double minThreshold, double maxThreshold) {
        double v;
        float[] pixels = (float[])ip.getPixels();
        this.nBins = ip.getHistogramSize();
        this.histMin = ip.getHistogramMin();
        this.histMax = ip.getHistogramMax();
        this.histogram = new int[this.nBins];
        double sum = 0.0;
        double sum2 = 0.0;
        int[] mask = ip.getMask();
        double roiMin = Double.MAX_VALUE;
        double roiMax = -1.7976931348623157E308;
        double roiMin2 = Double.MAX_VALUE;
        double roiMax2 = -1.7976931348623157E308;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            int x = this.rx;
            while (x < this.rx + this.rw) {
                if ((mask == null || mask[mi++] == -16777216) && (v = (double)pixels[i]) >= minThreshold && v <= maxThreshold) {
                    if (v < roiMin) {
                        roiMin = v;
                    }
                    if (v > roiMax) {
                        roiMax = v;
                    }
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
        this.min = roiMin;
        this.max = roiMax;
        if (this.histMin == 0.0 && this.histMax == 0.0) {
            this.histMin = this.min;
            this.histMax = this.max;
        } else {
            if (this.min < this.histMin) {
                this.min = this.histMin;
            }
            if (this.max > this.histMax) {
                this.max = this.histMax;
            }
        }
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        double scale = (double)this.nBins / (this.histMax - this.histMin);
        this.pixelCount = 0;
        int y2 = this.ry;
        int my2 = 0;
        while (y2 < this.ry + this.rh) {
            int i = y2 * this.width + this.rx;
            int mi = my2 * this.rw;
            int x = this.rx;
            while (x < this.rx + this.rw) {
                if ((mask == null || mask[mi++] == -16777216) && (v = (double)pixels[i]) >= minThreshold && v <= maxThreshold && v >= this.histMin && v <= this.histMax) {
                    ++this.pixelCount;
                    sum += v;
                    sum2 += v * v;
                    int index = (int)(scale * (v - this.histMin));
                    if (index >= this.nBins) {
                        index = this.nBins - 1;
                    }
                    int n = index;
                    this.histogram[n] = this.histogram[n] + 1;
                }
                ++i;
                ++x;
            }
            ++y2;
            ++my2;
        }
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.mean = sum / (double)this.pixelCount;
        this.calculateStdDev(this.pixelCount, sum, sum2);
    }

    void getMode() {
        this.maxCount = 0;
        int i = 0;
        while (i < this.nBins) {
            int count = this.histogram[i];
            if (count > this.maxCount) {
                this.maxCount = count;
                this.mode = i;
            }
            ++i;
        }
        this.dmode = this.histMin + (double)this.mode * this.binSize;
        if (this.binSize != 1.0) {
            this.dmode += this.binSize / 2.0;
        }
    }

    void getCenterOfMass(ImageProcessor ip, double minThreshold, double maxThreshold) {
        float[] pixels = (float[])ip.getPixels();
        int[] mask = ip.getMask();
        double count = 0.0;
        double xsum = 0.0;
        double ysum = 0.0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            int x = this.rx;
            while (x < this.rx + this.rw) {
                double v;
                if ((mask == null || mask[mi++] == -16777216) && (v = (double)pixels[i] + Double.MIN_VALUE) >= minThreshold && v <= maxThreshold) {
                    count += v;
                    xsum += (double)x * v;
                    ysum += (double)y * v;
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
        this.xCenterOfMass = (xsum / count + 0.5) * this.pw;
        this.yCenterOfMass = (ysum / count + 0.5) * this.ph;
    }

    void getCentroid(ImageProcessor ip, double minThreshold, double maxThreshold) {
        float[] pixels = (float[])ip.getPixels();
        int[] mask = ip.getMask();
        double count = 0.0;
        double xsum = 0.0;
        double ysum = 0.0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            int x = this.rx;
            while (x < this.rx + this.rw) {
                double v;
                if ((mask == null || mask[mi++] == -16777216) && (v = (double)pixels[i]) >= minThreshold && v <= maxThreshold) {
                    count += 1.0;
                    xsum += (double)x;
                    ysum += (double)y;
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
        this.xCentroid = (xsum / count + 0.5) * this.pw;
        this.yCentroid = (ysum / count + 0.5) * this.ph;
    }
}

