/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.neuro;

import java.io.OutputStream;
import java.sql.Connection;
import java.util.List;
import org.mitre.neuro.SpreadSheetCreator;
import org.mitre.neuro.containers.Interview;
import org.mitre.neuro.containers.Session;
import org.mitre.neuro.containers.Study;
import org.mitre.neuro.containers.Subject;
import org.mitre.neuro.database.StoreStudy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateUpload {
    Connection connection;
    Study study;
    public static int BLANKS = 100;

    public GenerateUpload(Connection connection, String project_name) {
        System.out.println("in GenerateUpload constructor");
        this.connection = connection;
        this.study = new Study();
        if (project_name != null) {
            this.study.setGrant_name(project_name);
            boolean loaded = false;
            try {
                loaded = StoreStudy.get_study(connection, this.study);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!loaded) {
                System.out.println("WARNING!!  Could not load study " + project_name);
            }
        }
    }

    public void setAttributes(List<String> entity_list) {
        Interview interview = new Interview();
        for (String key : entity_list) {
            interview.addValue(key, "");
        }
        int generate_rows = this.study.getSessions().size() > 0 ? 1 : BLANKS;
        Subject subject = new Subject();
        subject.addInterview(interview);
        for (int i = 0; i < generate_rows; ++i) {
            Session scan = new Session();
            scan.setSubject(subject);
            this.study.addSession(scan);
        }
    }

    public void generate(OutputStream out) {
        try {
            SpreadSheetCreator creator = new SpreadSheetCreator(SpreadSheetCreator.OutputType.BIFF);
            creator.setStudy(this.study);
            creator.generate(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

