/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.neuro;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mitre.neuro.containers.Interview;
import org.mitre.neuro.containers.Session;
import org.mitre.neuro.containers.Study;
import org.mitre.neuro.containers.Subject;
import org.mitre.neuro.excel.Datum;
import org.mitre.neuro.excel.ExcelReader;
import org.mitre.neuro.excel.Worksheet;
import org.mitre.neuro.excel.biff.BIFFReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadSheetReader {
    ExcelReader reader = new BIFFReader();
    File baseDir = null;

    public SpreadSheetReader(InputType type) {
    }

    public Study read(InputStream stream, String baseDir) throws Exception {
        this.baseDir = new File(baseDir);
        HashMap<String, Worksheet> sheets = this.reader.readSheets(stream);
        System.out.println("Extracting from Study");
        Study study = this.extractStudy(sheets.get("Study"));
        System.out.println("Extracting from Subjects");
        Map<String, Subject> subjects = this.extractSubjects(sheets.get("Subjects"));
        System.out.println("Extracting from Sessions");
        this.extractSessions(study, sheets.get("Sessions"), subjects);
        System.out.println("Extracting from Scans");
        this.extractImages(study, sheets.get("Scans"), subjects);
        System.out.println("Extracting from Interviews");
        this.extractInterviews(sheets.get("Interviews"), subjects);
        System.out.println(study.toString());
        return study;
    }

    protected void extractInterviews(Worksheet sheet, Map<String, Subject> subjects) throws Exception {
        if (sheet == null) {
            System.err.println("Interview sheet not found");
            return;
        }
        List<HashMap<String, Datum>> tuples = sheet.extractHorizontalTuples(2);
        for (HashMap<String, Datum> tuple : tuples) {
            String subject_id = this.extractString(tuple, "Subject ID");
            String interview_date = this.extractString(tuple, "Interview Date");
            tuple.remove("Subject ID");
            tuple.remove("Interview Date");
            tuple.remove("Session ID");
            Interview interview = new Interview();
            Subject subject = subjects.get(subject_id);
            interview.setInterview_date(interview_date);
            if (subject == null) {
                throw new Exception("Subject " + subject_id + " not defined.");
            }
            for (String key : tuple.keySet()) {
                String value = this.extractString(tuple, key);
                if (value == null) continue;
                interview.addValue(key, value);
            }
            subject.addInterview(interview);
        }
    }

    protected void extractSessions(Study study, Worksheet sheet, Map<String, Subject> subjects) {
        if (sheet == null) {
            System.err.println("Sessions sheet not found");
            return;
        }
        ArrayList<Session> sessions = new ArrayList<Session>();
        List<HashMap<String, Datum>> tuples = sheet.extractHorizontalTuples(2);
        for (HashMap<String, Datum> tuple : tuples) {
            String subject = this.extractString(tuple, "Subject ID");
            String session_id = this.extractString(tuple, "Session ID");
            String dte = this.extractString(tuple, "Date");
            String scanner = this.extractString(tuple, "Scanner");
            String location = this.extractString(tuple, "Location");
            String software_v = this.extractString(tuple, "Software Version");
            Session session = new Session();
            session.setSubject(subjects.get(subject));
            session.setSession_id(session_id);
            session.setDate_taken(dte);
            int existingSession = sessions.indexOf(session);
            if (existingSession == -1) {
                sessions.add(session);
            } else {
                session = (Session)sessions.get(existingSession);
            }
            session.setScanner(scanner);
            session.setLocation(location);
            session.setSoftware_version(software_v);
        }
        study.setSessions(sessions);
    }

    protected void extractImages(Study study, Worksheet sheet, Map<String, Subject> subjects) {
        if (sheet == null) {
            System.err.println("Scans sheet not found");
            return;
        }
        List<Session> sessions = study.getSessions();
        List<HashMap<String, Datum>> tuples = sheet.extractHorizontalTuples(2);
        for (HashMap<String, Datum> tuple : tuples) {
            String subject = this.extractString(tuple, "Subject ID");
            String session_id = this.extractString(tuple, "Session ID");
            String dte = this.extractString(tuple, "Date");
            Session session = new Session();
            session.setSubject(subjects.get(subject));
            session.setSession_id(session_id);
            session.setDate_taken(dte);
            int existingSession = sessions.indexOf(session);
            if (existingSession == -1) {
                throw new RuntimeException("A Session to match the scan for " + session.getSubject().getSubject_id() + " on date " + session.getDate_taken() + " with a session id of " + session.getSession_id() + " could not be found.  This is an error in the spreadsheet.  Please fix it and try again.");
            }
            session = sessions.get(existingSession);
            String filename = ((Datum)tuple.get("Filename")).getString_dat();
            File uploadedFile = null;
            if (filename == null) {
                throw new RuntimeException("You must specify a file name for subject " + subject + " on the Scans sheet.");
            }
            uploadedFile = new File(this.baseDir, filename);
            String protocol_name = this.extractString(tuple, "Protocol Name");
            String modality = this.extractString(tuple, "Modality");
            double t1 = this.extractInteger(tuple, "T1");
            double t2 = this.extractInteger(tuple, "T2");
            double tr = this.extractInteger(tuple, "TR");
            double ti = this.extractInteger(tuple, "TI");
            double te = this.extractInteger(tuple, "TE");
            String num_format = this.extractString(tuple, "Numercial Format");
            double excitations = this.extractInteger(tuple, "Excitations");
            double flip_angle = this.extractInteger(tuple, "Flip Angle");
            Session.Image image = session.addImage();
            image.filename = filename;
            image.subject_oid = session.getSubject().getObject_id();
            image.missing = !uploadedFile.exists();
            image.t1 = t1;
            image.t2 = t2;
            image.tr = tr;
            image.ti = ti;
            image.te = te;
            image.num_format = num_format;
            image.flip_angle = flip_angle;
            image.excitations = excitations;
            image.modality = modality;
            image.protocol_name = protocol_name;
        }
    }

    protected Map<String, Subject> extractSubjects(Worksheet sheet) {
        if (sheet == null) {
            System.err.println("Subject worksheet not found!");
            return null;
        }
        HashMap<String, Subject> subjects = new HashMap<String, Subject>();
        List<HashMap<String, Datum>> tuples = sheet.extractHorizontalTuples(2);
        for (HashMap<String, Datum> tuple : tuples) {
            Subject subject = new Subject();
            subject.setSubject_id(this.extractString(tuple, "Subject ID"));
            subject.setBirth(this.extractDate(tuple, "Birthdate"));
            subject.setGender(this.extractString(tuple, "Gender"));
            subject.setRace(this.extractString(tuple, "Race"));
            subject.setEducation(this.extractInteger(tuple, "Education"));
            subject.setHandedness(this.extractString(tuple, "Handedness"));
            subject.setHeight(this.extractInteger(tuple, "Height"));
            subject.setWeight(this.extractInteger(tuple, "Weight"));
            subjects.put(subject.getSubject_id(), subject);
        }
        return subjects;
    }

    protected Study extractStudy(Worksheet sheet) {
        if (sheet == null) {
            System.err.println("Study worksheet not found!");
            return null;
        }
        Study study = new Study();
        List<HashMap<String, Datum>> tuples = sheet.extractVerticalTuples(0, 2);
        if (tuples.size() != 1) {
            System.err.println("Study information not found!");
            return null;
        }
        Map tuple = tuples.get(0);
        study.setInvestigator(((Datum)tuple.get("PI Name")).getString_dat());
        study.setPi_email(((Datum)tuple.get("PI Email Address")).getString_dat());
        study.setFunding_info(((Datum)tuple.get("Funding Information")).getString_dat());
        study.setGrant_name(((Datum)tuple.get("Grant name")).getString_dat());
        return study;
    }

    protected int extractInteger(Map<String, Datum> tuple, String field) {
        String str = tuple.containsKey(field) ? tuple.get(field).getString_dat() : null;
        int num = str == null ? Integer.MIN_VALUE : Integer.parseInt(str);
        return num;
    }

    protected String extractString(Map<String, Datum> tuple, String field) {
        String str = tuple.containsKey(field) ? tuple.get(field).getString_dat() : null;
        return str;
    }

    protected Date extractDate(Map<String, Datum> tuple, String field) {
        String str = this.extractString(tuple, field);
        try {
            return str == null ? null : new Date(str);
        }
        catch (Exception e) {
            return this.extractYear(str);
        }
    }

    protected Date extractYear(String text) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        try {
            return format.parse(text);
        }
        catch (Exception e) {
            System.out.println("Failed extracting year: " + text);
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            FileInputStream in = new FileInputStream(args[0]);
            SpreadSheetReader reader = new SpreadSheetReader(InputType.BIFF);
            reader.read(in, args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InputType {
        BIFF;

    }
}

