/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.neuro.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.mitre.neuro.containers.Session;
import org.mitre.neuro.containers.Study;
import org.mitre.neuro.database.StoreSession;

public class StoreStudy {
    Connection connection;

    public StoreStudy(Connection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean get_study(Connection connection, Study study) throws Exception {
        String sql = "SELECT PROJECT_ID, PI_NAME, PI_EMAIL, funding_info from PROJECT where GRANT_NAME=?";
        PreparedStatement statement = connection.prepareStatement(sql);
        try {
            statement.setString(1, study.getGrant_name());
            statement.execute();
            ResultSet result = statement.getResultSet();
            if (result.next()) {
                study.setStudy_id(result.getInt(1));
                study.setPi_email(result.getString("PI_EMAIL"));
                study.setInvestigator(result.getString("PI_NAME"));
                study.setFunding_info(result.getString("funding_info"));
                boolean bl = true;
                return bl;
            }
        }
        finally {
            statement.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert_study(Study study) throws Exception {
        String sql = "INSERT INTO PROJECT (grant_name, pi_name, pi_email, funding_info) VALUES (?, ?, ?, ?);";
        PreparedStatement statement = this.connection.prepareStatement(sql);
        try {
            statement.setString(1, study.getGrant_name());
            statement.setString(2, study.getInvestigator());
            statement.setString(3, study.getPi_email());
            statement.setString(4, study.getFunding_info());
            statement.execute();
        }
        finally {
            statement.close();
        }
        sql = "SELECT currval(pg_get_serial_sequence('project', 'project_id'));";
        statement = this.connection.prepareStatement(sql);
        try {
            ResultSet generated_keys = statement.executeQuery();
            if (generated_keys.next()) {
                study.setStudy_id(generated_keys.getInt(1));
                System.out.println("Study " + study.getStudy_id() + " added...");
            }
        }
        finally {
            statement.close();
        }
    }

    public void store(Study study) throws Exception {
        if (!StoreStudy.get_study(this.connection, study)) {
            System.out.println("Storing Study...");
            this.insert_study(study);
        }
        StoreSession scans = new StoreSession(study, this.connection);
        for (Session scan : study.getSessions()) {
            scans.store_scan(scan);
        }
    }
}

