/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.neuro.excel.biff;

import java.io.InputStream;
import java.util.HashMap;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import org.mitre.neuro.excel.Datum;
import org.mitre.neuro.excel.ExcelReader;
import org.mitre.neuro.excel.Row;
import org.mitre.neuro.excel.Worksheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BIFFReader
extends ExcelReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, Worksheet> readSheets(InputStream input) throws Exception {
        HashMap<String, Worksheet> sheets = new HashMap<String, Worksheet>();
        Workbook book = null;
        try {
            WorkbookSettings settings = new WorkbookSettings();
            settings.setSuppressWarnings(true);
            book = Workbook.getWorkbook((InputStream)input, (WorkbookSettings)settings);
            for (int i = 0; i < book.getNumberOfSheets(); ++i) {
                Sheet sheet = book.getSheet(i);
                Worksheet worksheet = new Worksheet(sheet.getName(), i);
                for (int j = 0; j < sheet.getRows(); ++j) {
                    worksheet.addRow(this.readRow(sheet, j));
                }
                sheets.put(worksheet.getName(), worksheet);
            }
        }
        finally {
            if (book != null) {
                book.close();
            }
        }
        return sheets;
    }

    protected Row readRow(Sheet sheet, int row_index) {
        Cell[] cells;
        Row row = new Row(row_index);
        for (Cell cell : cells = sheet.getRow(row_index)) {
            row.addColumn(cell.getColumn(), this.readCell(cell));
        }
        return row;
    }

    protected Datum readCell(Cell cell) {
        Datum cell_data = null;
        if ("".equals(cell.getContents())) {
            return Datum.empty();
        }
        cell_data = Datum.string(cell.getContents());
        return cell_data;
    }
}

