/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.neuro.excel.html;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import org.mitre.neuro.excel.Datum;
import org.mitre.neuro.excel.ExcelGenerator;
import org.mitre.neuro.excel.Row;
import org.mitre.neuro.excel.Worksheet;

public class GenerateHTML
extends ExcelGenerator {
    public void getSpreadSheet(OutputStream stream) throws Exception {
        PrintWriter writer = new PrintWriter(stream);
        Object[] sheet_numbers = new Integer[this.worksheets.keySet().size()];
        this.worksheets.keySet().toArray(sheet_numbers);
        Arrays.sort(sheet_numbers);
        for (Object number : sheet_numbers) {
            Worksheet sheet = (Worksheet)this.worksheets.get(number);
            writer.println("<h2>" + sheet.getName() + "</h2>");
            this.printSheet(writer, sheet);
        }
        writer.flush();
    }

    protected void printSheet(PrintWriter printer, Worksheet sheet) {
        printer.println("<table>");
        for (int i = 0; i < sheet.getSize(); ++i) {
            Row row = sheet.getOrAddRow(i);
            this.printRow(printer, row);
        }
        printer.println("</table>");
    }

    protected void printRow(PrintWriter printer, Row row) {
        printer.println("\t<tr>");
        Object[] columns = new Integer[row.getColumns().size()];
        row.getColumns().toArray(columns);
        Arrays.sort(columns);
        int next = 0;
        for (Object index : columns) {
            if ((Integer)index != next) {
                while (next < (Integer)index) {
                    printer.println("\t\t<td></td>");
                    ++next;
                }
            }
            ++next;
            Datum d = row.getColumn((Integer)index);
            this.printCell(printer, d);
        }
        printer.println("\t</tr>");
    }

    protected void printCell(PrintWriter printer, Datum d) {
        printer.println("\t\t<td>");
        printer.print("\t\t\t");
        this.print_data(printer, d);
        printer.println("\t\t</td>");
    }

    protected void print_data(PrintWriter printer, Datum d) {
        if (d.getT() == Datum.Type.STRING) {
            printer.println(d.getString_dat());
        }
        if (d.getT() == Datum.Type.EMPTY) {
            printer.println();
        }
        if (d.getT() == Datum.Type.NUMBER) {
            printer.println(d.getNumber_dat());
        }
        if (d.getT() == Datum.Type.FORMULA) {
            printer.println("Formula: " + d.getFormula());
        }
    }
}

