/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf.storage;

import de.laures.cewolf.storage.SessionStorageItem;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SessionStorageGroup
implements Runnable {
    private Map map = new HashMap();
    Thread runner;

    private void start() {
        if (this.runner == null || !this.runner.isAlive()) {
            this.runner = new Thread(this);
            this.runner.setDaemon(false);
            this.runner.setName("SessionCleanup");
            this.runner.setPriority(1);
            this.runner.start();
        }
    }

    public synchronized Object get(Object a) {
        return this.map.get(a);
    }

    public synchronized Object put(Object a, Object b) {
        Object c = this.map.put(a, b);
        this.start();
        return c;
    }

    public synchronized Object remove(Object a) {
        return this.map.remove(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.map.isEmpty()) {
            Date date = new Date();
            SessionStorageGroup sessionStorageGroup = this;
            synchronized (sessionStorageGroup) {
                Set keys = this.map.keySet();
                Iterator iter = keys.iterator();
                while (iter.hasNext()) {
                    String cid = (String)iter.next();
                    SessionStorageItem ssi = (SessionStorageItem)this.get(cid);
                    if (!ssi.isExpired(date)) continue;
                    iter.remove();
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        int start = 0;
        while (true) {
            System.out.println("Adding Objects");
            SessionStorageGroup.testThread(start);
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void testThread(int start) {
        SessionStorageGroup ssg = new SessionStorageGroup();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        for (int i = start; i < start + 10000; ++i) {
            ((Calendar)cal).add(14, 1);
            SessionStorageItem ssi = new SessionStorageItem(null, Integer.toString(i), cal.getTime());
            ssg.put(Integer.toString(i), ssi);
        }
    }

    public static void testSoftreferenceMemoryFreeup() {
        int i;
        Date neverexpire = new Date(10000, 1, 1);
        SessionStorageGroup ssg = new SessionStorageGroup();
        StringBuffer longString = new StringBuffer();
        for (i = 0; i < 10000; ++i) {
            longString.append(Math.random());
        }
        i = 0;
        long minmem = Long.MAX_VALUE;
        while (true) {
            String key = Long.toString(System.currentTimeMillis());
            String id = key + longString;
            SessionStorageItem ssi = new SessionStorageItem(null, id, neverexpire);
            ssg.put(key, ssi);
            ++i;
            long freemem = Runtime.getRuntime().freeMemory();
            long usedmem = Runtime.getRuntime().totalMemory();
            long maxmem = Runtime.getRuntime().maxMemory();
            if (freemem < minmem) {
                minmem = freemem;
            }
            if (i % 100 != 0) continue;
            System.out.println("#" + i + ", minimum memory:" + minmem + ", freemem:" + freemem + ", usedmem:" + usedmem + ", maxmem:" + maxmem);
        }
    }
}

