/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.dynamic;

import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.DynamicMock;
import com.mockobjects.dynamic.DynamicMockError;
import com.mockobjects.dynamic.Invocation;
import com.mockobjects.dynamic.InvocationDispatcher;
import com.mockobjects.dynamic.InvocationMocker;
import com.mockobjects.dynamic.Invokable;
import com.mockobjects.dynamic.ReturnStub;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import junit.framework.AssertionFailedError;

public class CoreMock
implements DynamicMock {
    private InvocationDispatcher invocationDispatcher;
    private Object proxy;
    private String name;

    public CoreMock(Class mockedClass, String name, InvocationDispatcher invocationDispatcher) {
        this.proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{mockedClass}, (InvocationHandler)this);
        this.name = name;
        this.invocationDispatcher = invocationDispatcher;
        this.add(new InvocationMocker("toString", C.args(), new ReturnStub(name)));
    }

    public Object proxy() {
        return this.proxy;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Invocation invocation = new Invocation(method, args);
        try {
            if (invocation.isCheckingEqualityOnProxy()) {
                return new Boolean(args[0] == this.proxy);
            }
            if (invocation.isMockNameGetter()) {
                return this.getMockName();
            }
            return this.invocationDispatcher.dispatch(invocation);
        }
        catch (DynamicMockError error) {
            DynamicMockError newError = new DynamicMockError(invocation, this.invocationDispatcher, this.name);
            newError.fillInStackTrace();
            throw newError;
        }
        catch (AssertionFailedError ex) {
            DynamicMockError error = new DynamicMockError(invocation, this.invocationDispatcher, ex.getMessage());
            error.fillInStackTrace();
            throw error;
        }
    }

    public void verify() {
        try {
            this.invocationDispatcher.verify();
        }
        catch (AssertionFailedError ex) {
            throw new AssertionFailedError(this.name + ": " + ex.getMessage());
        }
    }

    public String toString() {
        return this.name;
    }

    public String getMockName() {
        return this.name;
    }

    public void add(Invokable invokable) {
        this.invocationDispatcher.add(invokable);
    }

    public void reset() {
        this.invocationDispatcher.clear();
    }

    public static String mockNameFromClass(Class c) {
        return "mock" + CoreMock.className(c);
    }

    public static String className(Class c) {
        String name = c.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }
}

