/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.dynamic;

import com.mockobjects.dynamic.DynamicUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Invocation {
    private Class declaringClass;
    private String name;
    private List parameterTypes;
    private Class returnType;
    private List parameterValues;

    public Invocation(Class declaringClass, String name, Class[] parameterTypes, Class returnType, Object[] parameterValues) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.parameterTypes = Arrays.asList(parameterTypes);
        this.returnType = returnType;
        this.parameterValues = parameterValues == null ? new ArrayList(0) : Arrays.asList(parameterValues);
    }

    public Invocation(Method method, Object[] parameterValues) {
        this(method.getDeclaringClass(), method.getName(), method.getParameterTypes(), method.getReturnType(), parameterValues);
    }

    public String getMethodName() {
        return this.name;
    }

    public List getParameterTypes() {
        return Collections.unmodifiableList(this.parameterTypes);
    }

    public List getParameterValues() {
        return Collections.unmodifiableList(this.parameterValues);
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public String toString() {
        return DynamicUtil.methodToString(this.name, this.parameterValues.toArray());
    }

    public boolean equals(Object other) {
        return other instanceof Invocation && this.equals((Invocation)other);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.listHashCode(this.parameterTypes) ^ this.returnType.hashCode() ^ this.listHashCode(this.parameterValues);
    }

    private int listHashCode(List array) {
        int hashCode = 0;
        Iterator i = array.iterator();
        while (i.hasNext()) {
            hashCode ^= i.next().hashCode();
        }
        return hashCode;
    }

    public boolean equals(Invocation call) {
        return call != null && this.name.equals(call.name) && ((Object)this.parameterTypes).equals(call.parameterTypes) && this.returnType.equals(call.returnType) && ((Object)this.parameterValues).equals(call.parameterValues);
    }

    boolean isCheckingEqualityOnProxy() {
        return this.name.equals("equals") && this.parameterValues.size() == 1 && this.parameterValues.get(0) != null && Proxy.isProxyClass(this.parameterValues.get(0).getClass());
    }

    boolean isMockNameGetter() {
        return this.name.equals("getMockName") && this.parameterValues.size() == 0;
    }

    public StringBuffer writeTo(StringBuffer buffer) {
        buffer.append("Invocation: ");
        this.writeDeclaringClassName(buffer).append(".").append(this.name).append("(");
        DynamicUtil.join(this.parameterValues.toArray(), buffer);
        buffer.append(")\n");
        return buffer;
    }

    private StringBuffer writeDeclaringClassName(StringBuffer buffer) {
        return buffer.append(this.declaringClass.getName().substring(this.declaringClass.getPackage().getName().length()));
    }
}

