/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.dynamic;

import com.mockobjects.dynamic.Invocation;
import com.mockobjects.dynamic.InvocationMatcher;
import com.mockobjects.dynamic.Invokable;
import com.mockobjects.dynamic.Stub;
import com.mockobjects.dynamic.matchers.MethodNameMatcher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.AssertionFailedError;

public class InvocationMocker
implements Invokable {
    private List matchers = new ArrayList();
    private Stub stub;

    public InvocationMocker(String methodName, InvocationMatcher arguments, Stub stub) {
        this(stub);
        this.addMatcher(new MethodNameMatcher(methodName));
        this.addMatcher(arguments);
    }

    public InvocationMocker(InvocationMatcher[] matchers, Stub stub) {
        this(stub);
        for (int i = 0; i < matchers.length; ++i) {
            this.addMatcher(matchers[i]);
        }
    }

    public InvocationMocker(Stub stub) {
        this.stub = stub;
    }

    public String getDescription() {
        return null;
    }

    public boolean matches(Invocation invocation) {
        Iterator i = this.matchers.iterator();
        while (i.hasNext()) {
            if (((InvocationMatcher)i.next()).matches(invocation)) continue;
            return false;
        }
        return true;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Iterator i = this.matchers.iterator();
        while (i.hasNext()) {
            ((InvocationMatcher)i.next()).invoked(invocation);
        }
        return this.stub.invoke(invocation);
    }

    public void verify() {
        try {
            Iterator i = this.matchers.iterator();
            while (i.hasNext()) {
                ((InvocationMatcher)i.next()).verify();
            }
        }
        catch (AssertionFailedError error) {
            AssertionFailedError newError = new AssertionFailedError(error.getMessage() + " " + this.toString());
            newError.fillInStackTrace();
            throw newError;
        }
    }

    public InvocationMocker addMatcher(InvocationMatcher matcher) {
        this.matchers.add(matcher);
        return this;
    }

    public void setStub(Stub stub) {
        this.stub = stub;
    }

    public StringBuffer writeTo(StringBuffer buffer) {
        buffer.append("(");
        Iterator it = this.matchers.iterator();
        while (it.hasNext()) {
            ((InvocationMatcher)it.next()).writeTo(buffer).append(", ");
        }
        this.stub.writeTo(buffer);
        return buffer.append("\n");
    }

    public String toString() {
        return this.writeTo(new StringBuffer()).toString();
    }
}

