/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.dynamic;

import com.mockobjects.Verifiable;
import com.mockobjects.constraint.Constraint;
import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.CoreMock;
import com.mockobjects.dynamic.DynamicMock;
import com.mockobjects.dynamic.InvocationDispatcher;
import com.mockobjects.dynamic.InvocationMatcher;
import com.mockobjects.dynamic.InvokableFactory;
import com.mockobjects.dynamic.LIFOInvocationDispatcher;
import com.mockobjects.dynamic.matchers.ArgumentsMatcher;

public class Mock
implements Verifiable {
    private InvokableFactory invokableFactory;
    private DynamicMock coreMock;

    public Mock(InvokableFactory invokableFactory, InvocationDispatcher invocationDispatcher, Class mockedClass, String name) {
        this.coreMock = new CoreMock(mockedClass, name, invocationDispatcher);
        this.invokableFactory = invokableFactory;
    }

    public Mock(Class mockedClass, String nonDefaultName) {
        this(new InvokableFactory(), new LIFOInvocationDispatcher(), mockedClass, nonDefaultName);
    }

    public Mock(Class mockedClass) {
        this(mockedClass, CoreMock.mockNameFromClass(mockedClass));
    }

    public String toString() {
        return this.coreMock.toString();
    }

    private InvocationMatcher createConstraintMatcher(Object constraintArg) {
        if (constraintArg instanceof Constraint[]) {
            return new ArgumentsMatcher((Constraint[])constraintArg);
        }
        if (constraintArg instanceof Constraint) {
            return C.args((Constraint)constraintArg);
        }
        return C.args(C.eq(constraintArg));
    }

    public void expect(String methodName, InvocationMatcher args) {
        this.coreMock.add(this.invokableFactory.createVoidExpectation(methodName, args));
    }

    public void expectAndReturn(String methodName, InvocationMatcher args, Object result) {
        this.coreMock.add(this.invokableFactory.createReturnExpectation(methodName, args, result));
    }

    public void expectAndThrow(String methodName, InvocationMatcher args, Throwable throwable) {
        this.coreMock.add(this.invokableFactory.createThrowableExpectation(methodName, args, throwable));
    }

    public void match(String methodName, InvocationMatcher args) {
        this.coreMock.add(this.invokableFactory.createVoidStub(methodName, args));
    }

    public void matchAndReturn(String methodName, InvocationMatcher args, Object result) {
        this.coreMock.add(this.invokableFactory.createReturnStub(methodName, args, result));
    }

    public void matchAndThrow(String methodName, InvocationMatcher args, Throwable throwable) {
        this.coreMock.add(this.invokableFactory.createThrowableStub(methodName, args, throwable));
    }

    public void expect(String methodName) {
        this.expect(methodName, C.NO_ARGS);
    }

    public void expect(String methodName, Object singleEqualArg) {
        this.expect(methodName, this.createConstraintMatcher(singleEqualArg));
    }

    public void expectAndReturn(String methodName, Object result) {
        this.expectAndReturn(methodName, C.NO_ARGS, result);
    }

    public void expectAndReturn(String methodName, boolean result) {
        this.expectAndReturn(methodName, new Boolean(result));
    }

    public void expectAndReturn(String methodName, int result) {
        this.expectAndReturn(methodName, new Integer(result));
    }

    public void expectAndReturn(String methodName, Object singleEqualArg, Object result) {
        this.expectAndReturn(methodName, this.createConstraintMatcher(singleEqualArg), result);
    }

    public void expectAndReturn(String methodName, Object singleEqualArg, boolean result) {
        this.expectAndReturn(methodName, singleEqualArg, (Object)new Boolean(result));
    }

    public void expectAndReturn(String methodName, Object singleEqualArg, int result) {
        this.expectAndReturn(methodName, singleEqualArg, (Object)new Integer(result));
    }

    public void expectAndReturn(String methodName, InvocationMatcher args, boolean result) {
        this.expectAndReturn(methodName, args, (Object)new Boolean(result));
    }

    public void expectAndReturn(String methodName, InvocationMatcher args, int result) {
        this.expectAndReturn(methodName, args, (Object)new Integer(result));
    }

    public void expectAndThrow(String methodName, Throwable exception) {
        this.expectAndThrow(methodName, C.NO_ARGS, exception);
    }

    public void expectAndThrow(String methodName, Object singleEqualArg, Throwable exception) {
        this.expectAndThrow(methodName, this.createConstraintMatcher(singleEqualArg), exception);
    }

    public void match(String methodName) {
        this.match(methodName, C.NO_ARGS);
    }

    public void match(String methodName, Object singleEqualArg) {
        this.match(methodName, this.createConstraintMatcher(singleEqualArg));
    }

    public void match(String methodName, int singleEqualArg) {
        this.match(methodName, new Integer(singleEqualArg));
    }

    public void match(String methodName, boolean singleEqualArg) {
        this.match(methodName, new Boolean(singleEqualArg));
    }

    public void matchAndReturn(String methodName, Object result) {
        this.matchAndReturn(methodName, C.NO_ARGS, result);
    }

    public void matchAndReturn(String methodName, boolean result) {
        this.matchAndReturn(methodName, new Boolean(result));
    }

    public void matchAndReturn(String methodName, int result) {
        this.matchAndReturn(methodName, new Integer(result));
    }

    public void matchAndReturn(String methodName, Object singleEqualArg, Object result) {
        this.matchAndReturn(methodName, this.createConstraintMatcher(singleEqualArg), result);
    }

    public void matchAndReturn(String methodName, boolean singleEqualArg, Object result) {
        this.matchAndReturn(methodName, (Object)new Boolean(singleEqualArg), result);
    }

    public void matchAndReturn(String methodName, int singleEqualArg, Object result) {
        this.matchAndReturn(methodName, (Object)new Integer(singleEqualArg), result);
    }

    public void matchAndReturn(String methodName, Object singleEqualArg, boolean result) {
        this.matchAndReturn(methodName, singleEqualArg, (Object)new Boolean(result));
    }

    public void matchAndReturn(String methodName, Object singleEqualArg, int result) {
        this.matchAndReturn(methodName, singleEqualArg, (Object)new Integer(result));
    }

    public void matchAndReturn(String methodName, InvocationMatcher args, boolean result) {
        this.matchAndReturn(methodName, args, (Object)new Boolean(result));
    }

    public void matchAndReturn(String methodName, InvocationMatcher args, int result) {
        this.matchAndReturn(methodName, args, (Object)new Integer(result));
    }

    public void matchAndThrow(String methodName, Throwable throwable) {
        this.matchAndThrow(methodName, C.NO_ARGS, throwable);
    }

    public void matchAndThrow(String methodName, Object singleEqualArg, Throwable throwable) {
        this.matchAndThrow(methodName, this.createConstraintMatcher(singleEqualArg), throwable);
    }

    public void matchAndThrow(String methodName, boolean singleEqualArg, Throwable throwable) {
        this.matchAndThrow(methodName, new Boolean(singleEqualArg), throwable);
    }

    public void matchAndThrow(String methodName, int singleEqualArg, Throwable throwable) {
        this.matchAndThrow(methodName, new Integer(singleEqualArg), throwable);
    }

    public void expectVoid(String methodName, InvocationMatcher args) {
        this.expect(methodName, args);
    }

    public void expectVoid(String methodName, Object equalArg) {
        this.expect(methodName, equalArg);
    }

    public void expectVoid(String methodName) {
        this.expect(methodName);
    }

    public void expectNotCalled(String methodName) {
    }

    public Object proxy() {
        return this.coreMock.proxy();
    }

    public void reset() {
        this.coreMock.reset();
    }

    public void verify() {
        this.coreMock.verify();
    }
}

