/*
 * Decompiled with CFR 0.152.
 */
package functional.test.mockobjects.dynamic;

import com.mockobjects.dynamic.Mock;
import functional.test.mockobjects.dynamic.MockTestActions;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public abstract class MockTest
extends TestCase {
    private MockTestActions actions;
    static /* synthetic */ Class class$functional$test$mockobjects$dynamic$MockTestActions;

    public abstract MockTestActions createActions();

    public void setUp() {
        this.actions = this.createActions();
    }

    public void testHasDefaultNameBasedOnMockedType() {
        Mock mock = new Mock(class$functional$test$mockobjects$dynamic$MockTestActions == null ? (class$functional$test$mockobjects$dynamic$MockTestActions = MockTest.class$("functional.test.mockobjects.dynamic.MockTestActions")) : class$functional$test$mockobjects$dynamic$MockTestActions);
        MockTest.assertEquals((String)"Should have same name", (String)"mockMockTestActions", (String)mock.toString());
    }

    public void testCanBeExplicitlyNamed() {
        Mock otherMock = new Mock(class$functional$test$mockobjects$dynamic$MockTestActions == null ? (class$functional$test$mockobjects$dynamic$MockTestActions = MockTest.class$("functional.test.mockobjects.dynamic.MockTestActions")) : class$functional$test$mockobjects$dynamic$MockTestActions, "otherMock");
        MockTest.assertEquals((String)"Should have same name", (String)"otherMock", (String)otherMock.toString());
    }

    public void testPassesIfMockedMethodCalled() {
        this.actions.expectNoParams();
        this.actions.callNoParams();
        this.actions.verifyMock();
    }

    public void testFailsIfMockedMethodCalledTwice() {
        this.actions.expectNoParams();
        this.actions.callNoParams();
        try {
            this.actions.callNoParams();
            MockTest.fail((String)"Should have throw exception");
        }
        catch (AssertionFailedError expected) {
            return;
        }
    }

    public void testFailsIfMockedMethodNotCalled() {
        this.actions.expectNoParams();
        try {
            this.actions.verifyMock();
        }
        catch (AssertionFailedError unused) {
            return;
        }
        MockTest.fail((String)"Should have thrown exception");
    }

    public void testFailsImmediatelyIfUnexpectedMethodCalled() {
        this.actions.expectNotNoParams();
        try {
            this.actions.callNoParams();
        }
        catch (AssertionFailedError unused) {
            return;
        }
        MockTest.fail((String)"Should have thrown exception");
    }

    public void testPassesIfMockedMethodCalledWithParameters() {
        this.actions.expectTwoParams();
        this.actions.callTwoParams();
        this.actions.verifyMock();
    }

    public void testInvocationFailsIfParameterValueIncorrect() {
        this.actions.expectTwoParams();
        try {
            this.actions.callIncorrectSecondParameter();
        }
        catch (AssertionFailedError unused) {
            return;
        }
        MockTest.fail((String)"Should have thrown exception");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

