/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.neuro;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.mitre.Unpack;
import org.mitre.neuro.ImageLoading;
import org.mitre.neuro.SpreadSheetReader;
import org.mitre.neuro.containers.Session;
import org.mitre.neuro.containers.Study;
import org.mitre.neuro.database.StoreStudy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Upload {
    Connection connection;
    String study_name;
    public static final String TMP_DIRECTORY = "/home/neuroweb/tmp/staging";

    public Upload(Connection connection, String study_name) {
        this.connection = connection;
        this.study_name = study_name;
    }

    public void beginTransaction() throws Exception {
        this.connection.setAutoCommit(false);
    }

    public void endTransaction() throws Exception {
        this.connection.commit();
    }

    public void rollbackTransaction() throws Exception {
        this.connection.rollback();
    }

    public List<Session> validate(File target) throws Exception {
        this.beginTransaction();
        List<Session> scans = this.merge(target);
        this.rollbackTransaction();
        return scans;
    }

    public List<Session> merge(File target) throws Exception {
        List<Session> scans = null;
        scans = target.isFile() ? this.load_file(target) : this.load_directory(target.listFiles());
        return scans;
    }

    public List<Session> load_archive(File archive) throws Exception {
        if (archive.getName().contains(".tar.")) {
            File tarball = null;
            if (archive.getName().endsWith(".gz")) {
                tarball = Unpack.gunzip(archive, "/home/neuroweb/tmp/staging/" + archive.getParent());
            } else if (archive.getName().endsWith("bz2")) {
                tarball = Unpack.bunzip2(archive, "/home/neuroweb/tmp/staging/" + archive.getParent());
            } else {
                throw new Exception("Unsupported archive type: " + archive.getName());
            }
            File directory = Unpack.unTar(tarball);
            return this.load_directory(directory.listFiles());
        }
        if (archive.getName().endsWith(".zip")) {
            File directory = Unpack.unZip(archive, "/home/neuroweb/tmp/staging/" + archive.getParent());
            return this.load_directory(directory.listFiles());
        }
        throw new Exception("Unsupported archive type: " + archive.getName());
    }

    public List<Session> load_xls(File spreadsheet) throws Exception {
        StoreStudy database = new StoreStudy(this.connection);
        ImageLoading image_loader = new ImageLoading(spreadsheet.getParent(), this.connection);
        FileInputStream input = new FileInputStream(spreadsheet);
        SpreadSheetReader reader = new SpreadSheetReader(SpreadSheetReader.InputType.BIFF);
        Study study = reader.read(input, spreadsheet.getParent());
        input.close();
        if (!study.getGrant_name().equals(this.study_name)) {
            return new ArrayList<Session>();
        }
        if (!image_loader.check_scans(study)) {
            System.out.println("Missing files...");
            return study.getSessions();
        }
        database.store(study);
        image_loader.queue_scans(study);
        return study.getSessions();
    }

    public List<Session> load_file(File file) throws Exception {
        if (file.getName().endsWith(".tar.gz") || file.getName().endsWith(".tar.bz2") || file.getName().endsWith(".zip")) {
            return this.load_archive(file);
        }
        if (!file.getName().endsWith(".xls")) {
            return null;
        }
        try {
            return this.load_xls(file);
        }
        catch (Exception e) {
            System.out.println("Exception, rolling back..");
            this.rollbackTransaction();
            throw e;
        }
    }

    public List<Session> load_directory(File[] list) throws Exception {
        if (list == null) {
            System.out.println("directory listing isn't working..null being passed to Upload.load_directory");
            return null;
        }
        ArrayList<Session> scan_images = new ArrayList<Session>();
        for (File file : list) {
            if (file.getName().startsWith(".")) continue;
            if (file.isDirectory()) {
                scan_images.addAll(this.load_directory(file.listFiles()));
                continue;
            }
            List<Session> scans_from_file = this.load_file(file);
            if (scans_from_file == null) continue;
            scan_images.addAll(scans_from_file);
        }
        return scan_images;
    }

    public static void printTime() {
        System.out.println(new Date(System.currentTimeMillis()));
    }

    public static Connection connect() {
        try {
            Class.forName("org.postgresql.Driver").newInstance();
            return DriverManager.getConnection("jdbc:postgresql://localhost:5432/neuroweb", "jchoyt", "ou812ic");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Connection connection;
        File incoming_dir;
        if (args.length != 1) {
            System.err.println("Please specify a directory to probe");
        }
        if (!(incoming_dir = new File(args[0])).exists()) {
            System.err.println("Directory " + incoming_dir + " does not exist");
            System.exit(-1);
        }
        if ((connection = Upload.connect()) == null) {
            System.err.println("Failed to connect to database...");
            System.exit(-1);
        }
        System.out.println("checking: " + incoming_dir);
        try {
            Upload upload = new Upload(connection, ".");
            List<Session> scans = upload.validate(incoming_dir);
            if (scans == null) {
                System.err.println("No scans found!");
                System.exit(-1);
            } else {
                System.out.println("\n\n\nExtracted Sessions:");
                for (Session scan : scans) {
                    for (Session.Image file : scan.getImages()) {
                        System.out.println(file.filename + ": " + (file.missing ? "missing" : "found"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }
}

