/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.neuro;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.util.Properties;
import org.mitre.neuro.Upload;
import org.mitre.neuro.containers.Session;
import org.mitre.neuro.database.StoreSession;

public class UploadComplete {
    public static String getStringProp(Properties props, String key) {
        String property = (String)props.get(key);
        return property;
    }

    public static double getDoubleProp(Properties props, String key) {
        String property = (String)props.get(key);
        if (property == null) {
            return -1.0;
        }
        try {
            return Double.parseDouble(property);
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    public static int getIntProp(Properties props, String key) {
        String property = (String)props.get(key);
        if (property == null) {
            return -1;
        }
        try {
            return Integer.parseInt(property);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static void saveStaticInfo(Connection connection, Properties props) {
        String destination = UploadComplete.getStringProp(props, "destination");
        String scan_date = UploadComplete.getStringProp(props, "scan_date");
        File dest = new File(destination);
        String scan_id = UploadComplete.getStringProp(props, "scan_id");
        int study_id = UploadComplete.getIntProp(props, "study_id");
        int subject_oid = UploadComplete.getIntProp(props, "subject_oid");
        String modality = UploadComplete.getStringProp(props, "modality");
        String state = UploadComplete.getStringProp(props, "state");
        String file_format = UploadComplete.getStringProp(props, "file_format");
        String numerical_format = UploadComplete.getStringProp(props, "numerical_format");
        int volume_id = UploadComplete.getIntProp(props, "volume_id");
        String algorithm_name = UploadComplete.getStringProp(props, "algorithm_name");
        String algorithm_version = UploadComplete.getStringProp(props, "algorithm_version");
        String algorithm_description = UploadComplete.getStringProp(props, "algorithm_description");
        int xfov = UploadComplete.getIntProp(props, "xfov");
        int xdimension = UploadComplete.getIntProp(props, "xdimension");
        String xorientation = UploadComplete.getStringProp(props, "xorientation");
        int xresolution = UploadComplete.getIntProp(props, "xresolution");
        int yfov = UploadComplete.getIntProp(props, "yfov");
        int ydimension = UploadComplete.getIntProp(props, "ydimension");
        String yorientation = UploadComplete.getStringProp(props, "yorientation");
        int yresolution = UploadComplete.getIntProp(props, "yresolution");
        int zfov = UploadComplete.getIntProp(props, "zfov");
        int zdimension = UploadComplete.getIntProp(props, "zdimension");
        String zorientation = UploadComplete.getStringProp(props, "zorientation");
        int zresolution = UploadComplete.getIntProp(props, "zresolution");
        String preview_axial = (String)props.get("preview_axial");
        String preview_coronal = (String)props.get("preview_coronal");
        String preview_sagittal = (String)props.get("preview_sagittal");
        Session scan = new Session();
        Session.Image image = scan.addImage();
        scan.setDate_taken(scan_date);
        image.path = destination;
        image.study_id = study_id;
        image.subject_oid = subject_oid;
        image.volume_id = volume_id;
        image.modality = modality;
        image.numerical_format = numerical_format;
        image.algorithm_name = algorithm_name;
        image.algorithm_version = algorithm_version;
        image.algorithm_description = algorithm_description;
        image.xfov = xfov;
        image.xdimension = xdimension;
        image.xorientation = xorientation;
        image.xresolution = xresolution;
        image.yfov = yfov;
        image.ydimension = ydimension;
        image.yorientation = yorientation;
        image.yresolution = yresolution;
        image.zfov = zfov;
        image.zdimension = zdimension;
        image.zorientation = zorientation;
        image.zresolution = zresolution;
        image.preview_axial = preview_axial;
        image.preview_coronal = preview_coronal;
        image.preview_sagittal = preview_sagittal;
        StoreSession store = new StoreSession(connection);
        store.store_session_event(scan, image);
        store.store_image(image);
        store.store_scanfile(image);
    }

    public static void saveEAVinfo(Connection connecton, Properties props) {
    }

    public static void saveProcessInfo(Connection connection, Properties props) {
        String original = (String)props.get("file");
        System.out.println(original + " successfully processed! Saving metadata...");
        UploadComplete.saveStaticInfo(connection, props);
        UploadComplete.saveEAVinfo(connection, props);
    }

    public static void main(String[] args) {
        Connection connection;
        File output_file;
        if (args.length != 1) {
            System.err.println("Please specify a directory to probe");
        }
        if (!(output_file = new File(args[0])).exists()) {
            System.err.println(output_file.getName() + " does not exist");
            System.exit(-1);
        }
        if ((connection = Upload.connect()) == null) {
            System.err.println("Failed to connect to database...");
            System.exit(-1);
        }
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(output_file));
            for (Object key_obj : props.keySet()) {
                String key = (String)key_obj;
                String value = (String)props.get(key_obj);
                if (!key.equalsIgnoreCase("status") || !value.equalsIgnoreCase("OK")) continue;
                UploadComplete.saveProcessInfo(connection, props);
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Upload completion failure");
        System.exit(-1);
    }
}

