/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.neuro.excel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.mitre.neuro.excel.Datum;
import org.mitre.neuro.excel.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Worksheet {
    String title;
    HashMap<Integer, Row> rows = new HashMap();
    int cardinality;
    int max_row;
    int max_width;

    public Worksheet(String title, int cardinality) {
        this.title = title;
        this.max_row = 0;
        this.max_width = 0;
    }

    public void addRow(Row row) {
        this.rows.put(row.getIndex(), row);
        if (row.getIndex() > this.max_row) {
            this.max_row = row.getIndex();
        }
        if (row.getMax() > this.max_width) {
            this.max_width = row.getMax();
        }
    }

    public List<HashMap<String, Datum>> extractVerticalTuples(int meta_column, int start_row) {
        ArrayList<HashMap<String, Datum>> tuples = new ArrayList<HashMap<String, Datum>>();
        String[] meta = new String[this.max_row + 1];
        for (int i = start_row; i <= this.max_row; ++i) {
            Datum d = this.getCell(i, meta_column);
            if (d == null) continue;
            meta[i] = d.getString_dat();
        }
        for (int column_index = meta_column + 1; column_index <= this.max_width; ++column_index) {
            HashMap<String, Datum> tuple = new HashMap<String, Datum>();
            for (int row_index = start_row; row_index <= this.max_row; ++row_index) {
                Datum d = this.getCell(row_index, column_index);
                if (d == null || d.getT() == Datum.Type.EMPTY) continue;
                if (meta[row_index] == null) {
                    System.err.println("horizontal field out of bounds: " + column_index);
                    continue;
                }
                tuple.put(meta[row_index], d);
            }
            if (tuple.size() <= 0) continue;
            tuples.add(tuple);
        }
        return tuples;
    }

    public List<HashMap<String, Datum>> extractHorizontalTuples(int meta_row) {
        ArrayList<HashMap<String, Datum>> tuples = new ArrayList<HashMap<String, Datum>>();
        Object[] rows = new Integer[this.rows.size()];
        System.out.println("Rows on this sheet: " + this.rows.size());
        this.rows.keySet().toArray(rows);
        Arrays.sort(rows);
        Row naming = this.rows.get(meta_row);
        String[] meta = new String[naming.getMax() + 1];
        for (int index : naming.getColumns()) {
            Datum d = naming.getColumn(index);
            if (d == null) continue;
            meta[index] = d.getString_dat();
        }
        Object[] arr$ = rows;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int row_index = (Integer)arr$[i$];
            if (row_index <= meta_row) continue;
            Row row = this.rows.get(row_index);
            HashMap<String, Datum> tuple = new HashMap<String, Datum>();
            for (int column_index : row.getColumns()) {
                if (meta[column_index] == null) {
                    System.err.println("horizontal field out of bounds: " + column_index);
                    continue;
                }
                Datum d = this.getCell(row_index, column_index);
                if (d == null || d.getT() == Datum.Type.EMPTY) continue;
                tuple.put(meta[column_index], d);
            }
            if (tuple.size() <= 0) continue;
            tuples.add(tuple);
        }
        return tuples;
    }

    public Collection<Row> getRows() {
        return this.rows.values();
    }

    public Datum getCell(int row_index, int column_index) {
        Row row = this.getRow(row_index);
        if (row == null) {
            return null;
        }
        return row.getColumn(column_index);
    }

    public void setCell(Datum d, int row_index, int column_index) {
        Row row = this.getOrAddRow(row_index);
        row.addColumn(column_index, d);
    }

    public Row getRow(int row_index) {
        if (!this.rows.containsKey(row_index)) {
            return null;
        }
        return this.rows.get(row_index);
    }

    public Row getOrAddRow(int row_index) {
        Row row = this.getRow(row_index);
        if (row == null) {
            row = new Row(row_index);
            this.addRow(row);
        }
        return row;
    }

    public int getSize() {
        return this.rows.size();
    }

    public void clear() {
        for (Row row : this.rows.values()) {
            row.clear();
        }
        this.rows.clear();
    }

    public String getName() {
        return this.title;
    }

    public int getCardinality() {
        return this.cardinality;
    }
}

