/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.neuro.excel.biff;

import java.io.OutputStream;
import java.util.Arrays;
import jxl.Workbook;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.mitre.neuro.excel.Datum;
import org.mitre.neuro.excel.ExcelGenerator;
import org.mitre.neuro.excel.Row;
import org.mitre.neuro.excel.Worksheet;

public class GenerateBIFF
extends ExcelGenerator {
    WritableCellFormat locked_cell = new WritableCellFormat();
    WritableCellFormat fillable_cell;

    public GenerateBIFF() throws Exception {
        this.locked_cell.setBackground(Colour.GRAY_25);
        this.locked_cell.setLocked(true);
        this.locked_cell.setBorder(Border.ALL, BorderLineStyle.THIN);
        this.fillable_cell = new WritableCellFormat();
        this.fillable_cell.setBackground(Colour.VERY_LIGHT_YELLOW);
        this.fillable_cell.setBorder(Border.ALL, BorderLineStyle.THIN);
    }

    public void getSpreadSheet(OutputStream stream) throws Exception {
        WritableWorkbook workbook = Workbook.createWorkbook((OutputStream)stream);
        Object[] sheet_numbers = new Integer[this.worksheets.keySet().size()];
        this.worksheets.keySet().toArray(sheet_numbers);
        Arrays.sort(sheet_numbers);
        for (Object number : sheet_numbers) {
            Worksheet sheet = (Worksheet)this.worksheets.get(number);
            WritableSheet sheetwriter = workbook.createSheet(sheet.getName(), ((Integer)number).intValue());
            this.writeSheet(sheetwriter, sheet);
        }
        workbook.write();
        workbook.close();
    }

    protected void writeSheet(WritableSheet writer, Worksheet sheet) throws Exception {
        for (Row row : sheet.getRows()) {
            for (Integer column_index : row.getColumns()) {
                Datum d = row.getColumn(column_index);
                int y = row.getIndex();
                int x = column_index;
                WritableCell cell = this.getCell(x, y, d);
                if (cell == null) {
                    System.err.println("bad cell defined for (" + x + ", " + y + ")");
                    continue;
                }
                writer.addCell(cell);
            }
        }
    }

    protected WritableCell getCell(int x, int y, Datum d) {
        switch (d.getT()) {
            case STRING: {
                return new Label(x, y, d.getString_dat(), (CellFormat)this.locked_cell);
            }
            case NUMBER: {
                return new Number(x, y, d.getNumber_dat());
            }
            case EMPTY: {
                return new Label(x, y, "", (CellFormat)this.fillable_cell);
            }
        }
        return null;
    }
}

