/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse;

import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Entity;
import edu.berkeley.guir.prefuse.graph.Node;

public class EdgeItem
extends VisualItem
implements Edge {
    protected NodeItem m_node1;
    protected NodeItem m_node2;

    public void init(ItemRegistry itemRegistry, String string, Entity entity) {
        if (entity != null && !(entity instanceof Edge)) {
            throw new IllegalArgumentException("EdgeItem can only represent an Entity of type Edge.");
        }
        super.init(itemRegistry, string, entity);
        Edge edge = (Edge)entity;
        Node node = edge.getFirstNode();
        Node node2 = edge.getSecondNode();
        NodeItem nodeItem = this.getItem(node);
        this.setFirstNode(nodeItem);
        NodeItem nodeItem2 = this.getItem(node2);
        this.setSecondNode(nodeItem2);
    }

    protected NodeItem getItem(Node node) {
        return this.m_registry.getNodeItem(node);
    }

    private void nodeItemCheck(Node node) {
        if (!(node instanceof NodeItem)) {
            throw new IllegalArgumentException("Node must be an instance of NodeItem");
        }
    }

    public boolean isDirected() {
        return ((Edge)this.m_entity).isDirected();
    }

    public boolean isTreeEdge() {
        NodeItem nodeItem = this.m_node1;
        NodeItem nodeItem2 = this.m_node2;
        return nodeItem.getParent() == nodeItem2 || nodeItem2.getParent() == nodeItem;
    }

    public Node getAdjacentNode(Node node) {
        this.nodeItemCheck(node);
        if (this.m_node1 == node) {
            return this.m_node2;
        }
        if (this.m_node2 == node) {
            return this.m_node1;
        }
        throw new IllegalArgumentException("The given node is not incident on this Edge.");
    }

    public Node getFirstNode() {
        return this.m_node1;
    }

    public void setFirstNode(Node node) {
        this.nodeItemCheck(node);
        this.m_node1 = (NodeItem)node;
    }

    public Node getSecondNode() {
        return this.m_node2;
    }

    public void setSecondNode(Node node) {
        this.nodeItemCheck(node);
        this.m_node2 = (NodeItem)node;
    }

    public boolean isIncident(Node node) {
        return node == this.m_node1 || node == this.m_node2;
    }
}

