/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse;

import edu.berkeley.guir.prefuse.FocusManager;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.graph.Entity;
import edu.berkeley.guir.prefuse.render.Renderer;
import edu.berkeley.guir.prefuse.util.FontLib;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

public abstract class VisualItem
implements Entity {
    protected ItemRegistry m_registry;
    protected String m_itemClass;
    protected Entity m_entity;
    protected int m_dirty;
    protected boolean m_visible;
    protected boolean m_newlyVisible;
    protected boolean m_interactive;
    protected Map m_attrs;
    protected double m_doi;
    protected Point2D m_location = new Point2D.Float(Float.NaN, Float.NaN);
    protected Point2D m_startLocation = new Point2D.Float(Float.NaN, Float.NaN);
    protected Point2D m_endLocation = new Point2D.Float(Float.NaN, Float.NaN);
    protected Paint m_color;
    protected Paint m_startColor;
    protected Paint m_endColor;
    protected Paint m_fillColor;
    protected Paint m_startFillColor;
    protected Paint m_endFillColor;
    protected double m_size;
    protected double m_startSize;
    protected double m_endSize;
    protected Font m_startFont;
    protected Font m_font;
    protected Font m_endFont;
    protected boolean m_fixed = false;
    protected boolean m_wasFixed = false;
    protected boolean m_highlight = false;

    public String toString() {
        String string = this.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        return string2 + "{" + this.m_entity + "}";
    }

    public void init(ItemRegistry itemRegistry, String string, Entity entity) {
        this.m_itemClass = string;
        this.m_registry = itemRegistry;
        this.m_entity = entity;
        this.m_dirty = 0;
        this.m_visible = false;
        this.m_newlyVisible = false;
        this.m_doi = -2.147483648E9;
        this.m_interactive = true;
        this.m_fixed = false;
        this.m_wasFixed = false;
        this.m_highlight = false;
        this.initAttributes();
    }

    protected void initAttributes() {
        if (this.m_attrs != null) {
            this.m_attrs.clear();
        }
        this.m_location.setLocation(Double.NaN, Double.NaN);
        this.m_startLocation.setLocation(Double.NaN, Double.NaN);
        this.m_endLocation.setLocation(Double.NaN, Double.NaN);
        this.m_color = Color.BLACK;
        this.m_startColor = Color.BLACK;
        this.m_endColor = Color.BLACK;
        this.m_fillColor = Color.LIGHT_GRAY;
        this.m_startFillColor = Color.LIGHT_GRAY;
        this.m_endFillColor = Color.LIGHT_GRAY;
        this.m_size = 1.0;
        this.m_startSize = 1.0;
        this.m_endSize = 1.0;
        this.m_font = this.m_startFont = FontLib.getFont("SansSerif", 0, 10);
        this.m_endFont = this.m_startFont;
    }

    private void initVizAttributes() {
        this.m_attrs = new HashMap(5, 0.9f);
    }

    public void clear() {
        this.m_registry = null;
        this.m_entity = null;
        this.initAttributes();
    }

    public ItemRegistry getItemRegistry() {
        return this.m_registry;
    }

    public String getItemClass() {
        return this.m_itemClass;
    }

    public Entity getEntity() {
        return this.m_entity;
    }

    public String getAttribute(String string) {
        if (this.m_entity == null) {
            throw new IllegalStateException("This item has no assigned entity.");
        }
        return this.m_entity.getAttribute(string);
    }

    public void setAttribute(String string, String string2) {
        if (this.m_entity == null) {
            throw new IllegalStateException("This item has no assigned entity.");
        }
        this.m_entity.setAttribute(string, string2);
    }

    public Map getAttributes() {
        return this.m_entity.getAttributes();
    }

    public void setAttributes(Map map) {
        this.m_entity.setAttributes(map);
    }

    public void clearAttributes() {
        this.m_entity.clearAttributes();
    }

    public Object getVizAttribute(String string) {
        if (this.m_attrs != null) {
            return this.m_attrs.get(string);
        }
        return null;
    }

    public void setVizAttribute(String string, Object object) {
        if (this.m_attrs == null) {
            this.initVizAttributes();
        }
        this.m_attrs.put(string, object);
    }

    public void removeVizAttribute(String string) {
        if (this.m_attrs != null) {
            this.m_attrs.remove(string);
        }
    }

    public void updateVizAttribute(String string, String string2, String string3, Object object) {
        Object object2 = this.getVizAttribute(string);
        this.setVizAttribute(string2, object2);
        this.setVizAttribute(string3, object);
    }

    public void touch() {
        this.m_dirty = 0;
    }

    public int getDirty() {
        return this.m_dirty;
    }

    public void setDirty(int n) {
        this.m_dirty = n;
    }

    public boolean isNewlyVisible() {
        return this.m_newlyVisible;
    }

    public boolean isVisible() {
        return this.m_visible;
    }

    public void setVisible(boolean bl) {
        this.m_newlyVisible = !this.m_visible && bl;
        this.m_visible = bl;
    }

    public boolean isFocus() {
        FocusManager focusManager = this.m_registry.getFocusManager();
        return focusManager.isFocus(this.m_entity);
    }

    public Renderer getRenderer() {
        try {
            return this.m_registry.getRendererFactory().getRenderer(this);
        }
        catch (Exception exception) {
            System.out.println("processing reclaimed item!!! -- " + this.getClass().getName());
            return null;
        }
    }

    public boolean locatePoint(Point2D point2D) {
        return this.getRenderer().locatePoint(point2D, this);
    }

    public Rectangle2D getBounds() {
        return this.getRenderer().getBoundsRef(this);
    }

    public boolean isFixed() {
        return this.m_fixed;
    }

    public void setFixed(boolean bl) {
        this.m_wasFixed = this.m_fixed;
        this.m_fixed = bl;
    }

    public boolean wasFixed() {
        return this.m_wasFixed;
    }

    public void setWasFixed(boolean bl) {
        this.m_wasFixed = bl;
    }

    public boolean isHighlighted() {
        return this.m_highlight;
    }

    public void setHighlighted(boolean bl) {
        this.m_highlight = bl;
    }

    public double getDOI() {
        return this.m_doi;
    }

    public void setDOI(double d) {
        this.m_doi = d;
    }

    public Point2D getStartLocation() {
        return this.m_startLocation;
    }

    public Point2D getEndLocation() {
        return this.m_endLocation;
    }

    public Point2D getLocation() {
        return this.m_location;
    }

    public void setLocation(Point2D point2D) {
        this.m_location.setLocation(point2D);
    }

    public void setLocation(double d, double d2) {
        this.m_location.setLocation(d, d2);
    }

    public void setStartLocation(Point2D point2D) {
        this.m_startLocation.setLocation(point2D);
    }

    public void setStartLocation(double d, double d2) {
        this.m_startLocation.setLocation(d, d2);
    }

    public void setEndLocation(Point2D point2D) {
        this.m_endLocation.setLocation(point2D);
    }

    public void setEndLocation(double d, double d2) {
        this.m_endLocation.setLocation(d, d2);
    }

    public void updateLocation(Point2D point2D) {
        this.m_startLocation.setLocation(this.m_location);
        this.m_endLocation.setLocation(point2D);
    }

    public void updateLocation(double d, double d2) {
        this.m_startLocation.setLocation(this.m_location);
        this.m_endLocation.setLocation(d, d2);
    }

    public double getX() {
        return this.m_location.getX();
    }

    public double getY() {
        return this.m_location.getY();
    }

    public Paint getStartColor() {
        return this.m_startColor;
    }

    public Paint getEndColor() {
        return this.m_endColor;
    }

    public Paint getColor() {
        return this.m_color;
    }

    public void setColor(Paint paint) {
        this.m_color = paint;
    }

    public void updateColor(Paint paint) {
        this.m_startColor = this.m_color;
        this.m_endColor = paint;
    }

    public Paint getStartFillColor() {
        return this.m_startFillColor;
    }

    public Paint getEndFillColor() {
        return this.m_endFillColor;
    }

    public Paint getFillColor() {
        return this.m_fillColor;
    }

    public void setFillColor(Paint paint) {
        this.m_fillColor = paint;
    }

    public void updateFillColor(Paint paint) {
        this.m_startFillColor = this.m_fillColor;
        this.m_endFillColor = paint;
    }

    public double getStartSize() {
        return this.m_startSize;
    }

    public double getEndSize() {
        return this.m_endSize;
    }

    public double getSize() {
        return this.m_size;
    }

    public void setSize(double d) {
        this.m_size = d;
    }

    public void setStartSize(double d) {
        this.m_startSize = d;
    }

    public void setEndSize(double d) {
        this.m_endSize = d;
    }

    public void updateSize(double d) {
        this.m_startSize = this.m_size;
        this.m_endSize = d;
    }

    public Font getStartFont() {
        return this.m_startFont;
    }

    public void setStartFont(Font font) {
        this.m_startFont = font;
    }

    public Font getFont() {
        return this.m_font;
    }

    public void setFont(Font font) {
        this.m_font = font;
    }

    public Font getEndFont() {
        return this.m_endFont;
    }

    public void setEndFont(Font font) {
        this.m_endFont = font;
    }

    public void updateFont(Font font) {
        this.m_startFont = this.m_font;
        this.m_endFont = font;
    }

    public boolean isInteractive() {
        return this.m_interactive;
    }

    public void setInteractive(boolean bl) {
        this.m_interactive = bl;
    }
}

