/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.action.assignment;

import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.AbstractAction;
import java.awt.Color;
import java.awt.Paint;
import java.util.Iterator;

public class ColorFunction
extends AbstractAction {
    protected Color defaultColor = Color.BLACK;
    protected Color focusColor = Color.RED;
    protected Color highlightColor = Color.BLUE;
    protected Color defaultFillColor = Color.WHITE;
    protected Color focusFillColor = Color.WHITE;
    protected Color highlightFillColor = Color.WHITE;

    public void run(ItemRegistry itemRegistry, double d) {
        Iterator iterator = itemRegistry.getItems();
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            Paint paint = this.getColor(visualItem);
            Paint paint2 = visualItem.getColor();
            if (paint2 == null) {
                visualItem.setColor(this.getInitialColor(visualItem));
            }
            visualItem.updateColor(paint);
            visualItem.setColor(paint);
            paint = this.getFillColor(visualItem);
            paint2 = visualItem.getFillColor();
            if (paint2 == null) {
                visualItem.setFillColor(this.getInitialFillColor(visualItem));
            }
            visualItem.updateFillColor(paint);
            visualItem.setFillColor(paint);
        }
    }

    protected Paint getInitialColor(VisualItem visualItem) {
        return this.getColor(visualItem);
    }

    protected Paint getInitialFillColor(VisualItem visualItem) {
        return this.getFillColor(visualItem);
    }

    public Paint getColor(VisualItem visualItem) {
        if (visualItem.isFocus()) {
            return this.focusColor;
        }
        if (visualItem.isHighlighted()) {
            return this.highlightColor;
        }
        return this.defaultColor;
    }

    public Paint getFillColor(VisualItem visualItem) {
        if (visualItem.isFocus()) {
            return this.focusFillColor;
        }
        if (visualItem.isHighlighted()) {
            return this.highlightFillColor;
        }
        return this.defaultFillColor;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color color) {
        this.defaultColor = color;
    }

    public Color getDefaultFillColor() {
        return this.defaultFillColor;
    }

    public void setDefaultFillColor(Color color) {
        this.defaultFillColor = color;
    }

    public Color getFocusColor() {
        return this.focusColor;
    }

    public void setFocusColor(Color color) {
        this.focusColor = color;
    }

    public Color getFocusFillColor() {
        return this.focusFillColor;
    }

    public void setFocusFillColor(Color color) {
        this.focusFillColor = color;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public Color getHighlightFillColor() {
        return this.highlightFillColor;
    }

    public void setHighlightFillColor(Color color) {
        this.highlightFillColor = color;
    }
}

