/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.action.filter;

import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.filter.Filter;
import edu.berkeley.guir.prefuse.graph.DefaultGraph;
import edu.berkeley.guir.prefuse.graph.Edge;
import edu.berkeley.guir.prefuse.graph.Entity;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.Node;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FisheyeGraphFilter
extends Filter {
    public static final String[] ITEM_CLASSES = new String[]{"node", "edge"};
    public static final int DEFAULT_MIN_DOI = -2;
    public static final String ATTR_CENTER = "center";
    private int m_minDOI;
    private boolean m_edgesVisible = true;
    private boolean m_edgesInteractive = true;
    private List m_queue = new LinkedList();

    public FisheyeGraphFilter() {
        this(-2);
    }

    public FisheyeGraphFilter(int n) {
        this(n, true);
    }

    public FisheyeGraphFilter(int n, boolean bl) {
        this(n, bl, true);
    }

    public FisheyeGraphFilter(int n, boolean bl, boolean bl2) {
        super(ITEM_CLASSES, bl2);
        this.m_minDOI = n;
        this.m_edgesVisible = bl;
    }

    protected Iterator getFoci(ItemRegistry itemRegistry) {
        Iterator iterator = itemRegistry.getDefaultFocusSet().iterator();
        if (!iterator.hasNext()) {
            iterator = Collections.EMPTY_LIST.iterator();
        }
        return iterator;
    }

    public void run(ItemRegistry itemRegistry, double d) {
        Node node;
        Entity entity;
        Node node2;
        Node node3;
        Object object;
        Graph graph = itemRegistry.getGraph();
        Graph graph2 = itemRegistry.getFilteredGraph();
        if (graph2 instanceof DefaultGraph) {
            ((DefaultGraph)graph2).reinit(graph.isDirected());
        } else {
            graph2 = new DefaultGraph(graph.isDirected());
        }
        Iterator iterator = this.getFoci(itemRegistry);
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof Node)) continue;
            node3 = (Node)object;
            node2 = itemRegistry.getNodeItem(node3);
            boolean bl = false;
            boolean bl2 = bl = node2 == null || ((VisualItem)((Object)node2)).getDirty() > 0 || ((VisualItem)((Object)node2)).getDOI() < 0.0;
            if (node2 == null || ((VisualItem)((Object)node2)).getDirty() > 0) {
                node2 = itemRegistry.getNodeItem(node3, true, true);
            }
            graph2.addNode(node2);
            if (!bl) continue;
            ((VisualItem)((Object)node2)).setDOI(0.0);
            this.m_queue.add(node2);
            while (!this.m_queue.isEmpty()) {
                entity = (NodeItem)this.m_queue.remove(0);
                node = (Node)((VisualItem)entity).getEntity();
                double d2 = ((VisualItem)entity).getDOI() - 1.0;
                if (!(d2 >= (double)this.m_minDOI)) continue;
                Iterator iterator2 = node.getNeighbors();
                boolean bl3 = false;
                while (iterator2.hasNext()) {
                    Node node4 = (Node)iterator2.next();
                    NodeItem nodeItem = itemRegistry.getNodeItem(node4);
                    boolean bl4 = bl = nodeItem == null || nodeItem.getDirty() > 0 || nodeItem.getDOI() < d2;
                    if (nodeItem == null || nodeItem.getDirty() > 0) {
                        nodeItem = itemRegistry.getNodeItem(node4, true, true);
                    }
                    graph2.addNode(nodeItem);
                    if (!bl) continue;
                    nodeItem.setDOI(d2);
                    this.m_queue.add(nodeItem);
                }
            }
        }
        object = itemRegistry.getNodeItems();
        while (object.hasNext()) {
            node3 = (NodeItem)object.next();
            if (((VisualItem)((Object)node3)).getDirty() > 0) continue;
            node2 = (Node)((VisualItem)((Object)node3)).getEntity();
            Iterator iterator3 = node2.getEdges();
            while (iterator3.hasNext()) {
                entity = (Edge)iterator3.next();
                node = entity.getAdjacentNode(node2);
                NodeItem nodeItem = itemRegistry.getNodeItem(node);
                if (nodeItem == null || nodeItem.getDirty() != 0) continue;
                EdgeItem edgeItem = itemRegistry.getEdgeItem((Edge)entity, true);
                graph2.addEdge(edgeItem);
                if (!this.m_edgesVisible) {
                    edgeItem.setVisible(false);
                }
                if (this.m_edgesInteractive) continue;
                edgeItem.setInteractive(false);
            }
        }
        itemRegistry.setFilteredGraph(graph2);
        super.run(itemRegistry, d);
    }

    public boolean isEdgesVisible() {
        return this.m_edgesVisible;
    }

    public void setEdgesVisible(boolean bl) {
        this.m_edgesVisible = bl;
    }

    public int getMinDOI() {
        return this.m_minDOI;
    }

    public void setMinDOI(int n) {
        this.m_minDOI = n;
    }

    public boolean isEdgesInteractive() {
        return this.m_edgesInteractive;
    }

    public void setEdgesInteractive(boolean bl) {
        this.m_edgesInteractive = bl;
    }
}

