/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefuse.activity;

import edu.berkeley.guir.prefuse.activity.ActivityManager;
import edu.berkeley.guir.prefuse.activity.Pacer;
import edu.berkeley.guir.prefuse.event.ActivityEventMulticaster;
import edu.berkeley.guir.prefuse.event.ActivityListener;
import java.util.ArrayList;
import java.util.List;

public abstract class Activity {
    public static final long DEFAULT_STEP_TIME = 20L;
    private static final int SCHEDULED = 0;
    private static final int STARTED = 1;
    private static final int STEPPED = 2;
    private static final int FINISHED = 3;
    private static final int CANCELLED = 4;
    private boolean m_enabled = true;
    private Pacer m_pacer;
    private long m_startTime = -1L;
    private long m_duration = -1L;
    private long m_stepTime = -1L;
    private long m_nextTime = -1L;
    private boolean m_isRunning = false;
    private boolean m_isScheduled = false;
    private ActivityListener m_listener;
    private List m_tmp = new ArrayList();

    public Activity(long l) {
        this(l, 20L);
    }

    public Activity(long l, long l2) {
        this(l, l2, System.currentTimeMillis());
    }

    public Activity(long l, long l2, long l3) {
        this.m_startTime = l3;
        this.m_nextTime = l3;
        this.m_duration = l;
        this.m_stepTime = l2;
    }

    public void run() {
        ActivityManager.schedule(this);
    }

    public void runNow() {
        ActivityManager.scheduleNow(this);
    }

    public void runAt(long l) {
        ActivityManager.scheduleAt(this, l);
    }

    public void runAfter(Activity activity) {
        ActivityManager.scheduleAfter(activity, this);
    }

    public void alwaysRunAfter(Activity activity) {
        ActivityManager.alwaysScheduleAfter(activity, this);
    }

    protected abstract void run(long var1);

    long runActivity(long l) {
        if (l < this.m_startTime) {
            return this.m_startTime - l;
        }
        long l2 = l - this.m_startTime;
        if (this.m_duration == 0L || l > this.getStopTime()) {
            if (!this.isRunning()) {
                this.setRunning(true);
                if (this.m_listener != null) {
                    this.m_listener.activityStarted(this);
                }
            }
            if (this.m_enabled) {
                this.run(l2);
                if (this.m_listener != null) {
                    this.m_listener.activityStepped(this);
                }
            }
            this.setRunning(false);
            if (this.m_listener != null) {
                this.m_listener.activityFinished(this);
            }
            ActivityManager.removeActivity(this);
            return -1L;
        }
        if (l >= this.m_nextTime) {
            if (!this.isRunning()) {
                this.setRunning(true);
                if (this.m_listener != null) {
                    this.m_listener.activityStarted(this);
                }
            }
            if (this.m_enabled) {
                this.run(l2);
                this.m_nextTime = l + this.m_stepTime;
                if (this.m_listener != null) {
                    this.m_listener.activityStepped(this);
                }
            }
            this.m_nextTime = l + this.m_stepTime;
        }
        return this.m_nextTime - l;
    }

    public void cancel() {
        if (this.isScheduled()) {
            if (this.m_listener != null) {
                this.m_listener.activityCancelled(this);
            }
            ActivityManager.removeActivity(this);
        }
        this.setRunning(false);
    }

    public synchronized boolean isScheduled() {
        return this.m_isScheduled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setScheduled(boolean bl) {
        Activity activity = this;
        synchronized (activity) {
            boolean bl2 = bl && !this.m_isScheduled;
            this.m_isScheduled = bl;
        }
        if (this.m_listener != null) {
            this.m_listener.activityScheduled(this);
        }
    }

    protected synchronized void setRunning(boolean bl) {
        this.m_isRunning = bl;
    }

    public synchronized boolean isRunning() {
        return this.m_isRunning;
    }

    public void addActivityListener(ActivityListener activityListener) {
        this.m_listener = ActivityEventMulticaster.add(this.m_listener, activityListener);
    }

    public void removeActivityListener(ActivityListener activityListener) {
        this.m_listener = ActivityEventMulticaster.remove(this.m_listener, activityListener);
    }

    public double getPace(long l) {
        long l2 = this.getDuration();
        double d = l2 == 0L ? 0.0 : (double)l / (double)l2;
        d = Math.min(1.0, Math.max(0.0, d));
        return this.m_pacer != null ? this.m_pacer.pace(d) : d;
    }

    public synchronized Pacer getPacingFunction() {
        return this.m_pacer;
    }

    public synchronized void setPacingFunction(Pacer pacer) {
        this.m_pacer = pacer;
    }

    public long getStopTime() {
        if (this.m_duration == -1L) {
            return Long.MAX_VALUE;
        }
        return this.m_startTime + this.m_duration;
    }

    public long getNextTime() {
        return this.m_nextTime;
    }

    public long getDuration() {
        return this.m_duration;
    }

    public void setDuration(long l) {
        this.m_duration = l;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public void setStartTime(long l) {
        this.m_startTime = l;
    }

    public long getStepTime() {
        return this.m_stepTime;
    }

    public void setStepTime(long l) {
        this.m_stepTime = l;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean bl) {
        this.m_enabled = bl;
    }
}

